<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

// Register Custom Post Type Property
add_action( 'init', 'luxus_property_cpt', 0 );
function luxus_property_cpt() {

	$labels = array(
		'name' => _x( 'Properties', 'Post Type General Name', 'luxus-core' ),
		'singular_name' => _x( 'Property', 'Post Type Singular Name', 'luxus-core' ),
		'menu_name' => _x( 'Properties', 'Admin Menu text', 'luxus-core' ),
		'name_admin_bar' => _x( 'Property', 'Add New on Toolbar', 'luxus-core' ),
		'archives' => __( 'Property Archives', 'luxus-core' ),
		'attributes' => __( 'Property Attributes', 'luxus-core' ),
		'parent_item_colon' => __( 'Parent Property:', 'luxus-core' ),
		'all_items' => __( 'All Properties', 'luxus-core' ),
		'add_new_item' => __( 'Add New Property', 'luxus-core' ),
		'add_new' => __( 'Add New', 'luxus-core' ),
		'new_item' => __( 'New Property', 'luxus-core' ),
		'edit_item' => __( 'Edit Property', 'luxus-core' ),
		'update_item' => __( 'Update Property', 'luxus-core' ),
		'view_item' => __( 'View Property', 'luxus-core' ),
		'view_items' => __( 'View Properties', 'luxus-core' ),
		'search_items' => __( 'Search Property', 'luxus-core' ),
		'not_found' => __( 'Not found', 'luxus-core' ),
		'not_found_in_trash' => __( 'Not found in Trash', 'luxus-core' ),
		'featured_image' => __( 'Featured Image', 'luxus-core' ),
		'set_featured_image' => __( 'Set featured image', 'luxus-core' ),
		'remove_featured_image' => __( 'Remove featured image', 'luxus-core' ),
		'use_featured_image' => __( 'Use as featured image', 'luxus-core' ),
		'insert_into_item' => __( 'Insert into Property', 'luxus-core' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Property', 'luxus-core' ),
		'items_list' => __( 'Properties list', 'luxus-core' ),
		'items_list_navigation' => __( 'Properties list navigation', 'luxus-core' ),
		'filter_items_list' => __( 'Filter Properties list', 'luxus-core' ),
	);
	$args = array(
		'label' => __( 'Property', 'luxus-core' ),
		'description' => __( 'Properties', 'luxus-core' ),
		'labels' => $labels,
		'menu_icon' => 'data:image/svg+xml;base64,' . base64_encode('<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" fill="black" x="0px" y="0px" viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve"><path d="M504.017,217.881L271.571,6.567l-2.221-2.019c-1.526-1.387-3.202-2.514-4.973-3.381c-0.079-0.038-0.161-0.066-0.24-0.104c-5.772-2.738-12.503-2.738-18.276,0c-0.079,0.037-0.161,0.065-0.24,0.104c-1.771,0.867-3.447,1.994-4.973,3.381l-2.189,1.99L5.983,217.881c-8.718,7.925-9.361,21.418-1.435,30.136c7.925,8.718,21.418,9.361,30.136,1.435l6.983-6.348v246.563C41.667,501.449,51.218,511,63,511h106.667h170.667H447c11.782,0,21.333-9.551,21.333-21.333V243.104l6.983,6.348c8.718,7.926,22.21,7.283,30.136-1.435C513.378,239.299,512.735,225.807,504.017,217.881zM212.333,468.334v-128c0-23.567,19.099-42.667,42.667-42.667s42.667,19.099,42.667,42.667v128H212.333z M425.667,468.334h-85.333v-128C340.334,293.202,302.132,255,255,255s-85.333,38.202-85.333,85.333v128H84.333V204.32L255,49.165L425.667,204.32V468.334z"/></svg>'),
		'supports' => array('title', 'editor', 'thumbnail', 'author'),
		'supports' => array('title', 'editor', 'thumbnail', 'revisions', 'author', 'comments'),
		'public' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'menu_position' => 5,
		'show_in_admin_bar' => true,
		'show_in_nav_menus' => true,
		'can_export' => true,
		'has_archive' => true,
		'hierarchical' => true,
		'exclude_from_search' => false,
		'show_in_rest' => true,
		'publicly_queryable' => true,
		'capability_type' => 'post',
	);
	register_post_type( 'property', $args );

}

// Custom Post Type 'Property' Taxonomy
require_once dirname( __FILE__ ) . '/taxonomies/property-taxonomies.php';

// Register Widget Area
require_once dirname( __FILE__ ) . '/widgets/register-widget-area.php';

// Custom Post Type 'Property' Advance Search
require_once dirname( __FILE__ ) . '/widgets/sidebar-widgets/advance-search.php';

// Custom Post Type 'Property' Featured Widget
require_once dirname( __FILE__ ) . '/widgets/sidebar-widgets/featured-property.php';

// Mortgage Calculator Widget
require_once dirname( __FILE__ ) . '/widgets/sidebar-widgets/mortgage-calculator.php';