<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

// Custom function for get page meta
if ( ! function_exists( 'luxus_page_meta' ) ) {

  function luxus_page_meta( $key = '', $default = null ) {

    $meta = get_post_meta( get_the_ID(), 'sl_page_options', true );
    return ( isset( $meta[$key] ) ) ? $meta[$key] : $default;

  }

}

// Custom function for get post meta
if ( ! function_exists( 'luxus_post_meta' ) ) {

  function luxus_post_meta( $key = '', $id = '', $default = null ) {

    $get_the_id = ( !empty( $id ) ? $id : get_the_ID() );

    $meta = get_post_meta( $get_the_id, $key, true );
    return ( isset( $meta ) ) ? $meta : $default;

  }

}

// Single Agent / Agency Properties Reditect (Pagination)
add_filter('redirect_canonical','luxus_redirect_single_page_agent');
function luxus_redirect_single_page_agent($redirect_url) {
    if (is_singular('agent')) $redirect_url = false;
    return $redirect_url;
}

add_filter('redirect_canonical','luxus_redirect_single_page_agency');
function luxus_redirect_single_page_agency($redirect_url) {
    if (is_singular('agency')) $redirect_url = false;
    return $redirect_url;
}

// Post View Count
function luxus_set_post_view() {

    $key = 'post_views_count';

    $post_id = get_the_ID();

    $count = (int) get_post_meta( $post_id, $key, true );

    $count++;

    update_post_meta( $post_id, $key, $count );

}

function luxus_get_post_view() {

    $count = get_post_meta( get_the_ID(), 'post_views_count', true );

    return "$count views";

}

function luxus_posts_column_views( $columns ) {

    $columns['post_views'] = __('Views', 'luxus-core');

    return $columns;

}

add_filter( 'manage_posts_columns', 'luxus_posts_column_views' );
add_filter( 'manage_property_posts_columns', 'luxus_posts_column_views' );
add_filter( 'manage_agent_posts_columns', 'luxus_posts_column_views' );
add_filter( 'manage_agency_posts_columns', 'luxus_posts_column_views' );

function luxus_posts_custom_column_views( $column ) {

    if ( $column === 'post_views') {
        echo luxus_get_post_view();    
    }

}

add_action( 'manage_posts_custom_column', 'luxus_posts_custom_column_views' );
add_action( 'manage_property_posts_custom_column', 'luxus_posts_custom_column_views' );
add_action( 'manage_agent_posts_custom_column', 'luxus_posts_custom_column_views' );
add_action( 'manage_agency_posts_custom_column', 'luxus_posts_custom_column_views' );

function luxus_reviews_on( $data ) {

    if( $data['post_type'] == 'agent' ) {

        $data['comment_status'] = "open";

    }
    if( $data['post_type'] == 'agency' ) {

        $data['comment_status'] = "open";

    }
    if( $data['post_type'] == 'property' ) {

        $data['comment_status'] = "open";

    }

    return $data;

}

add_filter( 'wp_insert_post_data', 'luxus_reviews_on' );

// Lost / Forget Password
remove_filter( 'lostpassword_url', 'wc_lostpassword_url', 10 );

function luxus_reset_pass_url() {
    $siteURL = get_option('siteurl');
    return "{$siteURL}/wp-login.php?action=lostpassword";
}

add_filter( 'lostpassword_url', 'luxus_reset_pass_url', 10, 2 );

// Disable Postal Code Validation Woocommerce
function luxus_disable_postcode_validation( $address_fields ) {
    $address_fields['postcode']['required'] = false;
    return $address_fields;
}
add_filter( 'woocommerce_default_address_fields' , 'luxus_disable_postcode_validation' );

// Heart Property Localize Script
function luxus_heart_property_script(){

    wp_enqueue_script( 'luxus-core-localize', SL_PLUGIN_URL . 'public/js/luxus-core-localize.js', array( 'jquery' ) );
    wp_localize_script( 'luxus-core-localize', 'heart_property_object', array(
        'ajaxurl' => admin_url( 'admin-ajax.php' ),
    ));

}

add_action( 'wp_enqueue_scripts', 'luxus_heart_property_script' );

// Heart Property Action
function luxus_heart_property_action(){

    $property_id = $_POST['property_id'];

    if( is_user_logged_in() ) {
        // Current User ID
        $user_id    =  get_current_user_id();   
        
        $data_array = array();

        // Current User Meta
        $get_user_data = get_user_meta( $user_id, '_luxus_user_favourite_properties', TRUE );

        if ( in_array( $property_id, $get_user_data ) ) {

            $index = array_search( $property_id, $get_user_data );
            
            unset( $get_user_data[$index] );

            $get_user_data = array_values( $get_user_data );

            $data_array = $get_user_data;

            // Responce
            echo 'removed_from_favourite';

        }
        else {
            if( $get_user_data != NULL ) {
                foreach ($get_user_data as $single_id) {
                    $data_array [] = $single_id;
                }
            }

            $data_array[] = $property_id;

            // Responce
            echo 'marked_as_favourite';
        }

        // Updating User Meta
        update_user_meta( $user_id , '_luxus_user_favourite_properties', $data_array );
    }
    
    exit();
} 

add_action('wp_ajax_luxus_heart_property_action','luxus_heart_property_action');
add_action('wp_ajax_nopriv_luxus_heart_property_action','luxus_heart_property_action');

// Comapre Property Localize Script
function luxus_compare_property_script(){

    wp_enqueue_script( 'luxus-core-localize', SL_PLUGIN_URL . 'public/js/luxus-core-localize.js', array( 'jquery' ) );
    wp_localize_script( 'luxus-core-localize', 'compare_property_object', array(
        'ajaxurl' => admin_url( 'admin-ajax.php' ),
    ));

}

add_action( 'wp_enqueue_scripts', 'luxus_compare_property_script' );

// Compare Property Action
function luxus_compare_property_action(){ 

    $property_id = $_POST['property_id'];

    $data = '';
     
    if( !isset( $_COOKIE['luxus_compare_prop'] ) ) {
        $data = $data.$property_id;

        setcookie( 'luxus_compare_prop', $data,  time() + (86400), "/" ); // 86400 = 1 day
    }
    else {
        $data = $_COOKIE['luxus_compare_prop'];

        $exploded_data = explode( '|', $data );
        $exploded_data = array_filter( $exploded_data );

        if ( in_array( $property_id, $exploded_data ) ) {
            echo "already_added";
            exit();
        }
        elseif( count($exploded_data ) >= 3 ) {
            echo 'full';
            exit();
        }
        else {

            $data = $data.'|'.$property_id;
            setcookie( 'luxus_compare_prop', $data,  time() + (86400), "/" ); // 86400 = 1 day
        }
    }

    $data = $_COOKIE['luxus_compare_prop'];

    $exploded_data = explode( '|', $data );
    $exploded_data = array_filter( $exploded_data );
    $count = count( $exploded_data ) + 1;

    echo $count;
    exit();

} 

add_action('wp_ajax_luxus_compare_property_action','luxus_compare_property_action');
add_action('wp_ajax_nopriv_luxus_compare_property_action','luxus_compare_property_action');

// Delete Compare Property
function luxus_delete_compare_property() { 

    // Delete Compare Properties
    if( isset( $_GET['delete_compare_property'] ) ){
        
       $value = $_GET['delete_compare_property'];
       
       $property_id  = $_GET['property_id']; 

       if( $value == 'delete_cookie' ) {

            $cookie        = $_COOKIE['luxus_compare_prop'];
            $exploded_data = explode( '|', $cookie );
            
            $data = '';

            if( count( $exploded_data ) > 0 ) {

                $i = 1;

                foreach ( $exploded_data as $value ) {
                    if( $value != '' AND $property_id != $value ) {
                        $data = $data.'|'.$value;

                        $i++;
                    }
                }
                
                if( $data != '' ) {

                    setcookie( 'luxus_compare_prop', $data,  time() + (86400), "/" ); // 86400 = 1 day
                }
                else {
                    unset( $_COOKIE['luxus_compare_prop'] );
                    setcookie( "luxus_compare_prop", "", time() - 3600, "/" );
                }

                if( $data == '' ) {
                    echo wp_redirect(site_url('/properties'));
                    exit();
                }
                else {
                    echo wp_redirect(site_url('/compare-properties'));
                    exit();
                }
            }
       }
    }
}
add_action( 'init', 'luxus_delete_compare_property' );

// Properties Save Searches Localize Script
function luxus_save_searches_scripts(){

    wp_enqueue_script( 'luxus-core-localize', SL_PLUGIN_URL . 'public/js/luxus-core-localize.js', array( 'jquery' ) );
    wp_localize_script( 'luxus-core-localize', 'save_searches_object', array(
        'ajaxurl' => admin_url( 'admin-ajax.php' ),
        'loadingmessage' => esc_html__('Please wait ...', 'luxus-core')
    ));

}
add_action( 'wp_enqueue_scripts', 'luxus_save_searches_scripts' );

// Properties Save Searches Action
function luxus_save_search_action(){

    global $wpdb;

    $table_name = $wpdb->prefix . "save_searches";

    $saved_by = get_current_user_id();

    $formData = $_POST["formData"];

    $time = current_time('mysql', 1);

    $data = array(
        'saved_by' => $saved_by,
        'ss_data' => $formData,
        'time' => $time,
    );

    //field formats: %s = string, %d = integer, %f = float
    // A string is a sequence of characters, like "Hello world!".
    // An integer data type is a non-decimal number between -2,147,483,648 and 2,147,483,647.

    $format = array(
        '%s', '%s', '%s'
    );

    $success = $wpdb->insert( $table_name, $data, $format );

    if($success){

        $contact_msg_alert = esc_html__('Save Search Successfully!', 'luxus-core');

    }else{

        $contact_msg_alert = esc_html__('Save Search Failed!', 'luxus-core');

    }

    wp_die(); 
}
// Call when user logged in
add_action('wp_ajax_luxus_save_search_action', 'luxus_save_search_action');
// Call when user in not logged in
add_action('wp_ajax_nopriv_luxus_save_search_action', 'luxus_save_search_action');

// Properties Delete Searches Localize Script
function luxus_delete_searches_scripts(){

    wp_enqueue_script( 'luxus-core-localize', SL_PLUGIN_URL . 'public/js/luxus-core-localize.js', array( 'jquery' ) );
    wp_localize_script( 'luxus-core-localize', 'delete_searches_object', array(
        'ajaxurl' => admin_url( 'admin-ajax.php' )
    ));

}
add_action( 'wp_enqueue_scripts', 'luxus_delete_searches_scripts' );

// Properties Delete Searches Action
function luxus_delete_search_action(){
    global $wpdb;

    $del_id = isset( $_POST["del_id"] ) ? $_POST["del_id"] : null;

    $table_name = $wpdb->prefix . "save_searches";

    if ( !$del_id == null ) {
        
        $wpdb->delete( $table_name , array( 'id' => $del_id ) );

    }

    wp_die(); 

}
// Call when user logged in
add_action('wp_ajax_luxus_delete_search_action', 'luxus_delete_search_action');
// Call when user in not logged in
add_action('wp_ajax_nopriv_luxus_delete_search_action', 'luxus_delete_search_action');

// Compare Property Script
add_action('wp_footer', 'luxus_compare_property_popup');
function luxus_compare_property_popup() {

    // Check If Compare Properties
    if( !isset( $_COOKIE['luxus_compare_prop'] ) ) {
        $props = '';
    }
    else {

        $data = $_COOKIE[ 'luxus_compare_prop' ];
        $exploded_data = explode( '|',$data );
        $exploded_data = array_filter( $exploded_data );
        $props =  count( $exploded_data );

    }

    $properties = ( $props != null  ? 'compare-animate' : '' );

    ?>

    <!-- Compare Properties Popup -->
    <a href="<?php echo esc_url( home_url( 'compare-properties' ) ); ?>">
        <div class="compaire-popup <?php echo esc_attr( $properties ); ?>">
            <span id="compare_icons"><?php echo esc_html( $props ); ?></span>
            <i class="sl-icon sl-compare"></i>
        </div>
    </a>

    <?php
}

// Dash Icons For Ratings
function luxus_reviews_styles() {
    wp_enqueue_style( 'dashicons' );
}
add_action( 'wp_enqueue_scripts', 'luxus_reviews_styles' );

//Display the rating on a submitted comment.
function luxus_reviews_display_rating( $comment_text ){
    if ( $rating = get_comment_meta( get_comment_ID(), 'rating', true )  ) {
        $stars = '<p class="stars">';
        for ( $i = 1; $i <= $rating; $i++ ) {
            $stars .= '<span class="sl-icons sl-star-t"></span>';
        }
        $stars .= '</p>';
        $comment_text = $stars . $comment_text;
        return $comment_text;
    } else {
        return $comment_text;
    }
}
add_filter( 'comment_text', 'luxus_reviews_display_rating' );

//Get the average rating of a post.
function luxus_reviews_get_average_ratings() {
    global $post;
    $reviews = get_approved_comments( $post->ID );
    
    if ( $reviews ) {

        $total_reviews = 0;
        $total_rates = 0;
        foreach( $reviews as $review ){
            $rate = get_comment_meta( $review->comment_ID, 'rating', true );

            if( isset( $rate ) && '' !== $rate ) {
                $total_reviews++;
                $total_rates += $rate;
            }
        }

        if ( 0 === $total_reviews ) {
            $average_number = null;
        } else {
            $average_number = round( $total_rates / $total_reviews, 1 );
        }

        $stars   = '';
        $average = $average_number;

        for ( $i = 1; $i <= $average + 1; $i++ ) {
            
            $width = intval( $i - $average > 0 ? 20 - ( ( $i - $average ) * 20 ) : 20 );

            if ( 0 === $width ) {
                continue;
            }

            $stars .= '<span style="overflow:hidden; width:' . esc_attr($width) . 'px"><i class="sl-icons sl-star-t"></i></span>';

            if ( $i - $average > 0 ) {
                $stars .= '<span style="position:relative; left:-' . esc_attr($width) .'px; overflow:hidden;"><i class="sl-icons sl-star-o"></i></span>';
            }
        }
        
        $custom_content  = '<p class="average-rating">'. $stars .'</br>'. __('Average rating: ', 'luxus-core') . $average .'</p>';
        return $custom_content;

    } else {
        return false;
    }
    
}