<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

// Register Custom Post Type Agent
add_action( 'init', 'luxus_agents_cpt', 0 );
function luxus_agents_cpt() {

	$labels = array(
		'name' => _x( 'Agents', 'Post Type General Name', 'luxus-core' ),
		'singular_name' => _x( 'Agent', 'Post Type Singular Name', 'luxus-core' ),
		'menu_name' => _x( 'Agents', 'Admin Menu text', 'luxus-core' ),
		'name_admin_bar' => _x( 'Agent', 'Add New on Toolbar', 'luxus-core' ),
		'archives' => __( 'Agent Archives', 'luxus-core' ),
		'attributes' => __( 'Agent Attributes', 'luxus-core' ),
		'parent_item_colon' => __( 'Parent Agent:', 'luxus-core' ),
		'all_items' => __( 'All Agents', 'luxus-core' ),
		'add_new_item' => __( 'Add New Agent', 'luxus-core' ),
		'add_new' => __( 'Add New', 'luxus-core' ),
		'new_item' => __( 'New Agent', 'luxus-core' ),
		'edit_item' => __( 'Edit Agent', 'luxus-core' ),
		'update_item' => __( 'Update Agent', 'luxus-core' ),
		'view_item' => __( 'View Agent', 'luxus-core' ),
		'view_items' => __( 'View Agents', 'luxus-core' ),
		'search_items' => __( 'Search Agent', 'luxus-core' ),
		'not_found' => __( 'Not found', 'luxus-core' ),
		'not_found_in_trash' => __( 'Not found in Trash', 'luxus-core' ),
		'featured_image' => __( 'Featured Image', 'luxus-core' ),
		'set_featured_image' => __( 'Set featured image', 'luxus-core' ),
		'remove_featured_image' => __( 'Remove featured image', 'luxus-core' ),
		'use_featured_image' => __( 'Use as featured image', 'luxus-core' ),
		'insert_into_item' => __( 'Insert into Agent', 'luxus-core' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Agent', 'luxus-core' ),
		'items_list' => __( 'Agents list', 'luxus-core' ),
		'items_list_navigation' => __( 'Agents list navigation', 'luxus-core' ),
		'filter_items_list' => __( 'Filter Agents list', 'luxus-core' ),
	);
	$args = array(
		'label' => __( 'Agent', 'luxus-core' ),
		'description' => __( 'Agents', 'luxus-core' ),
		'labels' => $labels,
		'menu_icon' => 'data:image/svg+xml;base64,' . base64_encode('<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 490.1 490.1" style="enable-background:new 0 0 490.1 490.1;" xml:space="preserve"><path d="M245,261.75c71.9,0,131.4-57.3,131.4-130.3S316.9,0.05,245,0.05s-131.4,57.3-131.4,130.3S173.1,261.75,245,261.75zM245,40.75c50,0,90.7,40.7,90.7,89.7s-40.7,89.6-90.7,89.6s-90.7-40.7-90.7-89.7S195,40.75,245,40.75z"/><path d="M333.6,274.25c-8.3-2.1-16.7,0-21.9,6.3l-66.7,76.1l-66.7-76.1c-5.2-6.3-14.6-8.3-21.9-6.3C61.5,305.55,0,382.65,0,469.15c0,11.5,9.4,20.9,20.9,20.9h448.3c11.5,0,20.9-9.4,20.9-20.9C490,382.65,428.5,305.55,333.6,274.25z M42.7,449.35 c8.4-57.3,50.1-106.3,114.7-131.3l73,83.4c7.3,9.4,22.9,9.4,30.2,0l73-83.4c63.6,25,106.4,75,114.7,131.3H42.7z"/></svg>'),
		'supports' => array('title', 'editor', 'thumbnail', 'revisions', 'author', 'comments'),
		'public' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'menu_position' => 5,
		'show_in_admin_bar' => true,
		'show_in_nav_menus' => true,
		'can_export' => true,
		'has_archive' => true,
		'hierarchical' => true,
		'exclude_from_search' => false,
		'show_in_rest' => true,
		'publicly_queryable' => true,
		'capability_type' => 'post',
	);
	register_post_type( 'agent', $args );
}

// Custom Post Type 'Agent' Taxonomies
require_once dirname( __FILE__ ) . '/taxonomies/agent-taxonomies.php';