<?php if ( ! defined( 'ABSPATH' )  ) { die; } // Cannot access directly.

// Register Custom Post Type Agency
add_action( 'init', 'luxus_agencies_cpt', 0 );
function luxus_agencies_cpt() {

	$labels = array(
		'name' => _x( 'Agencies', 'Post Type General Name', 'luxus-core' ),
		'singular_name' => _x( 'Agency', 'Post Type Singular Name', 'luxus-core' ),
		'menu_name' => _x( 'Agencies', 'Admin Menu text', 'luxus-core' ),
		'name_admin_bar' => _x( 'Agency', 'Add New on Toolbar', 'luxus-core' ),
		'archives' => __( 'Agency Archives', 'luxus-core' ),
		'attributes' => __( 'Agency Attributes', 'luxus-core' ),
		'parent_item_colon' => __( 'Parent Agency:', 'luxus-core' ),
		'all_items' => __( 'All Agencies', 'luxus-core' ),
		'add_new_item' => __( 'Add New Agency', 'luxus-core' ),
		'add_new' => __( 'Add New', 'luxus-core' ),
		'new_item' => __( 'New Agency', 'luxus-core' ),
		'edit_item' => __( 'Edit Agency', 'luxus-core' ),
		'update_item' => __( 'Update Agency', 'luxus-core' ),
		'view_item' => __( 'View Agency', 'luxus-core' ),
		'view_items' => __( 'View Agencies', 'luxus-core' ),
		'search_items' => __( 'Search Agency', 'luxus-core' ),
		'not_found' => __( 'Not found', 'luxus-core' ),
		'not_found_in_trash' => __( 'Not found in Trash', 'luxus-core' ),
		'featured_image' => __( 'Featured Image', 'luxus-core' ),
		'set_featured_image' => __( 'Set featured image', 'luxus-core' ),
		'remove_featured_image' => __( 'Remove featured image', 'luxus-core' ),
		'use_featured_image' => __( 'Use as featured image', 'luxus-core' ),
		'insert_into_item' => __( 'Insert into Agency', 'luxus-core' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Agency', 'luxus-core' ),
		'items_list' => __( 'Agencies list', 'luxus-core' ),
		'items_list_navigation' => __( 'Agencies list navigation', 'luxus-core' ),
		'filter_items_list' => __( 'Filter Agencies list', 'luxus-core' ),
	);
	$args = array(
		'label' => __( 'Agency', 'luxus-core' ),
		'description' => __( 'Agencies', 'luxus-core' ),
		'labels' => $labels,
		'menu_icon' => 'data:image/svg+xml;base64,' . base64_encode('<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="black" ><path d="M3 19V5.7a1 1 0 0 1 .658-.94l9.671-3.516a.5.5 0 0 1 .671.47v4.953l6.316 2.105a1 1 0 0 1 .684.949V19h2v2H1v-2h2zm2 0h7V3.855L5 6.401V19zm14 0v-8.558l-5-1.667V19h5z"/></svg>'),
		'supports' => array('title', 'editor', 'thumbnail', 'revisions', 'author', 'comments'),
		'public' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'menu_position' => 5,
		'show_in_admin_bar' => true,
		'show_in_nav_menus' => true,
		'can_export' => true,
		'has_archive' => true,
		'hierarchical' => true,
		'exclude_from_search' => false,
		'show_in_rest' => true,
		'publicly_queryable' => true,
		'capability_type' => 'post',
	);
	register_post_type( 'agency', $args );
}

// Custom Post Type 'Agency' Taxonomies
require_once dirname( __FILE__ ) . '/taxonomies/agency-taxonomies.php';