<?php
/**
 * Luxus Content Block For Headers / Footers & Other Reusable Blocks
 *
 * @package luxus
 */

// Register Custom Post Type Content Block
add_action( 'init', 'luxus_content_block', 0 );
function luxus_content_block() {

	$labels = array(
		'name' => _x( 'Content Blocks', 'Post Type General Name', 'luxus-core' ),
		'singular_name' => _x( 'Content Block', 'Post Type Singular Name', 'luxus-core' ),
		'menu_name' => _x( 'Content Blocks', 'Admin Menu text', 'luxus-core' ),
		'name_admin_bar' => _x( 'Content Block', 'Add New on Toolbar', 'luxus-core' ),
		'archives' => __( 'Content Block Archives', 'luxus-core' ),
		'attributes' => __( 'Content Block Attributes', 'luxus-core' ),
		'parent_item_colon' => __( 'Parent Content Block:', 'luxus-core' ),
		'all_items' => __( 'All Content Blocks', 'luxus-core' ),
		'add_new_item' => __( 'Add New Content Block', 'luxus-core' ),
		'add_new' => __( 'Add New', 'luxus-core' ),
		'new_item' => __( 'New Content Block', 'luxus-core' ),
		'edit_item' => __( 'Edit Content Block', 'luxus-core' ),
		'update_item' => __( 'Update Content Block', 'luxus-core' ),
		'view_item' => __( 'View Content Block', 'luxus-core' ),
		'view_items' => __( 'View Content Blocks', 'luxus-core' ),
		'search_items' => __( 'Search Content Block', 'luxus-core' ),
		'not_found' => __( 'Not found', 'luxus-core' ),
		'not_found_in_trash' => __( 'Not found in Trash', 'luxus-core' ),
		'featured_image' => __( 'Featured Image', 'luxus-core' ),
		'set_featured_image' => __( 'Set featured image', 'luxus-core' ),
		'remove_featured_image' => __( 'Remove featured image', 'luxus-core' ),
		'use_featured_image' => __( 'Use as featured image', 'luxus-core' ),
		'insert_into_item' => __( 'Insert into Content Block', 'luxus-core' ),
		'uploaded_to_this_item' => __( 'Uploaded to this Content Block', 'luxus-core' ),
		'items_list' => __( 'Content Blocks list', 'luxus-core' ),
		'items_list_navigation' => __( 'Content Blocks list navigation', 'luxus-core' ),
		'filter_items_list' => __( 'Filter Content Blocks list', 'luxus-core' ),
	);
	$args = array(
		'label' => __( 'Content Block', 'luxus-core' ),
		'description' => __( 'Content Blocks', 'luxus-core' ),
		'labels' => $labels,
		'menu_icon' => 'data:image/svg+xml;base64,' . base64_encode('<svg id="Layer_1" enable-background="new 0 0 512 512" fill="black" height="512" viewBox="0 0 512 512" width="512" xmlns="http://www.w3.org/2000/svg"><path d="M176.792,0H59.208C26.561,0,0,26.561,0,59.208v117.584C0,209.439,26.561,236,59.208,236h117.584C209.439,236,236,209.439,236,176.792V59.208C236,26.561,209.439,0,176.792,0z M196,176.792c0,10.591-8.617,19.208-19.208,19.208H59.208C48.617,196,40,187.383,40,176.792V59.208C40,48.617,48.617,40,59.208,40h117.584C187.383,40,196,48.617,196,59.208V176.792z"/><path d="M452,0H336c-33.084,0-60,26.916-60,60v116c0,33.084,26.916,60,60,60h116c33.084,0,60-26.916,60-60V60C512,26.916,485.084,0,452,0z M472,176c0,11.028-8.972,20-20,20H336c-11.028,0-20-8.972-20-20V60c0-11.028,8.972-20,20-20h116c11.028,0,20,8.972,20,20V176z"/><path d="M176.792,276H59.208C26.561,276,0,302.561,0,335.208v117.584C0,485.439,26.561,512,59.208,512h117.584C209.439,512,236,485.439,236,452.792V335.208C236,302.561,209.439,276,176.792,276z M196,452.792c0,10.591-8.617,19.208-19.208,19.208H59.208C48.617,472,40,463.383,40,452.792V335.208C40,324.617,48.617,316,59.208,316h117.584c10.591,0,19.208,8.617,19.208,19.208V452.792z"/><path d="M452,276H336c-33.084,0-60,26.916-60,60v116c0,33.084,26.916,60,60,60h116c33.084,0,60-26.916,60-60V336C512,302.916,485.084,276,452,276z M472,452c0,11.028-8.972,20-20,20H336c-11.028,0-20-8.972-20-20V336c0-11.028,8.972-20,20-20h116c11.028,0,20,8.972,20,20V452z"/></svg>'),
		'supports' => array('title', 'editor', 'thumbnail', 'author'),
		'taxonomies' => array(),
		'public' => true,
		'show_ui' => true,
		'show_in_menu' => true,
		'menu_position' => 5,
		'show_in_admin_bar' => true,
		'show_in_nav_menus' => true,
		'can_export' => true,
		'has_archive' => true,
		'hierarchical' => true,
		'exclude_from_search' => true,
		'show_in_rest' => true,
		'publicly_queryable' => true,
		'capability_type' => 'post',
		'capabilities' => array(
		    'edit_post'          => 'edit_pages',
		    'read_post'          => 'edit_pages',
		    'delete_post'        => 'edit_pages',
		    'edit_posts'         => 'edit_pages',
		    'edit_others_posts'  => 'edit_pages',
		    'delete_posts'       => 'edit_pages',
		    'publish_posts'      => 'edit_pages',
		    'read_private_posts' => 'edit_pages'
		),
	);
	register_post_type( 'luxus_content_block', $args );

}


// Content Block Meta Radio Box
add_action( 'add_meta_boxes', 'luxus_content_block_type' );
function luxus_content_block_type() {

	add_meta_box('luxus_content_block_type', 'Content Block Type', 'luxus_content_block_type_meta', 'luxus_content_block', 'side' );
 
}

function luxus_content_block_type_meta( $post ) {

	 wp_nonce_field( 'luxus_content_block_type', 'luxus_content_block_type_nonce' );

	 $value = get_post_meta( $post->ID, 'luxus_content_block_type', true );
	 //luxus_content_block_type is a meta_key.

?>
	<input type="radio" name="content_block_type" value="header" <?php checked( $value, 'header' ); ?> >
	Header<br>
	<input type="radio" name="content_block_type" value="footer" <?php checked( $value, 'footer' ); ?> >
	Footer<br>
	<input type="radio" name="content_block_type" value="other" <?php checked( $value, 'other' ); ?> >
	Other<br>

<?php
}

add_action( 'save_post', 'luxus_content_block_type_save_meta_box_data' );
function luxus_content_block_type_save_meta_box_data( $post_id ) {
 
    /*
     * We need to verify this came from our screen and with proper authorization,
     * because the save_post action can be triggered at other times.
     */

    // Check if our nonce is set.
    if ( !isset( $_POST['luxus_content_block_type_nonce'] ) ) {
            return;
    }

    // Verify that the nonce is valid.
    if ( !wp_verify_nonce( $_POST['luxus_content_block_type_nonce'], 'luxus_content_block_type' ) ) {
            return;
    }

    // If this is an autosave, our form has not been submitted, so we don't want to do anything.
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
            return;
    }

    // Check the user's permissions.
    if ( !current_user_can( 'edit_post', $post_id ) ) {
            return;
    }

    // Sanitize user input.
    $new_meta_value = ( isset( $_POST['content_block_type'] ) ? sanitize_html_class( $_POST['content_block_type'] ) : '' );

    // Update the meta field in the database.
    update_post_meta( $post_id, 'luxus_content_block_type', $new_meta_value );
 
}

// Add Custom Column 'block_type' To Content Block List
add_filter( 'manage_luxus_content_block_posts_columns', 'luxus_content_block_columns' );
function luxus_content_block_columns($columns) {

	// Return Column and shift Possition
    return array_slice( $columns, 0, 3, true ) + array( 'block_type' => 'Block Type', 'shortcode' => 'Shortcode' ) + array_slice( $columns, 3, count( $columns ) - 3, true );
}

// Echo Custom Column 'block_type' To Content Block List
add_action( 'manage_luxus_content_block_posts_custom_column' , 'luxus_content_block_shortcode_column', 10, 2 );
function luxus_content_block_shortcode_column( $column, $post_id ) {

    if ( $column == 'block_type' ) {

        // Get Post Meta
        $block_type = get_post_meta( $post_id, 'luxus_content_block_type', true );
        
        // Output
        echo '<span>' .  ucfirst( $block_type ) . '</span>';
    }

    if ( $column == 'shortcode' ) {

    	$type = get_post_meta( $post_id, 'luxus_content_block_type', true );

    	if ($type == 'other') :

    ?>
	   
	    <input type='text' onfocus='this.select();' readonly='readonly' value='[luxus_content_block id="<?php echo esc_attr( $post_id ); ?>"]'>

    <?php
    	endif;
    }
}

// Remove Columns From Content Block List
function luxus_content_block_columns_filter( $columns ) {

    unset($columns['post_views']);
    unset($columns['date']);
    
    return $columns;
}
add_filter( 'manage_luxus_content_block_posts_columns', 'luxus_content_block_columns_filter', 10, 1 );
