<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked wc_print_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}

global $product;
$sku_v = ( $sku = $product->get_sku() ) ? $sku : esc_html__( 'N/A', 'applic' );

?>
<!--PRODUCTS AREA-->
<div class="row">
    <div class="col-md-6">
        <div class="product-left-gallery sm-mb50 xs-mb50">
            <?php woocommerce_show_product_images();?>
        </div>
    </div>
    <div class="col-md-6">
        <div class="product-right-details">
            <div class="total-review">
                <?php woocommerce_template_single_rating(); ?>
            </div>
            <div class="product-title">
                <a href="<?php applic_first_category_link('product_cat'); ?>" class="product-category">
                    <?php applic_first_category('product_cat'); ?>
                </a>
                <?php woocommerce_template_single_title(); ?>
            </div>
            <?php woocommerce_template_single_price(); ?>
            <div class="short-desc">
                <h3><?php esc_html_e('Overview', 'applic'); ?></h3>
                <?php the_excerpt(); ?>
            </div>
            <?php woocommerce_template_single_add_to_cart(); ?>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="product-details-tab">
            <?php woocommerce_output_product_data_tabs(); ?>
        </div>
    </div>
</div>
<!--PRODUCTS AREA END-->
<?php
do_action( 'woocommerce_after_single_product' );