<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
$link = apply_filters( 'woocommerce_loop_product_link', get_the_permalink(), $product );
// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
?>

<div class="col-md-4 col-sm-6 col-xs-12 product">
    <div class="product-thumb">
        <a href="<?php echo esc_url($link); ?>">
            <?php echo woocommerce_get_product_thumbnail('applic_340x400'); ?>
        </a>
    </div>
    <div class="product-title-details">
        <div class="category-and-ratting">
            <a href="<?php applic_first_category_link('product_cat'); ?>" class="product-category">
                <?php applic_first_category('product_cat') ?>
            </a>
            <?php if( wc_review_ratings_enabled() ): ?>
            <div class="ratting">
                <?php woocommerce_template_loop_rating(); ?>
            </div>
            <?php endif; ?>
        </div>
        <h3 class="woocommerce-product-title">
            <a href="<?php the_permalink(); ?>"> <?php the_title() ?> </a>
        </h3>
        <?php woocommerce_template_loop_price(); ?>
    </div>
</div>