<?php
$args = array(
    'posts_per_page' => 2, // How many items to display
    'post__not_in'   => array( get_the_ID() ), // Exclude current post
    'no_found_rows'  => true, // We don't ned pagination so this speeds up the query
);

// Check for current post category and add tax_query to the query arguments
$cats = wp_get_post_terms( get_the_ID(), 'category' );
$cats_ids = array();
foreach( $cats as $wpex_related_cat ) {
    $cats_ids[] = $wpex_related_cat->term_id;
}
if ( ! empty( $cats_ids ) ) {
    $args['category__in'] = $cats_ids;
}
// Query posts
$wpex_query = new wp_query( $args );


if( $wpex_query->have_posts() ) {
    ?>
    <div class="related-post-warapper">
        <h3><?php _e('Related Posts', 'applic'); ?></h3>
        <div class="related-post">
            <div class="row">
                <?php
                foreach ($wpex_query->posts as $post) : setup_postdata($post); ?>
                    <div class="col-md-6 col-sm-6">
                        <div class="single-related-post xs-mb50">
                            <a href="<?php the_permalink(); ?>">
                                <?php if (has_post_thumbnail()) {
                                    the_post_thumbnail('applic_310x300');
                                }
                                ?>
                            </a>
                            <div class="related-details">
                                <div class="related__post__tag">
                                    <i class="fa fa-calendar"></i>
                                    <a href="<?php applic_day_link() ?>"><?php the_time(get_option('date_format')); ?></a>
                                </div>
                                <h4><a title="<?php the_title(); ?>"
                                       href="<?php the_permalink(); ?>"><?php echo wp_trim_words(get_the_title(), 7); ?></a>
                                </h4>
                                <p><?php echo wp_trim_words(get_the_content(), 12, ''); ?></p>
                            </div>
                        </div>
                    </div>
                <?php
                endforeach;
                wp_reset_postdata();
                ?>
            </div>
        </div>
    </div>
    <?php
}