<?php
/*
 * applic post details content
 * */
?>
<div class="post-details">
    <div class="post-top-meta">
        <div class="post-author">
            <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php echo get_avatar( get_the_author_meta( 'ID' ), 38 ); ?></a>
            <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php the_author(); ?></a>
        </div>
        <div class="meta-comment-tag">
            <ul>
                <li><i class="fa fa-comments-o"></i>
                    <a href="<?php comments_link(); ?>"><?php comments_number( 'No Comment', '1 Comment', '% Comments' ); ?></a>
                </li>
				<?php if ( has_tag() ) : ?>
                    <li><i class="fa fa-tags"></i>
						<?php the_tags( '', ', ', '' ); ?>
                    </li>
				<?php endif; ?>
            </ul>
        </div>
    </div>
    <h2 class="post-title"><a title="<?php the_title(); ?>" href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
    <p><?php echo wp_trim_words( get_the_content(), 45, '' ); ?></p>
    <div class="post-date-and-category">
        <ul>
            <li><i class="fa fa-calendar"></i> <a href="<?php applic_day_link() ?>"><?php the_time(get_option('date_format')) ?></a></li>
            <?php if( has_category() ) : ?>
            <li><i class="fa fa-bookmark-o"></i>
				<?php the_category( ', ' ); ?>
            </li>
            <?php endif; ?>
        </ul>
    </div>
    <?php wp_link_pages(); ?>
</div>