<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Applic
 */

$opt = get_option( 'applic_opt' );
?>
<div class="single-post-item first_letter format-standard sm-mb50 xs-mb50">
    <?php 
        if ( function_exists( 'applic_post_share' ) ) {
            applic_post_share();
        }
    ?>
	<div class="post-details">
		<div class="post-top-meta">
			<div class="post-author">
				<a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php echo get_avatar( get_the_author_meta( 'ID' ), 38 ); ?></a>
				<a class="font18" href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php the_author(); ?></a>
			</div>
			<div class="meta-comment-tag">
				<ul>
					<li><i class="fa fa-comments-o"></i><a href="<?php comments_link(); ?>"><?php comments_number( 'No Comment', '1 Comment', '% Comments' ); ?></a></li>
					<?php if ( has_tag() ): ?>
                        <li><i class="fa fa-tags"></i>
							<?php the_tags( '', ', ', '' ); ?>
                        </li>
					<?php endif; ?>
				</ul>
			</div>
		</div>
		<h2 class="post-title"><?php the_title(); ?></h2>
        <div class="main_content">
		    <?php the_content(); ?>
        </div>
        <?php
        if ( has_tag() || function_exists('applic_social_share') ) {
            ?>
            <div class="post-bottom-meta fix">
                <?php   if ( has_tag() ) { ?>
                    <div class="post-tags">
                        <h4><?php esc_html_e('Tags', 'applic'); ?></h4>
                        <ul>
                            <li><?php the_tags('', ', ', ''); ?></li>
                        </ul>
                    </div>
                    <?php
                }
                if ( function_exists('applic_social_share') ) {
                    applic_social_share();
                }
                ?>
            </div>
            <?php
        }

        if( get_next_post_link() || get_previous_post_link() ) { ?>

            <div class="single-post-navigation">
                <div class="prev-post">
                    <?php
                    previous_post_link('%link', '<div class="arrow-link"><i class="fa fa-arrow-left"></i></div><div class="title-with-link"><span>'.esc_html__( 'Prev Post', 'applic' ).'</span><h3 title="%title">%title</h3></div>')
                    ?>
                </div>
                <div class="single-post-navigation-center-grid">
                    <a href=" <?php echo esc_url( get_post_type_archive_link( 'post' ) ); ?>"><i class="fa fa-th-large"></i></a>
                </div>
                <div class="next-post">
                    <?php
                    next_post_link('%link', '<div class="title-with-link"><span>'.esc_html__( 'Next Post', 'applic' ).'</span><h3 title="%title">%title</h3></div><div class="arrow-link"><i class="fa fa-arrow-right"></i></div>')
                    ?>
                </div>
            </div>
            <?php
        } ?>
        <?php
            get_template_part( 'template-parts/related', 'post' );
        if(!empty(get_the_author_meta('description'))) {
            ?>
            <div class="post-author-biography">
                <div class="posts-author">
                    <img class="alignleft" src="<?php echo get_avatar_url(get_the_author_meta('ID'), array('size' => 180)) ?>" alt="<?php echo get_the_author_meta('display_name'); ?>">
                    <p class="writen-by"><?php _e('Writen By', 'applic'); ?></p>
                    <h3><?php echo get_the_author_meta('display_name') ?></h3>
                    <p><?php echo get_the_author_meta('description') ?></p>
                </div>
            </div>
            <?php
        }

		if ( comments_open() || get_comments_number() ) :
			comments_template();
		endif;
		?>
	</div>
</div>