<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Applic
 */

?>

<div <?php post_class('single-post-item format-quote mb50'); ?>>
	<div class="post-details">
		<div class="post-quote"><div class="fa fa-quote-left"></div></div>
		<h2 class="post-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
		<p><?php echo wp_trim_words( get_the_content(), 25, '' ); ?></p>
		<div class="quote-meta">
			<div class="quote-post-author">
				<a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php echo get_avatar( get_the_author_meta( 'ID' ), 40 ); ?></a>
				<a class="font18" href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><?php the_author(); ?></a>
			</div>
		</div>
	</div>
</div>
