<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Applic
 */

get_header();
$blog_column = is_active_sidebar( 'sidebar_widgets' ) ? '8' : '12';
?>

    <section class="content-area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-md-<?php echo esc_attr( $blog_column ) ?> col-lg-<?php echo esc_attr( $blog_column ) ?> col-sm-12 col-xs-12">
                    <?php
                    if ( have_posts() ) {
                        while ( have_posts() ) :  the_post();
                            get_template_part( 'template-parts/content', get_post_format());
                        endwhile;

                    } else {
                        get_template_part( 'template-parts/content', 'none' );
                    }
                    get_template_part( 'template-parts/pagination' );
                    ?>
                </div>
                <?php get_sidebar(); ?>
            </div>
        </div>
    </section>
    <!--BLOG AREA END-->
<?php
get_footer();
