<?php

// Header Section
Redux::setSection( 'applic_opt', array(
	'title'            => esc_html__( 'Header Settings', 'applic' ),
	'id'               => 'header_sec',
	'customizer_width' => '400px',
	'icon'             => 'el el-home'
) );


// Is Pre-loader
Redux::setSection( 'applic_opt', array(
	'title'      => esc_html__( 'Pre-loader', 'applic' ),
	'id'         => 'preloader_opt',
	'subsection' => true,
	'icon'       => 'dashicons dashicons-minus',
	'fields'     => array(
		array(
			'title'    => esc_html__( 'Show/hide Pre-loder', 'applic' ),
			'subtitle' => esc_html__( 'Toggle this switcher to show or hide the sing up button.', 'applic' ),
			'id'       => 'is_preloader',
			'type'     => 'switch',
			'on'       => esc_html__( 'Show', 'applic' ),
			'off'      => esc_html__( 'Hide', 'applic' ),
		),
	)
) );


Redux::setSection( 'applic_opt', array(
	'title'      => esc_html__( 'Logo settings', 'applic' ),
	'id'         => 'logo_opt',
	'subsection' => true,
	'icon'       => 'dashicons dashicons-schedule',
	'fields'     => array(
		array(
			'title'    => esc_html__( 'Upload logo', 'applic' ),
			'subtitle' => esc_html__( 'Upload here a image file for your logo', 'applic' ),
			'id'       => 'main_logo',
			'type'     => 'media',
			'compiler' => true,
			'default'  => array(
				'url' => ''
			)
		),
		array(
			'title'    => esc_html__( 'Sticky header logo', 'applic' ),
			'id'       => 'sticky_logo',
			'type'     => 'media',
			'compiler' => true,
			'default'  => array(
				'url' => ''
			)
		),
		array(
			'title'    => esc_html__( 'Logo dimensions', 'applic' ),
			'subtitle' => esc_html__( 'Set a custom height width for your upload logo.', 'applic' ),
			'id'       => 'logo_dimensions',
			'type'     => 'dimensions',
			'units'    => array( 'em', 'px', '%' ),
			'output'   => '.navbar-header > a > img'
		),
		array(
			'title'          => esc_html__( 'Padding', 'applic' ),
			'subtitle'       => esc_html__( 'Padding around the logo. Input the padding as clockwise (Top Right Bottom Left)', 'applic' ),
			'id'             => 'logo_padding',
			'type'           => 'spacing',
			'output'         => array( '.navbar-header' ),
			'mode'           => 'padding',
			'units'          => array( 'em', 'px', '%' ),      // You can specify a unit value. Possible: px, em, %
			'units_extended' => 'true',
			'default'        => array(
				'padding-top'    => '0px',
				'padding-right'  => '0px',
				'padding-bottom' => '0px',
				'padding-left'   => '0px'
			)
		),
	)
) );

// Menu action button
Redux::setSection( 'applic_opt', array(
	'title'      => esc_html__( 'Menu action button', 'applic' ),
	'id'         => 'menu_action_btn_opt',
	'subsection' => true,
	'icon'       => 'dashicons dashicons-minus',
	'fields'     => array(
		array(
			'title'    => esc_html__( 'Show/hide sign up button', 'applic' ),
			'subtitle' => esc_html__( 'Toggle this switcher to show or hide the sing up button.', 'applic' ),
			'id'       => 'is_sign_up',
			'type'     => 'switch',
			'on'       => esc_html__( 'Show', 'applic' ),
			'off'      => esc_html__( 'Hide', 'applic' ),
		),
		array(
			'title'    => esc_html__( 'Sign up button label', 'applic' ),
			'id'       => 'sign_up_label',
			'type'     => 'text',
			'default'  => 'Sign Up',
			'required' => array( 'is_sign_up', '=', 1 )
		),
		array(
			'title'   => esc_html__( 'Sign up button URL', 'applic' ),
			'id'      => 'sign_up_url',
			'type'    => 'text',
			'default' => '#',
			'required' => array( 'is_sign_up', '=', 1 )
		),
		array(
			'title'    => esc_html__( 'Show/hide search button', 'applic' ),
			'subtitle' => esc_html__( 'Toggle this switcher to show or hide the search button.', 'applic' ),
			'id'       => 'is_search',
			'type'     => 'switch',
			'on'       => esc_html__( 'Show', 'applic' ),
			'off'      => esc_html__( 'Hide', 'applic' ),
		),

	)
) );



