<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Applic
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
/* applic image size */
add_image_size('applic_750x420', 750, 420, true); // Post thumbnail
add_image_size('applic_1280x750', 1280, 750, true); // Post thumbnail full
add_image_size('applic_80x80', 80, 80, true); // Recent post widget thumbnail
add_image_size('applic_310x300', 310, 300, true); // Related post (single post ) thumbnail
add_image_size('applic_180x200', 180, 200, true); // (single post ) author thumbnail
add_image_size('applic_140x140', 140, 140, true); // ( about me widget ) author thumbnail
add_image_size('applic_340x400', 340, 400, true); // woocommerce product thumbnail
add_image_size('applic_360x263', 360, 263, true); // widget blog post

// Day link to archive page
function applic_day_link() {
	$archive_year   = get_the_time('Y');
	$archive_month  = get_the_time('m');
	$archive_day    = get_the_time('d');
	echo get_day_link( $archive_year, $archive_month, $archive_day);
}

// Comment list
function applic_comments($comment, $args, $depth){
	$GLOBALS['comment'] = $comment;
	extract($args, EXTR_SKIP);
	?>
    <ul>
	<li class="single-comment">
		<div class="comment-author">
			<?php echo get_avatar( $comment, 80, null, null ); ?>
		</div>
		<div class="comment-details">
			<div class="comment-meta">
				<div class="comment-left-meta">
					<h4 class="author-name"><?php comment_author(); ?></h4>
					<div class="comment-date"> <?php comment_time(get_option('date_format')); ?> </div>
				</div>
				<div class="comment-reply">
					<?php comment_reply_link(array_merge( $args, array('reply_text'=>'<i class="fa fa-share"></i>'.esc_html__('Reply', 'applic'), 'depth' => $depth, 'max_depth' => $args['max_depth']))); ?>
				</div>
			</div>
			<div class="comment-text">
				<?php comment_text(); ?>
			</div>
		</div>
	</li>
    </ul>
	<?php
}


// Get comment count text
function applic_comment_count($post_id, $no_comments = 'No Comments') {
    $comments_number = get_comments_number($post_id);
    if($comments_number == 0) {
        $comment_text = $no_comments;
    }elseif($comments_number == 1) {
        $comment_text = esc_html__('1 Comment', 'applic');
    }elseif($comments_number > 1) {
        $comment_text = $comments_number.esc_html__(' Comments', 'applic');
    }
    echo esc_html($comment_text);
}

// Body classes
function applic_body_classes( $classes ) {
	if (  is_page() ) {
	$classes[] = 'overflow-xhidden';
	}
	if (  is_home() ) {
		$classes[] = 'blog';
	}
	if ( ! is_singular() ) {
		$classes[] = 'single';
	}
    if ( !function_exists( 'applic_post_share' ) ) {
        $classes[] = 'no-social';
    }
	return $classes;
}
add_filter( 'body_class', 'applic_body_classes' );


// Banner Title
function applic_banner_title() {
    $opt = get_option('applic_opt');
    $blog_title = !empty($opt['blog_title']) ? $opt['blog_title'] : esc_html__('Blog', 'applic');
    $single_blog_title = !empty($opt['single_blog_title']) ? $opt['single_blog_title'] : esc_html__('Blog', 'applic');
    if ( class_exists('WooCommerce') ) {
        if ( is_shop() ) {
            echo !empty($opt['shop_title']) ? esc_html($opt['shop_title']) : esc_html__( 'Shop', 'applic' );
        }
        elseif( is_product() ){
            echo !empty($opt['shop_title']) ? esc_html($opt['shop_title']) : esc_html__( 'Shop', 'applic' );
        }
        elseif ( is_home() ) {
            $blog_title = !empty($opt['blog_title']) ? $opt['blog_title'] : esc_html__('Blog', 'applic');
            echo esc_html($blog_title);
        }
        elseif ( is_singular('post') ) {
            echo esc_html($single_blog_title);
        }
        elseif ( is_page() || is_single() ) {
            the_title();
        }
        elseif ( is_category() ) {
            single_cat_title();
        }
        elseif ( is_archive() ) {
            the_archive_title();
        }
        elseif ( is_search() ) {
            esc_html_e( 'Search result for: “', 'applic' ); echo get_search_query().'”';
        }
        else {
            the_title();
        }
    } else {
        if ( is_home() ) {
            echo esc_html($blog_title);
        }
        elseif ( is_page() || is_single() ) {
            the_title();
        }
        elseif ( is_category() ) {
            single_cat_title();
        }
        elseif ( is_archive() ) {
            the_archive_title();
        }
        elseif ( is_search() ) {
            esc_html_e( 'Search result for: “', 'applic' ); echo get_search_query().'”';
        }
        else {
            the_title();
        }
    }
}

/**
 * applic_archive_count_span() This code filters the Archive widget to include the post count inside the link
 * @param  [type] $links
 * @return [type] $string 
 */
function applic_archive_count_span( $links) {
    $links = str_replace('</a>&nbsp;(', ' <span>', $links);
    $links = str_replace(')', '</span></a>', $links);
    return $links;
}
add_filter('get_archives_link', 'applic_archive_count_span');

function applic_archive_dropdown_count_span( $links ) {
    $links = str_replace('&nbsp;(', ' (', $links);
    $links = str_replace('</span></a></option>', ')</option>', $links);
    return $links;
}
add_filter('get_archives_link', 'applic_archive_dropdown_count_span');


/**
 * applic_category_count_span() category count show in a span.
 * @param  [type] $links
 * @return [type] $string
 */
function applic_category_count_span($links) {
    $links = str_replace('</a> (', ' <span>', $links);
    $links = str_replace(')', '</span></a>', $links);
    return $links;
}
add_filter('wp_list_categories', 'applic_category_count_span');

function applic_category_dropdown_count_span($links) {
    $links = str_replace('&nbsp;(', ' <span>', $links);
    $links = str_replace(')</option>', '</span></option>', $links);
    return $links;
}
add_filter('wp_list_categories', 'applic_category_dropdown_count_span');


// add category nick names in body and post class
function applic_post_class( $classes ) {
    global $post;
    if( !has_post_thumbnail() ) {
        $classes[] = 'no-post-thumbnails';
    }
    if ( !function_exists( 'applic_post_share' ) ) {
        $classes[] = 'no-social';
    }
    return $classes;
}
add_filter( 'post_class', 'applic_post_class' );

// Get the first category name
function applic_first_category($term = 'category') {
    $cats = get_the_terms(get_the_ID(), $term);
    $cat  = is_array($cats) ? $cats[0]->name : '';
    echo esc_html($cat);
}

// Get the first category link
function applic_first_category_link( $term='category' ) {
    $cats = get_the_terms(get_the_ID(), $term);
    $cat  = is_array($cats) ? get_category_link($cats[0]->term_id) : '';
    echo esc_url($cat);
}