<?php
// Register Widget areas
add_action( 'widgets_init', function () {
    // sidebar widget
    register_sidebar( array(
        'name'          => esc_html__( 'Blog Sidebar', 'applic' ),
        'description'   => esc_html__( 'Place widgets in the blog sidebar widgets area.', 'applic' ),
        'id'            => 'sidebar_widgets',
        'before_widget' => '<div id="%1$s" class="widget single-widgets %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h4>',
        'after_title'   => '</h4>'
    ) );
    // footer widget left
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Left Widget', 'applic' ),
        'description'   => esc_html__( 'Place widgets in the footer left widgets area.', 'applic' ),
        'id'            => 'footer_widgets1',
        'before_widget' => '<div class="col-md-3 col-sm-12 col-xs-12 sm-center xs-center sm-mb50 xs-mb50"><div id="%1$s" class="widget single-widgets %2$s">',
        'after_widget'  => '</div></div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>'
    ) );
    // footer widget middle one
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Middle One Widget', 'applic' ),
        'description'   => esc_html__( 'Place widgets in the footer middle one widgets area.', 'applic' ),
        'id'            => 'footer_widgets2',
        'before_widget' => '<div class="col-md-offset-1 col-md-2 col-sm-4 col-xs-12"><div id="%1$s" class="single-widgets xs-mb50">',
        'after_widget'  => '</div></div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>'
    ) );
    // footer widget middle two
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Middle Two Widget', 'applic' ),
        'description'   => esc_html__( 'Place widgets in the footer middle two widgets area.', 'applic' ),
        'id'            => 'footer_widgets3',
        'before_widget' => '<div class="col-md-3 col-sm-4 col-xs-12"><div id="%1$s" class="single-widgets">',
        'after_widget'  => '</div></div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>'
    ));
    // footer widget right
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Right Widget', 'applic' ),
        'description'   => esc_html__( 'Place widgets in the footer right widgets area.', 'applic' ),
        'id'            => 'footer_widgets4',
        'before_widget' => '<div class="col-md-3 col-sm-4 col-xs-12"><div id="%1$s" class="single-widgets">',
        'after_widget'  => '</div></div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>'
    ));
});