<?php
/**
 * Enqueue scripts and styles.
 */

function applic_scripts(){


    function applic_fonts_url() {
        $fonts_url = '';
        $fonts     = array();
        $subsets   = '';

        /* translators: If there are characters in your language that are not supported by this font, translate this to 'off'. Do not translate into your own language. */
        if ( 'off' !== esc_html_x( 'on', "Rubik font: on or off", 'applic' ) ) {
            $fonts[] = "Rubik:400,500,700";
        }
        if ( $fonts ) {
            $fonts_url = add_query_arg( array(
                'family' => urlencode( implode( '|', $fonts ) ),
                'subset' => urlencode( $subsets ),
            ), 'https://fonts.googleapis.com/css' );
        }
        return $fonts_url;
    }
    

    $opt = get_option('applic_opt');

    wp_enqueue_style('applic_font', applic_fonts_url());
    wp_enqueue_style('normalize', APPLIC_DIR_CSS_PLUG . '/normalize.css');
    wp_enqueue_style('animate', APPLIC_DIR_CSS_PLUG . '/animate.css');
    wp_enqueue_style('odometer', APPLIC_DIR_CSS_PLUG . '/odometer.css');
    wp_enqueue_style('modal-video', APPLIC_DIR_CSS_PLUG . '/modal-video.min.css');
    wp_enqueue_style('venobox', APPLIC_DIR_CSS_PLUG . '/venobox.css');
    wp_enqueue_style('owl-carousel', APPLIC_DIR_CSS_PLUG . '/owl.carousel.css');
    wp_enqueue_style('stellarnav', APPLIC_DIR_CSS_PLUG . '/stellarnav.min.css');
    wp_enqueue_style('bootstrap', APPLIC_DIR_CSS_PLUG . '/bootstrap.min.css');
    wp_enqueue_style('font-awesome-icons', APPLIC_DIR_CSS . '/icons/font-awesome.min.css');
    wp_enqueue_style('themify-icons', APPLIC_DIR_CSS . '/icons/themify-icons.css');
    wp_enqueue_style('applic-flaticon-icons', APPLIC_DIR_CSS . '/icons/Flaticon-essential.css');
    wp_enqueue_style('applic-webfont-icons', APPLIC_DIR_CSS . '/icons/webfont.css');
    wp_enqueue_style('applic-typography', APPLIC_DIR_CSS . '/typography.css');
    wp_enqueue_style('applic-header', APPLIC_DIR_CSS . '/header.css');
    wp_enqueue_style('applic-blog-and-pages', APPLIC_DIR_CSS . '/blog-and-pages.css');
    wp_enqueue_style('applic-footer', APPLIC_DIR_CSS . '/footer.css');
    wp_enqueue_style('applic-wpd',  APPLIC_DIR_CSS.'/wpd-style.css');

    if (defined('ELEMENTOR_VERSION')) {
        if (!\Elementor\Plugin::$instance->preview->is_preview_mode()) {
            wp_enqueue_style('applic-hero', APPLIC_DIR_CSS . '/hero.css');
        }
    }

    wp_enqueue_style('applic-main', APPLIC_DIR_CSS . '/style.css');
    wp_enqueue_style('applic-responsive', APPLIC_DIR_CSS . '/responsive.css');
    wp_enqueue_style('applic-root', get_stylesheet_uri());

    $dynamic_css = '';

    if ( class_exists('ReduxFrameworkPlugin') ) {
        $dynamic_css .= "
            .barner-area .area-bg, .no_widget.footer-bottom-area {
                background: rgba(0, 0, 0, 0) url({$opt['breadcrumb_bg_img']['url']}) no-repeat scroll center center / cover;
            }";
        $dynamic_css .= isset($opt['accent_gradient']['from']) ? "
	       .scrolltotop, .read-more::before {
	            background: rgba(0, 0, 0, 0) linear-gradient(135deg, " . esc_attr($opt['accent_gradient']['from']) . " 0%, ".esc_attr($opt['accent_gradient']['to'])." 99%);
            }" : '';
    }

    if ( function_exists('get_field') ) {
        $banner_background_image = get_field('background_image');
        if ( !empty($banner_background_image) ) {
            $dynamic_css .= "
                .barner-area .area-bg, .no_widget.footer-bottom-area {
                    background: rgba(0, 0, 0, 0) url($banner_background_image) no-repeat scroll center center / cover;
                }";
        }
    }

    wp_add_inline_style('applic-root', $dynamic_css);

    wp_enqueue_script('modernizr', APPLIC_DIR_JS_VEND . '/modernizr-2.8.3.min.js', '', '2.8.3', false);
    wp_enqueue_script('bootstrap', APPLIC_DIR_JS_VEND . '/bootstrap.min.js', array('jquery'), '3.3.7', true);
    wp_enqueue_script('jquery-easing', APPLIC_DIR_JS_VEND . '/jquery.easing.1.3.js', array('jquery'), '1.3', true);
    wp_enqueue_script('jquery-appear', APPLIC_DIR_JS_VEND . '/jquery.appear.js', array('jquery'), '1.0', true);
    wp_enqueue_script('owl-carousel', APPLIC_DIR_JS . '/owl.carousel.min.js', array('jquery'), '1.0', true);
    wp_enqueue_script('isotope', APPLIC_DIR_JS . '/isotope.pkgd.min.js', array('jquery'), '2.1.0', true);
    wp_enqueue_script('stellar', APPLIC_DIR_JS . '/stellar.js', array('jquery'), '0.6.2', true);
    wp_enqueue_script('parallax', APPLIC_DIR_JS . '/jquery.parallax-layer-scroll.js', array('jquery'), '1.0', true);
    wp_enqueue_script('chaffle', APPLIC_DIR_JS . '/chaffle.min.js', array('jquery'), '1.0', true);
    wp_enqueue_script('anime-js', APPLIC_DIR_JS . '/anime.min.js', array('jquery'), '1.0', true);
    wp_enqueue_script('jquery-modal-video', APPLIC_DIR_JS . '/jquery-modal-video.min.js', array('jquery'), '2.2.0', true);
    wp_enqueue_script('venobox', APPLIC_DIR_JS . '/venobox.min.js', array('jquery'), '1.8.3', true);
    wp_enqueue_script('stellarnav', APPLIC_DIR_JS . '/stellarnav.min.js', array('jquery'), '1.0', true);
    wp_enqueue_script('sticky', APPLIC_DIR_JS . '/jquery.sticky.js', array('jquery'), '1.0', true);

    wp_deregister_style( 'elementor-animations' );
    wp_enqueue_script('wow', APPLIC_DIR_JS . '/wow.min.js', array('jquery'), '1.1.2', true);
    wp_enqueue_script('placeholdem', APPLIC_DIR_JS . '/placeholdem.min.js', array('jquery'), '1.0', true);
    wp_enqueue_script('odometer', APPLIC_DIR_JS . '/odometer.min.js', array('jquery'), '1.0', true);
    
    wp_enqueue_script('resizesensor', APPLIC_DIR_JS . '/ResizeSensor.min.js', array('jquery'), '1.0', true);
    wp_enqueue_script('theia-sticky', APPLIC_DIR_JS . '/theia-sticky-sidebar.min.js', array('jquery'), '1.0', true);
    wp_enqueue_script('applic-main', APPLIC_DIR_JS . '/main.js', array('jquery'), '1.0', true);

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }

}
add_action('wp_enqueue_scripts', 'applic_scripts');

add_action('admin_enqueue_scripts', function () {
    wp_enqueue_script('applic-admin-js', APPLIC_DIR_JS . '/applic-admin.js', array('jquery'), '1.0', true);
});