<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Applic
 */
$opt              = get_option( 'applic_opt' );
$logo             = isset($opt['main_logo'] ['url']) ? $opt['main_logo'] ['url'] : '';
$sticky_logo      = isset($opt['sticky_logo'] ['url']) ? $opt['sticky_logo'] ['url'] : '';
$is_preloader     = isset($opt['is_preloader']) ? $opt['is_preloader'] : '';

$action_btn_url   = !empty( $opt['sign_up_url']['url'] ) ? $opt['sign_up_url']['url'] : '';
$action_btn_label = !empty( $opt['sign_up_label'] ) ? $opt['sign_up_label'] : '';
$is_search        = !empty( $opt['is_search'] ) ? $opt['is_search'] : '';

$is_action_btn    = function_exists( 'get_field' ) ? get_field( 'action_button_showhide' ) : '0';
$is_search_btn    = function_exists( 'get_field' ) ? get_field( 'search_button_showhide' ) : '0';

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta name="robots" content="INDEX, FOLLOW">
    <meta name="google-site-verification" content="moCbjhwKdVHNwIdCmhPnET8FTWUwR3DNQ6nd1hkCBwQ" />
    <!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id=G-L2BB2W3R2X"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'G-L2BB2W3R2X');
</script>
<!-- Global site tag (gtag.js) - Google Ads: 574219782 -->
<script async src="https://www.googletagmanager.com/gtag/js?id=AW-574219782"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', 'AW-574219782');
</script>
<!-- Event snippet for 99 adv conversion conversion page -->
<script>
  gtag('event', 'conversion', {'send_to': 'AW-574219782/2Fe_CNWmpoUDEIbM55EC'});
</script>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?> data-spy="scroll" data-target=".mainmenu-area" data-offset="90">
<?php wp_body_open(); ?>

    <!--- PRELOADER -->
    <?php if ($is_preloader == '1') { ?>
        <div class="preeloader">
            <div class="preloader-spinner"></div>
        </div>
        <?php
    } ?>

    <!--SCROLL TO TOP-->
    <a href="#scroolup" class="scrolltotop"><i class="fa fa-long-arrow-up"></i></a>

    <!--START TOP AREA-->
    <header class="top-area single-page" id="home">
        <div class="header-top-area" id="scroolup">
            <!--MAINMENU AREA-->
            <div class="mainmenu-area" id="mainmenu-area">
                <div class="mainmenu-area-bg"></div>
                <div class="cd-main-header animate-search">
                    <div id="search" class="cd-main-search">
                        <form action="<?php echo esc_url(home_url('/')); ?>">
                            <input type="search" placeholder="<?php esc_attr_e('Search ...', 'applic'); ?>" name="s">
                        </form>
                        <a href="#" class="close cd-text-replace"></a>
                        <div class="cd-cover-layer"></div>
                    </div>
                </div>
                <nav class="navbar">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-12 flex-v-center">
                                <div class="navbar-header">
                                    <?php
                                    if(!empty($logo)){
                                        ?>
                                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="custom-logo-link default-logo">
                                            <img src="<?php echo esc_url($logo); ?>" alt="<?php bloginfo('name'); ?>">
                                        </a>
                                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="custom-logo-link sticky-logo">
                                            <img src="<?php echo esc_url($sticky_logo); ?>" alt="<?php bloginfo('name'); ?>">
                                        </a>
                                    <?php } else {
                                        ?>
                                        <a href="<?php echo esc_url( home_url( '/' ) ) ?>"><h3> <?php echo get_bloginfo('name') ?> </h3></a>
                                        <?php
                                    } ?>
                                </div>
                                <svg class="ham hamRotate ham8" viewBox="0 0 100 100" width="50">
                                    <path class="line top" d="m 30,33 h 40 c 3.722839,0 7.5,3.126468 7.5,8.578427 0,5.451959 -2.727029,8.421573 -7.5,8.421573 h -20" />
                                    <path class="line middle" d="m 30,50 h 40" />
                                    <path class="line bottom" d="m 70,67 h -40 c 0,0 -7.5,-0.802118 -7.5,-8.365747 0,-7.563629 7.5,-8.634253 7.5,-8.634253 h 20" />
                                </svg>
                                <div id="main-nav" class="stellarnav">
                                    <?php
                                        if ( has_nav_menu('main_menu') ) {
                                            wp_nav_menu(array(
                                                'menu'           => 'main_menu',
                                                'theme_location' => 'main_menu',
                                                'container'      => null,
                                                'menu_class'     => 'nav navbar-nav pull-right',
                                                'menu_id'        => 'nav',
                                                'depth'          => 3,
                                                'walker'         => new applic_Nav_Walker(),
                                            ));
                                        }
                                    ?>
                                </div>
                                <?php
                                    if ( $is_action_btn || $is_search_btn ) {
                                        ?>
                                        <div class="header-call-to-action hidden-sm hidden-xs hidden-md">
                                            <?php if ( $action_btn_label ){ ?>
                                                <a href="<?php echo esc_url ( $action_btn_url ); ?>" class="action-button"><?php echo esc_html( $action_btn_label ); ?></a>
                                            <?php } ?>
                                            <?php if ( $is_search ){ ?>
                                                <a href="#search" class="search-button cd-search-trigger cd-text-replace"><i class="fa fa-search"></i></a>
                                            <?php } ?>
                                        </div>
                                        <?php
                                    }
                                ?>
                            </div>
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </header>

    <?php
    if ( is_home() || is_search() || is_archive() ) {
        $is_banner = '1';
    }

    if ( class_exists('WooCommerce') ) {
        if ( is_shop() || is_tax('product_cat') || is_tax('product_tag') || is_checkout() || is_cart() || is_singular('product') ) {
            $is_banner = '1';
        }
    }

    $is_banner = function_exists( 'get_field' ) ? get_field( 'is_banner' ) : '1';

    if ( !isset($is_banner) ) {
        $is_banner = '1';
    }

    if ( $is_banner == '1' ) :
        ?>
        <div class="barner-area white">
            <div class="area-bg"></div>
            <div class="container">
                <div class="row">
                    <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12">
                        <div class="barner-text mt50">
                            <h1><?php applic_banner_title(); ?></h1>
                            <ul class="breadcrumb no-bg mb0">
                                <li>
                                    <a href="<?php echo esc_url(home_url('/')) ?>">
                                        <?php esc_html_e('Home', 'applic'); ?>
                                    </a>
                                </li>
                                <li class="active">
                                    <?php applic_banner_title(); ?>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    endif;