<?php
/**
 * applic functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Applic
 */

if ( ! function_exists( 'applic_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function applic_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on applic, use a find and replace
		 * to change 'applic' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'applic', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		add_theme_support( 'post-formats', array('audio','quote') );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus( array(
			'main_menu' => esc_html__( 'Main Menu', 'applic' ),
			'footer_menu' => esc_html__( 'Footer Menu', 'applic' ),
		) );


		if( !function_exists('applic_detect_homepage') ){
		    function applic_detect_homepage() {
		        /*If front page is set to display a static page, get the URL of the posts page.*/
		        $homepage_id = get_option( 'page_on_front' );

		        /*current page id*/
		        $current_page_id = ( is_page( get_the_ID() ) ) ? get_the_ID() : '';

		        if( $homepage_id == $current_page_id ) {
		            return true;
		        } else {
		            return false;
		        }
		    }
		}

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

        add_theme_support('align-wide');
        add_theme_support('editor-styles');
        add_editor_style('style-editor.css');
        add_theme_support('responsive-embeds');

	}
endif;
add_action( 'after_setup_theme', 'applic_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function applic_content_width() {

	$GLOBALS['content_width'] = apply_filters( 'applic_content_width', 1170 );
}
add_action( 'after_setup_theme', 'applic_content_width', 0 );

/**
 * Constants
 * Defining default asset paths
 */
define('APPLIC_DIR_CSS', get_template_directory_uri().'/assets/css');
define('APPLIC_DIR_CSS_PLUG', get_template_directory_uri().'/assets/css/plugins');
define('APPLIC_DIR_JS', get_template_directory_uri().'/assets/js');
define('APPLIC_DIR_JS_VEND', get_template_directory_uri().'/assets/js/vendor');
define('APPLIC_DIR_IMG', get_template_directory_uri().'/assets/images');

/**
 * Enqueue scripts and styles.
 */
require get_template_directory() . '/inc/enqueue.php';

/**
 * Theme plugin activation
 */
require get_template_directory() . '/inc/plugin_activation.php';

/**
 * Register Sidebar Areas
 */
require get_template_directory() . '/inc/sidebars.php';

/**
 * Theme option
 */
require get_template_directory() . '/options/opt-config.php';

/**
 * Configure one click demo
 */
require get_template_directory() . '/inc/one_click_demo_config.php';

/**
 * Applic Template Function
 */
require get_template_directory() . '/inc/template-functions.php';
require get_template_directory() . '/inc/nav-menu-walker.php';

/**
 * Load WooCommerce compatibility file.
 */
if ( class_exists( 'WooCommerce' ) ) {
	require get_template_directory() . '/inc/woocommerce.php';
}