<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Applic
 */
    $opt = get_option('applic_opt');
    $footer_copyright = !empty(  $opt['copyright_txt'] ) ? $opt['copyright_txt'] : esc_html__( 'Copyright © QuomodoTheme All Right Reserved.', 'applic');
    $footer_widgets = isset( $opt['is_footer_widgets'] ) ? $opt['is_footer_widgets'] : '1';
    $active_footer_widget =  is_active_sidebar( 'footer_widgets1' ) || is_active_sidebar( 'footer_widgets2' ) || is_active_sidebar( 'footer_widgets3' ) || is_active_sidebar( 'footer_widgets4' );
    $footer_class = $active_footer_widget ? 'has_footer_widget' : 'no_widget';

    ?>
    <!--FOOER AREA-->
    <footer class="footer-area white relative <?php echo esc_attr( $footer_class ); ?>">
        <div class="area-bg"></div>
        <?php
        if( $active_footer_widget && $footer_widgets ) { ?>
            <div class="footer-top-area">
                <div class="container">
                    <div class="row">
                        <?php
                        if (is_active_sidebar('footer_widgets1')) {
                            dynamic_sidebar('footer_widgets1');
                        }

                        if (is_active_sidebar('footer_widgets2')) {
                            dynamic_sidebar('footer_widgets2');
                        }

                        if (is_active_sidebar('footer_widgets3')) {
                            dynamic_sidebar('footer_widgets3');
                        }

                        if (is_active_sidebar('footer_widgets4')) {
                            dynamic_sidebar('footer_widgets4');
                        }
                        ?>
                    </div>
                </div>
            </div>
            <?php
        }
        ?>

        <div class="footer-bottom-area">
            <div class="container">
                <div class="row">
                    <div class="col-md-12 col-lg-12 col-sm-12 col-xs-12">
                        <div class="footer-copyright text-center">
                            <p><?php echo wp_kses_post( $footer_copyright ); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!--FOOER AREA END-->

<?php wp_footer(); ?>
</body>
</html>