<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Applic
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>
<div class="comment-area">
	<?php if ( have_comments() ) : ?>
    <div class="all-comments">
        <h3 class="comments-title"><?php applic_comment_count(get_the_ID(), '') ?></h3>
        <div class="comment-list">
			<?php
				the_comments_navigation();
				wp_list_comments( array(
					'short_ping' => true,
					'callback'   => 'applic_comments'
				) );
				the_comments_navigation();
			?>
        </div>
        <?php 
			if ( ! comments_open() ) :
				?>
					<p class="no-comments mt50"><?php esc_html_e( 'Comments are closed.', 'applic' ); ?></p>
				<?php
			endif;
         ?>
    </div>
	<?php endif; ?>
	<?php if( comments_open() ) : ?>
    <div class="comment-box">
        <h3 class="reply-title"><?php esc_html_e('Leave A Reply', 'applic')?></h3>
        <div class="comment-form">
            <div class="row">
                <div class="col-md-12">
					<?php
					$commenter     = wp_get_current_commenter();
					$req           = get_option( 'require_name_email' );
					$aria_req      = ( $req ? " aria-required='true'" : '' );
					$fields        = array(
						'author' => '<input type="text" name="author" id="name" placeholder="' . esc_attr__( 'Name..', 'applic' ) . '" value="' . esc_attr( $commenter['comment_author'] ) . '" ' . $aria_req . '>',
						'email'  => '<input type="email" name="email" id="email" placeholder="' . esc_attr__( 'Email..', 'applic' ) . '" value="' . esc_attr( $commenter['comment_author_email'] ) . '" ' . $aria_req . '>',
						'url'    => '<input type="url" name="url" id="website" placeholder="' . esc_attr__( 'Website..', 'applic' ) . '" value="' . esc_attr( $commenter['comment_author_url'] ) . '" >',
					);
					$comments_args = array(
						'fields'               => apply_filters( 'comment_form_default_fields', $fields ),
						'class_form'           => 'comment-form-s',
						'class_submit'         => '',
						'title_reply'          => '',
						'label_submit'         => esc_html__( 'Post Comment', 'applic' ),
						'comment_notes_before' => '',
						'comment_field'        => '<textarea name="comment" id="comment" cols="30" rows="6" placeholder="' . esc_attr__( 'Comments..', 'applic' ) . '"></textarea>',
						'comment_notes_after'  => '',
						'submit_field'         => '%1$s %2$s',
						'submit_button'        => '<input type="submit" value="' . esc_attr( '%4$s', 'applic' ) . '">'
					);
					comment_form( $comments_args );
					?>
                </div>
            </div>
        </div>
    </div>
	<?php endif; ?>
</div>