<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Applic
 */

get_header();
$opt = get_option('applic_opt');
$error_title =!empty($opt['error_title']) ?  $opt['error_title'] : esc_html__('Oops! That page can&rsquo;t be found.', 'applic');
$error_subtitle = !empty($opt['error_subtitle']) ? $opt['error_subtitle'] : esc_html__('It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'applic');
$error_btn = !empty($opt['error_btn']) ? $opt['error_btn'] : esc_html__('Back To Home', 'applic');
$error_img = !empty($opt['error_img']['url']) ? $opt['error_img']['url'] : get_template_directory_uri() .'/assets/images/error-image.png';
?>
    <section class="error-404 no-results blog-sidebar single-widgets sm-center xs-center">
        <div class="container">
            <div class="row flex-v-center">
                <div class="col-md-6">
                    <div class="error-img">
                        <img src="<?php echo esc_url( $error_img ) ?>" alt="404-img">
                    </div>
                </div>
                <div class="col-md-6">
                    <header class="page-header">
                        <h1 class="page-title-404"><?php echo esc_html( $error_title ) ?></h1>
                    </header>
                    <div class="page-content widget widget_search">
                        <p><?php echo esc_html( $error_subtitle ) ?></p>
                        <?php get_search_form(); ?>
                        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="read-more">
                            <?php echo esc_html( $error_btn ) ?>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php
get_footer();