<?php 

namespace Shop_Ready\extension\recentvisit\account;

class Report_Menu {
  
    public $end_point = 'myreport';
    public function register(){
        
        add_action( 'init', [ $this, 'add_endpoint_' ] );
        //add_filter( 'woocommerce_account_menu_items', [ $this, 'account_menu_items' ],19 );
        //add_action( 'woocommerce_account_'.$this->end_point.'_endpoint', [ $this, 'template_content' ],40 );
        add_filter( 'template_include', [$this, 'render'], 100 );
        add_filter( 'woocommerce_get_query_vars', [$this, 'woocommerce_get_query_vars'], 100 );
      
    }

    public function woocommerce_get_query_vars($vars){
       
        $vars[$this->end_point] = $this->end_point;
        return $vars;
    }

    public function add_endpoint_(){
        add_rewrite_endpoint( $this->end_point, EP_PAGES );
        flush_rewrite_rules();
    }

  public function account_menu_items($items){
       
        $logout = $items['customer-logout'];
        unset( $items['customer-logout'] );

        
        $items[$this->end_point] = __( 'Shop Report', 'shop-ready' );

     
        $items['customer-logout'] = $logout;

        return $items;
  }

  public function template_content($end_point){

     if($end_point == $this->end_point){
        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display(329);    
     }
  }

  public function render($template){
     
      if(shop_ready_is_account_custom_end_point($this->end_point) && $this->end_point == shop_ready_wc_get_current_endpoint()){
         
        return SHOP_READY_DIR_PATH.'src/extension/recentvisit/account/template/full-width.php';
      }
    
      
      return $template;
  }
   
}