<?php

namespace Shop_Ready\extension\elewidgets\widgets\shop;
use Shop_Ready\system\base\Repository\Product_Modal;

class Product_Grid extends \Shop_Ready\extension\elewidgets\Widget_Base {

    protected function register_controls() {

        $this->start_controls_section(
            'section_product_grid_layout_tab',
            [
                'label' => esc_html__( 'Layout Options', 'shop-ready' ),
            ]
        );

        $this->add_control(
            'wooready_products_grid_layout_select',
            [
                'label'   => esc_html__( 'Layout', 'shop-ready' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => __( 'default', 'shop-ready' ),
                'options' => apply_filters( 'shop_ready_shop_product_grid', [

                    'default' => esc_html__( 'Default', 'shop-ready' ),
                    'pro_sy'  => esc_html__( 'Pro Style 1', 'shop-ready' ),
                    'pro_sy2' => esc_html__( 'Pro Style 2', 'shop-ready' ),
                    'pro_sy3' => esc_html__( 'Pro Style 3', 'shop-ready' ),
                    'pro_sy4' => esc_html__( 'Pro Style 4', 'shop-ready' ),
                   
               
                ] ),
            ]
        );

        $this->add_responsive_control(
            'wooready_products_grid_layout_column',
            [
                'label'   => esc_html__( 'Column', 'shop-ready' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
                'default' => __( '4', 'shop-ready' ),
                'options' => [

                    '1' => __( '1', 'shop-ready' ),
                    '2' => __( '2', 'shop-ready' ),
                    '3' => __( '3', 'shop-ready' ),
                    '4' => __( '4', 'shop-ready' ),
                    '5' => __( '5', 'shop-ready' ),
                    '6' => __( '6', 'shop-ready' ),
                    '7' => __( '7', 'shop-ready' ),
                    '8' => __( '8', 'shop-ready' ),
                    '' => __( 'None', 'shop-ready' ),
            
                ],

                'selectors' => [
                    '{{WRAPPER}} .woo-ready-product-grid-layout .display\:grid' => 'grid-template-columns:repeat({{VALUE}}, 1fr);',
                ],
            ]
        );

        $this->add_control(
            'wooready_products_grid_sale_text',
            [
                'label'       => __( 'Sale Text', 'shop-ready' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => __( 'Sale', 'shop-ready' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'wooready_products_grid_popular_text',
            [
                'label'       => __( 'Popular Text', 'shop-ready' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => __( 'Popular', 'shop-ready' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'wooready_products_grid_featured_text',
            [
                'label'       => __( 'Featured Text', 'shop-ready' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => __( 'Featured', 'shop-ready' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'wooready_products_grid_addtocart_text',
            [
                'label'       => __( 'Cart Text', 'shop-ready' ),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'default'     => __( 'Add to cart', 'shop-ready' ),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_product_grid_icon_tab',
            [
                'label' => esc_html__( 'Icon Options', 'shop-ready' ),
            ]
        );

        $this->add_control(
			'add_to_cart_icon',
			[
				'label' => __( 'Cart Icon', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa fa-shopping-cart',
					'library' => 'solid',
				],
                'label_block' => true,
			]
		);

        $this->add_control(
			'quick_view_icon',
			[
				'label' => __( 'Quick View Icon', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa fa-eye',
					'library' => 'solid',
				],
                'label_block' => true,
			]
		);

        $this->add_control(
			'wishlist_icon',
			[
				'label' => __( 'Wishlist Icon', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa fa-heart-o',
					'library' => 'solid',
				],
                'label_block' => true,
			]
		);

        $this->add_control(
			'refresh_icon',
			[
				'label' => __( 'Refresh Icon', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa fa-refresh',
					'library' => 'solid',
				],
                'label_block' => true,
			]
		);

        $this->end_controls_section();

        do_action( 'shop_ready_section_product_minimum_general_tab', $this, $this->get_name() );
        do_action( 'shop_ready_product_taxonomy_filter_tab', $this, $this->get_name() );
        do_action( 'shop_ready_section_sort_tab', $this, $this->get_name() );
        do_action( 'shop_ready_section_date_filter_tab', $this, $this->get_name() );
        do_action( 'shop_ready_section_data_exclude_tab', $this, $this->get_name() );

        // Product grid main layout

        $this->box_css(
            [
                'title'        => esc_html__( 'Main Wrapper', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_main_wrapper',
                'element_name' => 's__wooready_products_grid_main_wrapper',
                'selector'     => '{{WRAPPER}} .woo-ready-product-grid-layout',
            ]
        );

        // Product Box Wrapper

        $this->box_css(
            [
                'title'        => esc_html__( 'Product Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_wrapper',
                'element_name' => 's__wooready_products_grid_product_wrapper',
                'selector'     => '{{WRAPPER}} .woo-ready-product-grid-layout .wooready_product_components',
            ]
        );

        // Main Product  Layout Wrapper

        $this->box_css(
            [
                'title'        => esc_html__( 'Product Layout Wrapper', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_layout_wrapper',
                'element_name' => 's__wooready_products_grid_product_layout_wrapper',
                'selector'     => '{{WRAPPER}} .woo-ready-product-grid-layout .wooready_product_components .wooready_product_layout_wrapper',
            ]
        );

        // All Product Thumb Wrapper

        $this->box_css(
            [
                'title'        => esc_html__( 'Product Thumb Wrapper', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_thumb_wrapper',
                'element_name' => 's__wooready_products_grid_product_thumb_wrapper',
                'selector'     => '{{WRAPPER}} .woo-ready-product-grid-layout .wooready_product_components .wooready_product_layout_wrapper .wooready_product_thumb, {{WRAPPER}} .woo-ready-product-grid-layout .wooready_product_components .wooready_product_layout_wrapper .wooready_course_thumb',
            ]
        );

        // All Product Image Wrapper

        $this->box_css(
            [
                'title'        => esc_html__( 'Image Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_image_box',
                'element_name' => 's__wooready_products_grid_product_image_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_thumb img, {{WRAPPER}} .wooready_course_product_layout .wooready_course_thumb img',
            ]
        );

        // All Product Image Size

        $this->element_size(
            [
                'title'        => esc_html__( 'Image Size', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_image_size',
                'element_name' => 's__wooready_products_grid_product_image_size',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_thumb img, {{WRAPPER}} .wooready_course_product_layout .wooready_course_thumb img',
            ]
        );


        $this->text_minimum_css(
            [
                'title'          => esc_html__('Sale Discount','shop-ready'),
                'slug'           => 'wooready_products_grid_product_sale_discount',
                'element_name'   => 's__wooready_products_grid_product_sale_discount',
                'selector'       => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_thumb .wooready_sell_discount',
                'hover_selector' => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_thumb .wooready_sell_discount:hover',
                'condition'       => [
                    'wooready_products_grid_layout_select' => ['default', 'style1', 'style2']
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'          => esc_html__('Popularity Box','shop-ready'),
                'slug'           => 'wooready_products_grid_product_popularity_box',
                'element_name'   => 's__wooready_products_grid_product_popularity_box',
                'selector'       => '{{WRAPPER}} .wooready_course_product_layout .wooready_course_thumb span.wooready_course_category',
                'hover_selector' => '{{WRAPPER}} .wooready_course_product_layout .wooready_course_thumb .span.wooready_course_category:hover',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3', 'style4']
                ],
            ]
        );

        $this->position_css(
            [
                'title'          => esc_html__('Sale Discount Position','shop-ready'),
                'slug'           => 'wooready_products_grid_product_sale_discount_position',
                'element_name'   => 's__wooready_products_grid_product_sale_discount_position',
                'selector'       => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_thumb .wooready_sell_discount',
                'condition'       => [
                    'wooready_products_grid_layout_select' => ['default', 'style1', 'style2']
                ],
            ]
        );

        $this->position_css(
            [
                'title'          => esc_html__('Popularity Box Position','shop-ready'),
                'slug'           => 'wooready_products_grid_product_popularity_box_position',
                'element_name'   => 's__wooready_products_grid_product_popularity_box_position',
                'selector'       => '{{WRAPPER}} .wooready_course_product_layout .wooready_course_thumb span.wooready_course_category',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3', 'style4']
                ],
            ]
        );
        
        $this->box_css(
            [
                'title'        => esc_html__( 'Product Content Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_content_box',
                'element_name' => 's__wooready_products_grid_product_content_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box',
                'condition'       => [
                    'wooready_products_grid_layout_select' => ['default', 'style1', 'style2']
                ],
            ]
        );
        
        $this->element_before_psudocode(
            [
                'title'        => esc_html__( 'Product Content Before', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_content_before',
                'element_name' => 's__wooready_products_grid_product_content_before',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box::before',
                'condition'       => [
                    'wooready_products_grid_layout_select' => ['default', 'style1', 'style2']
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Course Content Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_course_content_box',
                'element_name' => 's__wooready_products_grid_product_course_content_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_content',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3', 'style4']
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Product Category Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_category_box',
                'element_name' => 's__wooready_products_grid_product_category_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_product_category',
                'condition'       => [
                    'wooready_products_grid_layout_select' => ['style2']
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Category Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_category_style',
                'element_name' => 's__wooready_products_grid_product_category_style',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_product_category a',
                'condition'       => [
                    'wooready_products_grid_layout_select' => ['style2']
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Title Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_title_box',
                'element_name' => 's__wooready_products_grid_product_title_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_title, {{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_course_title',
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Title Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_title_style',
                'element_name' => 's__wooready_products_grid_product_title_style',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_title .title a, {{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_content .wooready_course_title .title a',
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Product Review Wrapper', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_review_price_box',
                'element_name' => 's__wooready_products_grid_product_review_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_review',
              
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Product Price Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_price_box',
                'element_name' => 's__wooready_products_grid_product_price_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_review .wooready_price_box',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'default', 'style1', 'style2' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Course Review & Price Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_course_review_price_box',
                'element_name' => 's__wooready_products_grid_product_review_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_content .wooready_course_price_item',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3', 'style4']
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Course Price Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_course_price_box',
                'element_name' => 's__wooready_products_grid_product_course_price_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_content .wooready_course_price_item .wooready_course_price',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3', 'style4']
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Price', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_normal_price_default_style1_style',
                'element_name' => 's__wooready_products_grid_product_normal_price_default_style1_style',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_default .wooready_price_box .wooready_price_normal .amount, {{WRAPPER}} .woo-ready-product-grid-layout-style1 .wooready_price_box .wooready_price_normal .amount',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'default', 'style1' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Normal Price', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_normal_price_style2',
                'element_name' => 's__wooready_products_grid_product_normal_price_style2',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_two .wooready_price_box > .amount, {{WRAPPER}} .wooready_product_layout_two .wooready_price_box del .amount',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style2' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Discount Price', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_discount_price_style2',
                'element_name' => 's__wooready_products_grid_product_discount_price_style2',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_two .wooready_price_box ins .amount',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style2' ],
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Normal Price', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_normal_price_style3_style4',
                'element_name' => 's__wooready_products_grid_product_normal_price_style3_style4',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_content .wooready_course_price_item .wooready_course_price .wooready_price_normal .woocommerce-Price-amount, {{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_content .wooready_course_price_item .wooready_course_variable_price',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3', 'style4'],
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Discount Price', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_discount_price_style3_style4',
                'element_name' => 's__wooready_products_grid_product_discount_price_style3_style4',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_content .wooready_course_price_item .wooready_course_price .wooreadu_discount_price .woocommerce-Price-amount',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3', 'style4' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Product Review Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_review_box',
                'element_name' => 's__wooready_products_grid_product_review_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_review .wooready_review_box',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'default', 'style1', 'style2' ]
                ],
            ]
        );

        $this->text_css(
            [
                'title'        => esc_html__( 'Review Item', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_review_item_default_one_two_style',
                'element_name' => 's__wooready_products_grid_product_review_item_default_one_two_style',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_review .wooready_review_box li i',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'default', 'style1', 'style2' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Course Review Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_review_box',
                'element_name' => 's__wooready_products_grid_course_review_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_content .wooready_course_price_item .wooready_course_review',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3', 'style4' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Review Item', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_review_item_style',
                'element_name' => 's__wooready_products_grid_product_review_item_style',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_review .wooready_review_box li, {{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_content .wooready_course_price_item .wooready_course_review ul li',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3', 'style4' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Rating Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_review_rating_style',
                'element_name' => 's__wooready_products_grid_product_review_rating_style',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_content .wooready_course_price_item .wooready_course_review span',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3', 'style4' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Cart Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_cart_box_default_style1',
                'element_name' => 's__wooready_products_grid_product_cart_box_default_style1',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_product_cart_box, {{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_thumb .wooready_product_cart_box',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'default', 'style1' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Cart Link Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_cart_link_box_default_style1',
                'element_name' => 's__wooready_products_grid_product_cart_link_box_default_style1',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_product_cart_box .wooready_product_cart, {{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_thumb .wooready_product_cart_box .wooready_product_cart',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'default', 'style1' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Cart Link Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_cart_link_style_default_style1',
                'element_name' => 's__wooready_products_grid_product_cart_link_style_default_style1',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_product_cart_box .wooready_product_cart a, {{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_thumb .wooready_product_cart_box .wooready_product_cart a',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'default', 'style1' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Cart Link Icon', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_cart_link_icon_style_default_style1',
                'element_name' => 's__wooready_products_grid_product_cart_link_icon_style_default_style1',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_product_cart_box .wooready_product_cart a i, {{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_thumb .wooready_product_cart_box .wooready_product_cart a i',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'default', 'style1' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Popup Link Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_cart_popup_box_default_style1',
                'element_name' => 's__wooready_products_grid_product_cart_popup_box_default_style1',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_product_cart_box .wooready_product_popup, {{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_thumb .wooready_product_cart_box .wooready_product_popup',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'default', 'style1' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Popup Link Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_cart_popup_link_style_default_style1',
                'element_name' => 's__wooready_products_grid_product_cart_popup_link_style__default_style1',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_product_cart_box .wooready_product_popup a i, {{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_thumb .wooready_product_cart_box .wooready_product_popup a i',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'default', 'style1' ]
                ],
            ]
        );


        $this->box_css(
            [
                'title'        => esc_html__( 'Color box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_color_box',
                'element_name' => 's__wooready_products_grid_product_color_boxx',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_product_color',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style2' ]
                ],
            ]
        );


        $this->box_css(
            [
                'title'        => esc_html__( 'Cart Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_cart_box_style2',
                'element_name' => 's__wooready_products_grid_product_cart_box_style2',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_product_cart_box',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style2' ]
                ],
            ]
        );

        $this->text_css(
            [
                'title'        => esc_html__( 'Cart Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_cart_box_style_style2',
                'element_name' => 's__wooready_products_grid_product_cart_box_style_style2',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_product_cart_box .wooready_product_cart a',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style2' ]
                ],
            ]
        );

        $this->text_css(
            [
                'title'        => esc_html__( 'Cart Icon', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_cart_box_icon_style_style2',
                'element_name' => 's__wooready_products_grid_product_cart_box_icon_style_style2',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_content_box .wooready_product_cart_box .wooready_product_cart a i',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style2' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Popup Link Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_cart_popup_box_default_style2',
                'element_name' => 's__wooready_products_grid_product_cart_popup_box_default_style2',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_thumb .wooready_product_cart_box .wooready_product_popup',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style2' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Popup Link Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_cart_popup_link_style_default_style2',
                'element_name' => 's__wooready_products_grid_product_cart_popup_link_style__default_style2',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_product_thumb .wooready_product_cart_box .wooready_product_popup a i',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style2' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Course Cart/Popup Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_cart_popup_box_style3',
                'element_name' => 's__wooready_products_grid_product_cart_popup_box_style3',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_thumb .wooready_product_cart_box',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Course Cart Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_cart_box_style3',
                'element_name' => 's__wooready_products_grid_product_cart_box_style3',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_thumb .wooready_product_cart_box .wooready_product_cart',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Course Cart Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_cart_box_style_style3',
                'element_name' => 's__wooready_products_grid_product_cart_box_style_style3',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_thumb .wooready_product_cart_box .wooready_product_cart a',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Course Cart Icon', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_cart_box_icon_style_style3',
                'element_name' => 's__wooready_products_grid_product_cart_box_icon_style_style3',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_thumb .wooready_product_cart_box .wooready_product_cart a i',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Course Popup Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_popup_box_style3',
                'element_name' => 's__wooready_products_grid_product_popup_box_style3',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_thumb .wooready_product_cart_box .wooready_product_popup',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Course Quickview Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_popup_box_quickview_style3',
                'element_name' => 's__wooready_products_grid_product_popup_box_quickview_style3',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_thumb .wooready_product_cart_box .wooready_product_popup .wready-product-quickview',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Course Wishlist Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_popup_box_wishlist_style3',
                'element_name' => 's__wooready_products_grid_product_popup_box_wishlist_style3',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_thumb .wooready_product_cart_box .wooready_product_popup .wready-product-wishlist',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Refresh Button Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_popup_box_refresh_style3',
                'element_name' => 's__wooready_products_grid_product_popup_box_refresh_style3',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_thumb .wooready_product_cart_box .wooready_product_popup .wready-product-refresh',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Course Sub Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_sub_box',
                'element_name' => 's__wooready_products_grid_course_sub_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_content .wooready_course_sub_item',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Course Sub Item', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_sub_item_box',
                'element_name' => 's__wooready_products_grid_course_sub_item_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_content .wooready_course_sub_item ul li',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Course Sub Item style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_sub_item_style',
                'element_name' => 's__wooready_products_grid_course_sub_item_style',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_content .wooready_course_sub_item ul li a',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style3' ]
                ],
            ]
        );


        // Layout Four Course Overly Styles

        $this->box_css(
            [
                'title'        => esc_html__( 'Course Overly Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_cart_overly_box',
                'element_name' => 's__wooready_products_grid_product_cart_overly_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_product_overlay',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style4' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Overly Title Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_overly_title_box_style4',
                'element_name' => 's__wooready_products_grid_course_overly_title_box_style4',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_product_overlay .wooready_course_title',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style4' ]
                ],
            ]
        );

        $this->text_css(
            [
                'title'        => esc_html__( 'Overly Title Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_overly_title_style_style4',
                'element_name' => 's__wooready_products_grid_course_overly_title_style_style4',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_product_overlay .wooready_course_title .title a',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style4' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Overly Review Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_overly_review_box_style4',
                'element_name' => 's__wooready_products_grid_course_overly_review_box_style4',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_product_overlay .wooready_course_review',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style4' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Overly Review Item', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_overly_review_item_style',
                'element_name' => 's__wooready_products_grid_product_overly_review_item_style',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_product_overlay .wooready_course_review ul li',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style4' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Overly Rating Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_product_overly_review_rating_style',
                'element_name' => 's__wooready_products_grid_product_overly_review_rating_style',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_product_overlay .wooready_course_review span',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style4' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Overly Cart Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_cart_box_style4',
                'element_name' => 's__wooready_products_grid_product_cart_box_style4',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_product_overlay .wooready_course_cart',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style4' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Overly Cart Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_overly_cart_box_style4_style',
                'element_name' => 's__wooready_products_grid_course_overly_cart_box_style4_style',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_product_overlay .wooready_course_cart a',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style4' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Overly Cart Icon Style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_cart_box_style4_icon_style',
                'element_name' => 's__wooready_products_grid_course_cart_box_style4_icon_style',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_product_overlay .wooready_course_cart a i',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style4' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Overly Course Sub Box', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_overly_sub_box',
                'element_name' => 's__wooready_products_grid_course_overly_sub_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_product_overlay .wooready_course_sub_item',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style4' ]
                ],
            ]
        );

        $this->box_css(
            [
                'title'        => esc_html__( 'Overly Course Sub Item', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_overly_sub_item_box',
                'element_name' => 's__wooready_products_grid_course_overly_sub_item_box',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_product_overlay .wooready_course_sub_item ul li',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style4' ]
                ],
            ]
        );

        $this->text_minimum_css(
            [
                'title'        => esc_html__( 'Overly Course Sub Item style', 'shop-ready' ),
                'slug'         => 'wooready_products_grid_course_overly_sub_item_style',
                'element_name' => 's__wooready_products_grid_course_overly_sub_item_style',
                'selector'     => '{{WRAPPER}} .wooready_product_layout_wrapper .wooready_course_product_overlay .wooready_course_sub_item ul li a',
                'condition'       => [
                    'wooready_products_grid_layout_select' => [ 'style4' ]
                ],
            ]
        );

    }

    protected function html() {

        $settings      = $this->get_settings_for_display();
       
        $product_Modal = new Product_Modal( $settings );
        $product_Modal->set_post_type();
        $products = $product_Modal->get_posts();

        $add_to_cart_icon = shop_ready_render_icons( $settings['add_to_cart_icon'] , 'wready-icons' );
        $quick_view_icon  = shop_ready_render_icons( $settings['quick_view_icon'] , 'wready-icons' );
        $wishlist_icon    = shop_ready_render_icons( $settings['wishlist_icon'] , 'wready-icons' );
        $refresh_icon     = shop_ready_render_icons( $settings['refresh_icon'] , 'wready-icons' );

        $sale_text       = $settings['wooready_products_grid_sale_text'] ? $settings['wooready_products_grid_sale_text'] : esc_html__( 'Sale', 'shop-ready' );
        $popular_text    = $settings['wooready_products_grid_popular_text'] ? $settings['wooready_products_grid_popular_text'] : esc_html__( 'Popular', 'shop-ready' );
        $featured_text   = $settings['wooready_products_grid_featured_text'] ? $settings['wooready_products_grid_featured_text'] : esc_html__( 'Featured', 'shop-ready' );
        $cart_text       = $settings['wooready_products_grid_addtocart_text'] ? $settings['wooready_products_grid_addtocart_text'] : esc_html__( 'Add to cart', 'shop-ready' );
        $post_title_crop = $settings['post_title_crop'] ? $settings['post_title_crop'] : 5;

        $data_settings = [
            'products'         => $products,
            'sale_text'        => $sale_text,
            'popular_text'     => $popular_text,
            'featured_text'    => $featured_text,
            'cart_text'        => $cart_text,
            'post_title_crop'  => $post_title_crop,
            'add_to_cart_icon' => $add_to_cart_icon,
            'quick_view_icon'  => $quick_view_icon,
            'wishlist_icon'    => $wishlist_icon,
            'refresh_icon'     => $refresh_icon,
            'image_size'       => $settings['product_image_size_size'],
        ];

        $this->add_render_attribute(
            'woo_ready_product_grid_wrapper_style',
            [
                'class' => ['woo-ready-product-grid-layout', 'woo-ready-product-grid-layout-' . $settings['wooready_products_grid_layout_select']],
            ]
        );

        echo sprintf( "<div %s>", $this->get_render_attribute_string( 'woo_ready_product_grid_wrapper_style' ) );
        echo sprintf( "<div class='display:grid grid-template-columns-%s'>", 4 );

        if ( file_exists( dirname( __FILE__ ) . '/template-parts/grid/' . $settings['wooready_products_grid_layout_select'] . '.php' ) ) {

            shop_ready_widget_template_part(
                'shop/template-parts/grid/' . $settings['wooready_products_grid_layout_select'] . '.php',
                [
                    'settings' => $data_settings,
                ]
            );

        } else {

            shop_ready_widget_template_part(
                'shop/template-parts/grid/default.php',
                [
                    'settings' => $data_settings,
                ]
            );

        }

        echo '</div></div>';

    }

}