<?php

	/**
	 * Single Product Rating
	 */

	if ( ! defined( 'ABSPATH' ) ) {
		exit; // Exit if accessed directly.
	}

	$id = get_the_id();

	if(shop_ready_is_elementor_mode()){

		if($settings['wready_product_id'] !=''){
			$id = $settings['wready_product_id'];
		}
		
	}

	global $product;
	
    $product = is_null($product)? wc_get_product($id): $product;

	if(!is_object($product)){
		return;
    }
	if(	!method_exists(	$product,'get_rating_count')	){
		return;
	}

	$rating_count = $product->get_rating_count();
	$review_count = $product->get_review_count();
	$average      = $product->get_average_rating();

	if ( $rating_count > 0 ) : ?>

		<div class="woocommerce-product-rating">
			<?php echo wc_get_rating_html( $average, $rating_count ); // WPCS: XSS ok. ?>
			<?php if ( comments_open() ) : ?>
				<?php //phpcs:disable ?>
				<a href="#<?php echo wp_kses_post($settings['review_form_section']); ?>" class="woocommerce-review-link" rel="nofollow">(<?php printf( _n( '%s customer review', '%s customer reviews', $review_count, 'shop-ready' ), '<span class="count">' . esc_html( $review_count ) . '</span>' ); ?>)</a>
				<?php // phpcs:enable ?>
			<?php endif ?>
		</div>

	<?php endif; ?>
