<?php

namespace Shop_Ready\extension\elewidgets\widgets\product;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Modules\DynamicTags\Module as TagsModule;
use Elementor\Utils;
/**
 * WooCommerce Product Related
 * @see https://docs.woocommerce.com/document/related-products-up-sells-and-cross-sells/
 * @author quomodosoft.com
 */
class Related extends \Shop_Ready\extension\elewidgets\Widget_Base {
    
	
    /**
	 * Html Wrapper Class of html 
	 */
	public $wrapper_class = false;

	protected function register_controls() {

			// Notice 
			$this->start_controls_section(
			'notice_content_section',
				[
					'label' => esc_html__( 'Notice', 'shop-ready' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);
	
				$this->add_control(
					'woo_ready_usage_direction_notice',
					[
						'label'           => esc_html__( 'Important Note', 'shop-ready' ),
						'type'            => \Elementor\Controls_Manager::RAW_HTML,
						'raw'             => esc_html__( 'Use This Widget in WooCommerce Product Details page  Template.', 'shop-ready' ),
						'content_classes' => 'woo-ready-product-page-notice',
					]
				);
	
			$this->end_controls_section(); 
			
			$this->start_controls_section(
				'editor_content_section',
				[
					'label' => esc_html__( 'Editor Refresh', 'shop-ready' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

				$this->add_control(
					'show_product_content',
					[
						'label'        => esc_html__( 'Content Refresh?', 'shop-ready' ),
						'type'         => \Elementor\Controls_Manager::SWITCHER,
						'label_on'     => esc_html__( 'Yes', 'shop-ready' ),
						'label_off'    => esc_html__( 'No', 'shop-ready' ),
						'return_value' => 'yes',
						'default'      => '',
					]
				);

				$this->add_control(
					'wready_product_id',
					[
						'label'   => esc_html__( 'Demo Product', 'shop-ready' ),
						'type' => \Elementor\Controls_Manager::SELECT2,
						'multiple' => false,
						'default' => shop_ready_get_single_product_key(),
						'options' =>  shop_ready_get_latest_products_id(10)
					]
				);
 
			$this->end_controls_section();

			$this->start_controls_section(
				'layouts_cart_content_section',
				[
					'label' => esc_html__( 'Layout', 'shop-ready' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);
	
				$this->add_control(
					'style',
					[
						'label'   => esc_html__( 'Layout', 'shop-ready' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'default' => 'default',
						'options' => [
							'default'     => esc_html__('Default','shop-ready'),
							//'wready-rating-two'   => esc_html__('Style 2','shop-ready'),
					
						]
					]
				);
	
	
		$this->end_controls_section();

        $this->start_controls_section(
			'section_related_products_content',
			[
				'label' => __( 'Related Products', 'shop-ready' ),
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label' => __( 'Products Per Page', 'shop-ready' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 4,
				'range' => [
					'px' => [
						'max' => 20,
					],
				],
			]
		);

		$this->add_responsive_control(
            'product_grid_column_items_gap',
            [
                'label'      => esc_html__( 'Column gap', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                
                'size_units' => ['px'],
                'range'      => [

                    'px' => [
                        'min'  => 0,
                        'max'  => 130,
                        'step' => 2,
                    ],

                ],
                'default' => [
					'unit' => 'px',
					'size' => 3,
				],

                'selectors'  => [
                    '{{WRAPPER}} .woo-ready-products' => 'column-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'product_grid_row_items_gap',
            [
                'label'      => esc_html__( 'Row gap', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
               
                'size_units' => ['px'],
                'range'      => [

                    'px' => [
                        'min'  => 0,
                        'max'  => 130,
                        'step' => 2,
                    ],

                ],
                'default' => [
					'unit' => 'px',
					'size' => 20,
				],

                'selectors'  => [
                    '{{WRAPPER}} .woo-ready-products' => 'row-gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

		$this->add_responsive_control(
            'main_section_related_grid_col',
            [
                'label'      => esc_html__( 'Columns', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [

                    'px' => [
                        'min'  => 1,
                        'max'  => 13,
                        'step' => 1,
                    ],

                ],
				'default' => [
					'unit' => 'px',
					'size' => 3,
				],

                'selectors'  => [
                    '{{WRAPPER}} .woo-ready-products' => 'grid-template-columns: repeat( {{SIZE}}, 1fr);',

                ],
            ]
        );

		$this->add_control(
			'orderby',
			[
				'label' => __( 'Order By', 'shop-ready' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'date',
				'options' => [
					'date' => __( 'Date', 'shop-ready' ),
					'title' => __( 'Title', 'shop-ready' ),
					'price' => __( 'Price', 'shop-ready' ),
					'popularity' => __( 'Popularity', 'shop-ready' ),
					'rating' => __( 'Rating', 'shop-ready' ),
					'rand' => __( 'Random', 'shop-ready' ),
					'menu_order' => __( 'Menu Order', 'shop-ready' ),
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label' => __( 'Order', 'shop-ready' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'desc',
				'options' => [
					'asc' => __( 'ASC', 'shop-ready' ),
					'desc' => __( 'DESC', 'shop-ready' ),
				],
			]
		);

		$this->end_controls_section();
	
	
		/**
		 * Layouts Total Table
		 */
		$this->box_layout(
			[
				'title'          => esc_html__('Container Wrapper','shop-ready'),
				'slug'           => 'wready_wc__product_meta',
				'element_name'   => '__wrapper',
				'selector'       => '{{WRAPPER}} .product_meta',
				
			]
		);
	
	
		/* Layouts End */

	
		$this->text_css(
			[
				'title'          => esc_html__('Tags','shop-ready'),
				'slug'           => 'wready_wc_product_tag',
				'element_name'   => 'wrating_product_tag',
				'selector'       => '{{WRAPPER}} .tagged_as a',
				'hover_selector' => '{{WRAPPER}} .tagged_as a:hover',
				
			]
		);

	
	}

    /**
	 * Override By elementor render method
	 * @return void
	 * 
	 */
	protected function html() {

		$settings = $this->get_settings_for_display();
	
	    $this->add_render_attribute(
			'wrapper_style',
			[
				'class' => [ 'woo-ready-related-product-layout', $settings['style'] ],
			]
		);

        echo sprintf("<div %s>",$this->get_render_attribute_string( 'wrapper_style' ));

			if(file_exists(dirname(__FILE__). '/template-parts/related/'.$settings['style'].'.php')){

				shop_ready_widget_template_part(
					'product/template-parts/related/'.$settings['style'].'.php',
					array(
						'settings'              => $settings,
					
					)
				);

			}else{

                shop_ready_widget_template_part(
					'product/template-parts/related/default.php',
					array(
						'settings' => $settings,
					)
				);

			}
			
		echo '</div>';
	}

}