<?php

namespace Shop_Ready\extension\elewidgets\widgets\product;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Modules\DynamicTags\Module as TagsModule;
use Elementor\Utils;
/**
 * WooCommerce Product Title | Name
 * @see https://docs.woocommerce.com/document/managing-products/
 * @author quomodosoft.com
 */
class Price extends \Shop_Ready\extension\elewidgets\Widget_Base {
    
	
    /**
	 * Html Wrapper Class of html 
	 */
	public $wrapper_class = false;

	protected function register_controls() {

			  // Notice 
			$this->start_controls_section(
			'notice_content_section',
				[
					'label' => esc_html__( 'Notice', 'shop-ready' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);
	
				$this->add_control(
					'woo_ready_usage_direction_notice',
					[
						'label'           => esc_html__( 'Important Note', 'shop-ready' ),
						'type'            => \Elementor\Controls_Manager::RAW_HTML,
						'raw'             => esc_html__( 'Use This Widget in WooCommerce Product Details page  Template.', 'shop-ready' ),
						'content_classes' => 'woo-ready-product-page-notice',
					]
				);
	
			$this->end_controls_section(); 
			
			$this->start_controls_section(
				'editor_content_section',
				[
					'label' => esc_html__( 'Editor Refresh', 'shop-ready' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

				$this->add_control(
					'show_product_content',
					[
						'label'        => esc_html__( 'Content Refresh?', 'shop-ready' ),
						'type'         => \Elementor\Controls_Manager::SWITCHER,
						'label_on'     => esc_html__( 'Yes', 'shop-ready' ),
						'label_off'    => esc_html__( 'No', 'shop-ready' ),
						'return_value' => 'yes',
						'default'      => '',
					]
				);

				$this->add_control(
					'wready_product_id',
					[
						'label'   => esc_html__( 'Demo Product', 'shop-ready' ),
						'type' => \Elementor\Controls_Manager::SELECT2,
						'multiple' => false,
						'default' => shop_ready_get_single_product_key(),
						'options' =>  shop_ready_get_latest_products_id(30)
					]
				);
 
			$this->end_controls_section();

			$this->start_controls_section(
				'layouts_cart_content_section',
				[
					'label' => esc_html__( 'Layout', 'shop-ready' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);
	
				$this->add_control(
					'style',
					[
						'label'   => esc_html__( 'Layout', 'shop-ready' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'default' => 'wready-price-one',
						'options' => [
							'wready-price-one' => esc_html__('Default','shop-ready'),
							'wready-price-two' => esc_html__('Discount Style','shop-ready'),
							'wready-price-three' => esc_html__('Sale Price Only Style','shop-ready'),
							'wready-price-four' => esc_html__('Price Only','shop-ready'),
							'wready-price-five' => esc_html__('Regular Price Only','shop-ready'),
					
						]
					]
				);
	
	
			$this->end_controls_section();
			$this->start_controls_section(
				'product_discount_content_section',
				[
					'label' => esc_html__( 'Discount', 'shop-ready' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
					'condition' => [
						'style' => ['wready-price-two']
					]
				]
			);

			$this->add_control(
				'price_in_percent',
				[
					'label'        => esc_html__( 'Discount in % ?', 'shop-ready' ),
					'type'         => \Elementor\Controls_Manager::SWITCHER,
					'label_on'     => esc_html__( 'Yes', 'shop-ready' ),
					'label_off'    => esc_html__( 'No', 'shop-ready' ),
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);
				
			$this->add_control(
				'discount_prefix',
				[
					'label'       => esc_html__( 'Discount Prefix', 'shop-ready' ),
					'type'        => Controls_Manager::TEXTAREA,
					'default' => 'Save',
					'placeholder' => esc_html__( 'Save', 'shop-ready' ),
					'separator'   => 'before',
				]
			);

			$this->add_control(
				'discount_suffix',
				[
					'label'       => esc_html__( 'Discount Suffix', 'shop-ready' ),
					'type'        => Controls_Manager::TEXTAREA,
					'default' => '',
					'placeholder' => esc_html__( 'Save', 'shop-ready' ),
					'separator'   => 'before',
				]
			);

			$this->end_controls_section();

		/**
		 * Layouts Total Table
		 */
		$this->box_layout(
			[
				'title'          => esc_html__('Container Wrapper','shop-ready'),
				'slug'           => 'wready_wc_default_product_layout_wrapper',
				'element_name'   => 'cart_product_title_wrapper',
				'selector'       => '{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price',
				
			]
		);

	

		/* Layouts End */

		$this->box_css(
			[
				'title'          => esc_html__('Main Section','shop-ready'),
				'slug'           => 'wready_wc_default_product_price_wrapper',
				'element_name'   => '_product_ptivr_wrapper',
				'selector'       => '{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price .amount',
			]
		);

			
		$this->text_minimum_css(
			[
				'title'          => esc_html__('Price','shop-ready'),
				'slug'           => 'wready_wc_default_product_price_c',
				'element_name'   => '_product_price_',
				'hover_selector' =>  false,
				'selector'       => '{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price bdi',
				'condition' => [
					'style' => ['wready-price-two']
				]
			]
		);

		$this->text_minimum_css(
			[
				'title'          => esc_html__('Percent Price','shop-ready'),
				'slug'           => 'wready_wc_default_product_price_cs',
				'element_name'   => '_product_price_s',
				'hover_selector' =>  false,
				'selector'       => '{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price,{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price .woocommerce-Price-currencySymbol',
				// 'condition' => [
				// 	'style' => ['wready-price-two']
				// ]
				
			]
		);
		$this->text_minimum_css(
			[
				'title'          => esc_html__('Currency','shop-ready'),
				'slug'           => 'wready_wc_default_product_price_currency',
				'element_name'   => '_product_price_curren',
				'hover_selector' =>  false,
				'selector'       => '{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price bdi .woocommerce-Price-currencySymbol,{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price bdi > span',
				
			]
		);

		$this->text_wrapper_css(
			[
				'title'          => esc_html__('Regular Price Wrapper','shop-ready'),
				'slug'           => 'wready_wc_default_product_regular_price_del',
				'element_name'   => '_product_price_reg',
				'hover_selector' =>  false,
				'selector'       => '{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price del,{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price del .woocommerce-Price-currencySymbol',
				'condition' => [
					'style' => ['wready-price-one']
				]
			]
		);

		$this->text_wrapper_css(
			[
				'title'          => esc_html__('Sale Price Wrapper','shop-ready'),
				'slug'           => 'wready_wc__product_regular_price_ins',
				'element_name'   => '_product_price_ins',
				'hover_selector' =>  false,
				'selector'       => '{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price ins,{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price ins',
				'condition' => [
					'style' => ['wready-price-one']
				]
			]
		);

		$this->text_wrapper_css(
			[
				'title'          => esc_html__('Sale Price','shop-ready'),
				'slug'           => 'wready_wc__product_sales_price_ins',
				'element_name'   => '_product_Sales_price_ins',
				'hover_selector' =>  false,
				'selector'       => '{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price ins bdi',
				'condition' => [
					'style' => ['wready-price-one']
				]
			]
		);
		
		$this->text_wrapper_css(
			[
				'title'          => esc_html__('Sale Currency','shop-ready'),
				'slug'           => 'wready_wc__product_sales_cur_ins',
				'element_name'   => '_product_Sales_price_ins',
				'hover_selector' =>  false,
				'selector'       => '{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price ins bdi .woocommerce-Price-currencySymbol,{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price ins bdi > span',
				'condition' => [
					'style' => ['wready-price-one']
				]
			]
		);

		$this->text_wrapper_css(
			[
				'title'          => esc_html__('Suffix / Prefix Text','shop-ready'),
				'slug'           => 'wready_wc_product_sales_suffic_prefox',
				'element_name'   => '_product_Sales_price_sf',
				'hover_selector' =>  false,
				'selector'       => '{{WRAPPER}} .woo-ready-product-price-layout .wready-product-price',
				'condition' => [
					'style' => ['wready-price-two']
				]
			]
		);
		
	
		
	}

    /**
	 * Override By elementor render method
	 * @return void
	 * 
	 */
	protected function html() {

		$settings = $this->get_settings_for_display();
	
	    $this->add_render_attribute(
			'wrapper_style',
			[
				'class' => [ 'woo-ready-product-price-layout', $settings['style'] ],
			]
		);

        echo sprintf("<div %s>",$this->get_render_attribute_string( 'wrapper_style' ));

			if(file_exists(dirname(__FILE__). '/template-parts/price/'.$settings['style'].'.php')){
				shop_ready_widget_template_part(
					'product/template-parts/price/'.$settings['style'].'.php',
					array(
						'settings'  => $settings,
					)
				);

			}else{
                shop_ready_widget_template_part(
					'product/template-parts/price/wready-price-one.php',
					array(
						'settings' => $settings,
					)
				);
			}
			
		echo '</div>';
	}

}