<?php

namespace Shop_Ready\extension\elewidgets\widgets\login_register;

use Shop_Ready\base\elementor\style_controls\common\Widget_Form;
/*
* User Register
*/
class User_Generate extends \Shop_Ready\extension\elewidgets\Widget_Base {

    use Widget_Form;
	public $wrapper_class = true;
 	protected function register_controls() {
		
		   // Notice 
		   $this->start_controls_section(
			'notice_content_section',
				[
					'label' => esc_html__( 'Notice', 'shop-ready' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'woo_ready_usage_direction_notice',
				[
					'label'           => esc_html__( 'Important Note', 'shop-ready' ),
					'type'            => \Elementor\Controls_Manager::RAW_HTML,
					'raw'             => esc_html__( 'Use This Widget in WooCommerce Account Login Register Template.', 'shop-ready' ),
					'content_classes' => 'woo-ready-account-notice',
				]
			);

		$this->end_controls_section();

		$this->start_controls_section(
			'lost_password_section',
			[
				'label' => esc_html__( 'User register', 'shop-ready' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

	

		$this->add_control(
			'woocommerce_registration_generate_username',
			[
				'label'        => esc_html__( 'Username', 'shop-ready' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'shop-ready' ),
				'label_off'    => esc_html__( 'No', 'shop-ready' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);
		
		$this->add_control(
			'woocommerce_registration_generate_password',
			[
				'label'        => esc_html__( 'Password', 'shop-ready' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'shop-ready' ),
				'label_off'    => esc_html__( 'No', 'shop-ready' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'generate_pass_message',
			[
				'label'       => esc_html__( 'Password alert Message', 'shop-ready' ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => esc_html__( 'A password will be sent to your email address', 'shop-ready' ),
				'placeholder' => esc_html__( 'Password reset email has been sent.', 'shop-ready' ),
				'condition' => [
					'woocommerce_registration_generate_password' => ['']
				],
				'label_block' => true
			]
		);

		$this->add_control(
			'button_text',
			[
				'label'       => esc_html__( 'Button Text', 'shop-ready' ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => esc_html__( 'Submit', 'shop-ready' ),
				'placeholder' => esc_html__( 'Register', 'shop-ready' ),
				'label_block' => true
			]
		);

		$this->add_control(
			'button_icon',
			[
				'label' => __( 'Icon', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				
			]
		);

		$this->add_control(
			'icon_align',
			[
				'label' => __( 'Icon Position', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'shop-ready' ),
						'icon' => 'fa fa-angle-left',
					],
				
					'right' => [
						'title' => __( 'Right', 'shop-ready' ),
						'icon' => 'fa fa-angle-right',
					],
				],
				'default' => 'right',
				'toggle' => true,
			]
		);


	
	   
		$this->end_controls_section();

		$this->start_controls_section(
			'input_fld_content_section',
			[
				'label' => __( 'input / label', 'shop-ready' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'show_label',
				[
					'label' => esc_html__( 'Show Label', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'shop-ready' ),
					'label_off' => esc_html__( 'No', 'shop-ready' ),
					'return_value' => 'yes',
					'default' => 'yes',
					'label_block' => true
				]
			);

			$this->add_control(
				'username_label',
				[
					'label' => esc_html__( 'Username Label', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Username ', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your username label here', 'shop-ready' ),
					'condition' => [
						'show_label' => ['yes']	
					],
					'label_block' => true
				]
			);

			$this->add_control(
				'email_label',
				[
					'label' => esc_html__( 'Email Label', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Email address', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your email label here', 'shop-ready' ),
					'condition' => [
						'show_label' => ['yes']	
					],
					'label_block' => true
				]
			);

			$this->add_control(
				'password_label',
				[
					'label' => esc_html__( 'Password Label', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Password', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your password label here', 'shop-ready' ),
					'condition' => [
						'show_label' => ['yes']	
					],
					'label_block' => true
				]
			);

			// placeholder
			$this->add_control(
				'username_placeholder',
				[
					'label' => esc_html__( 'Username Placeholder', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Username', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your username  here', 'shop-ready' ),
					'label_block' => true
				]
			);

			$this->add_control(
				'email_placeholder',
				[
					'label' => esc_html__( 'Email Placeholder', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Email address', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your email  here', 'shop-ready' ),
					'label_block' => true
				]
			);

			$this->add_control(
				'password_placeholder',
				[
					'label' => esc_html__( 'Password Placeholder', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Password', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your password here', 'shop-ready' ),
					'label_block' => true
				]
			);

			
		
		$this->end_controls_section();

	
	

		$this->input_field(
			[ 
			
			'title'          => esc_html__('Username Input','shop-ready'),
			'slug'           => 'username_input_box_styles',
			'element_name'   => 'usermabtn_linput_woo_ready__',
			'selector'       => '{{WRAPPER}} .woo-ready-register-username input',
			'hover_selector' => '{{WRAPPER}} .woo-ready-register-username input:hover',
			'condition' => [
				'woocommerce_registration_generate_username' => ['yes']
			]
			]
		);

		$this->input_field(
			[ 
			
			'title'          => esc_html__('Email Input','shop-ready'),
			'slug'           => 'email_input_box_styles',
			'element_name'   => 'pemail_linput_woo_ready__',
			'selector'       => '{{WRAPPER}} .woo-ready-register-email input',
			'hover_selector' => '{{WRAPPER}} .woo-ready-register-email input:hover'

			]
		);

		$this->input_field(
			[ 
			
			'title'          => esc_html__('Password Input','shop-ready'),
			'slug'           => 'password_input_box_styles',
			'element_name'   => 'password_linput_woo_ready__',
			'selector'       => '{{WRAPPER}} .woo-ready-register-password input',
			'hover_selector' => '{{WRAPPER}} .woo-ready-register-password input:hover',
			'condition' => [
				'woocommerce_registration_generate_password' => ['yes']
			]

			]
		);

		$this->text_css(
			[ 
			
			'title'        => esc_html__('Password info text','shop-ready'),
			'slug'         => 'privacy_on_box_style',
			'element_name' => 'privacy_icon_woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-when-password-auto',
			'hover_selector' => false,
			'condition' => [
				'woocommerce_registration_generate_password' => ['']
			]

			]
		);

		$this->text_css(
			[ 
			
			'title'        => esc_html__('Username Label','shop-ready'),
			'slug'         => 'usermname_lbl_box_style',
			'element_name' => 'uname_lbl_woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-register-username label',
			'hover_selector' => false,
			'condition' => [
				'woocommerce_registration_generate_username' => ['yes']
			]

			]
		);

		$this->text_css(
			[ 
			
			'title'        => esc_html__('Email Label','shop-ready'),
			'slug'         => 'email_lbl_style',
			'element_name' => 'email_lbl_woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-register-email label',
			'hover_selector' => false

			]
		);

		
		$this->text_css(
			[ 
			
			'title'        => esc_html__('Password Label','shop-ready'),
			'slug'         => 'pass_lbl_box_style',
			'element_name' => 'pass_lblwoo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-register-password label',
			'hover_selector' => false,
			'condition' => [
				'woocommerce_registration_generate_password' => ['yes']
			]

			]
		);

		$this->text_css(
			[ 
			
			'title'        => esc_html__('Button','shop-ready'),
			'slug'         => 'btn_i_box_style',
			'element_name' => 'btmn_i_woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-register-btn-wrp button',
			'hover_selector' =>'{{WRAPPER}} .woo-ready-register-btn-wrp button:hover',

			]
		);

		$this->text_minimum_css(
			[ 
			
			'title'        => esc_html__('Icon','shop-ready'),
			'slug'         => 'btn_icon_box_style',
			'element_name' => 'name_icon_woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-register-btn-wrp button i',
		

			]
		);


        // // Wrapper
    	$this->box_css(
			[ 
			
			'title'        => esc_html__('Username Wrapper','shop-ready'),
			'slug'         => 'usr_box_style',
			'element_name' => 'name__woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-register-username',
			'hover_selector' => false,
			'condition' => [
				'woocommerce_registration_generate_username' => ['yes']
			]
			]
		);

		$this->box_css(
			[ 
			
			'title'        => esc_html__('Email Wrapper','shop-ready'),
			'slug'         => 'email_box_style',
			'element_name' => 'email__woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-register-email',
			'hover_selector' => false
			]
		);
  
		$this->box_css(
			[ 
			
			'title'        => esc_html__('Password Wrapper','shop-ready'),
			'slug'         => 'password_box_style',
			'element_name' => 'password__woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-register-password',
			'condition' => [
				'woocommerce_registration_generate_password' => ['yes']	
			],
			'hover_selector' => false
			]
		);

		$this->box_css(
			[ 
			
			'title'        => esc_html__('Button Wrapper','shop-ready'),
			'slug'         => 'button_wrapper_style',
			'element_name' => 'buton__wrapper_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-form-register .woo-ready-register-btn-wrp',
			'hover_selector' => false
			]
		);

		$this->box_css(
				[ 
				
				'title'        => esc_html__('Section Area','shop-ready'),
                'slug'         => 'mainregister_box_style',
                'element_name' => 'box_main_woo_ready__',
                'selector'     => '{{WRAPPER}} .woo-ready-form-register',
				'hover_selector' => false
                ]
		);
	

	}

	protected function html() {

		$settings = $this->get_settings_for_display();
	
		include('style/register/style1.php');
		

	}

}