<?php

namespace Shop_Ready\extension\elewidgets\widgets\login_register;

use Shop_Ready\base\elementor\style_controls\common\Widget_Form;

class Lost_Pass_Error extends \Shop_Ready\extension\elewidgets\Widget_Base {

    use Widget_Form;
	public $wrapper_class = true;

	protected function register_controls() {

		$this->start_controls_section(
			'lost_password_section',
			[
				'label' => esc_html__( 'Error Message', 'shop-ready' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'show_messege_in_editor',
			[
				'label'        => esc_html__( 'Show message in editor', 'shop-ready' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'shop-ready' ),
				'label_off'    => esc_html__( 'No', 'shop-ready' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

	    $this->add_control(
			'enable_template_message',
			[
				'label'        => esc_html__( 'Template Message', 'shop-ready' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', 'shop-ready' ),
				'label_off'    => esc_html__( 'No', 'shop-ready' ),
				'return_value' => 'yes',
				'default'      => '',
			]
		);

		$this->add_control(
			'template_id',
			[
				'label'     => esc_html__( 'Template ', 'shop-ready' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '',
				'options'   => shop_ready_get_elementor_templates_arr(),
				'condition' => [
					'enable_template_message' => 'yes'
				]
			]
		);

		$this->end_controls_section();
	


			$this->text_css(
				[ 
					
					'title'        => esc_html__('Error Notice','shop-ready'),
					'slug'         => 'notice_suc_box_style',
					'element_name' => 'notice_suc_ready__',
					'selector'     => '{{WRAPPER}} .woocommerce-error',
				
				]
			);
	

	}


	protected function html() {

		$settings = $this->get_settings_for_display();
	  
		include('style/lost_pass/error.php');
		

	}

}