<?php

namespace Shop_Ready\extension\elewidgets\widgets\login_register;

use Shop_Ready\base\elementor\style_controls\common\Widget_Form;

class Lost_Pass extends \Shop_Ready\extension\elewidgets\Widget_Base {

    use Widget_Form;
	public $wrapper_class = true;
	protected function register_controls() {

		$this->start_controls_section(
			'layout_content_section',
			[
				'label' => __( 'Layout', 'shop-ready' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'preset',
			[
				'label' => __( 'Preset', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'woo-ready-lost-pass-preset-1',
				'options' => [
					'woo-ready-lost-pass-preset-1'  => __( 'Preset 1', 'shop-ready' ),
					
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'lost_password_section',
			[
				'label' => esc_html__( 'Lost Password', 'shop-ready' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'lost_password_title',
			[
				'label'       => esc_html__( 'Label', 'shop-ready' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'Lost Password ?', 'shop-ready' ),
				'placeholder' => esc_html__( 'Type your lost password label here', 'shop-ready' ),
			]
		);

		$this->add_control(
			'button_icon',
			[
				'label' => __( 'Icon', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				
			]
		);

		$this->add_control(
			'icon_align',
			[
				'label' => __( 'Icon Position', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'shop-ready' ),
						'icon' => 'fa fa-angle-left',
					],
				
					'right' => [
						'title' => __( 'Right', 'shop-ready' ),
						'icon' => 'fa fa-angle-right',
					],
				],
				'default' => 'right',
				'toggle' => true,
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'lost_password_form',
			[
				'label' => esc_html__( 'Form', 'shop-ready' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'show_form_in_editor',
				[
					'label' => __( 'Show form in editor', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => __( 'Show', 'shop-ready' ),
					'label_off' => __( 'Hide', 'shop-ready' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			
			$this->add_control(
				'lost_password_input_label',
				[
					'label'       => esc_html__( 'Username Field', 'shop-ready' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => esc_html__( 'Username or Email', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your username label here', 'shop-ready' ),
				]
			);

			$this->add_control(
				'lost_password_btn_label',
				[
					'label'       => esc_html__( 'Button Label', 'shop-ready' ),
					'type'        => \Elementor\Controls_Manager::TEXTAREA,
					'default'     => esc_html__( 'Reset Password', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your button text here', 'shop-ready' ),
				]
			);

			$this->add_control(
				'lost_password_form_msg',
				[
					'label'       => esc_html__( 'Heading Content', 'shop-ready' ),
					'type'        => \Elementor\Controls_Manager::TEXTAREA,
					'default'     => esc_html__( 'Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your Heading content here', 'shop-ready' ),
				]
			);

		$this->end_controls_section();


  
				
		   $this->text_wrapper_css(
				[
					'title'        => esc_html__('Password Link','shop-ready'),
					'slug'         => 'woo_ready_lpassl',
					'element_name' => 's__woo_ready__',
					'selector'     => '{{WRAPPER}} .woo-ready-LostPassword .woo-ready-lpass-link'
                ]
			);

			$this->text_minimum_css(
				[ 
				
				'title'        => esc_html__('Icon','shop-ready'),
				'slug'         => 'btn_icon_box_style',
				'element_name' => 'name_icon_woo_ready__',
				'selector'     => '{{WRAPPER}} .woo-ready-LostPassword i',
			   
				'hover_selector'     => '{{WRAPPER}} .woo-ready-LostPassword:hover i',
				]
			);
				
	
			$this->box_css(

				[ 
					'title'        => esc_html__('Box Wrapper','shop-ready'),
					'slug'         => 'woo_ready_lpass_style',
					'element_name' => 's__woo_ready__',
					'selector'     => '{{WRAPPER}} .woo-ready-LostPassword'
                ]

			);

			// form

			$this->text_css(
				[ 
				
					'title'        => esc_html__('Form Heading','shop-ready'),
					'slug'         => 'hading_box_style',
					'element_name' => 'heaidng_woo_ready__',
					'selector'     => '{{WRAPPER}} .woo-ready-lpass-heading',
					'hover_selector' => false,
					'condition' => [
						'show_form_in_editor' => ['yes']	
					]
	
				]
			);

			$this->box_css(
				[ 
				
					'title'        => esc_html__('Label Wrapper','shop-ready'),
					'slug'         => 'input_label_style',
					'element_name' => 'input__woo_ready__',
					'selector'     => '{{WRAPPER}} .woo-ready-form-label',
					'condition' => [
						'show_form_in_editor' => ['yes']	
					]
	
				]
			);
			$this->text_minimum_css(
				[ 
				
					'title'        => esc_html__('Label','shop-ready'),
					'slug'         => 'inputs_label_style',
					'element_name' => 'input_s_woo_ready__',
					'selector'     => '{{WRAPPER}} .woo-ready-form-label label',
					'hover_selector' => false,
					'condition' => [
						'show_form_in_editor' => ['yes']	
					]
	
				]
			);

			$this->box_css(
				[ 
				
					'title'        => esc_html__('Input Wrapper','shop-ready'),
					'slug'         => 'input_fld_box_style',
					'element_name' => 'input_fld_woo_ready__',
					'selector'     => '{{WRAPPER}} .woo-ready-form-username',
					'condition' => [
						'show_form_in_editor' => ['yes']	
					]
	
				]
			);

			$this->input_field(
				[ 
				
				'title'          => esc_html__('Input','shop-ready'),
				'slug'           => 'user_input_box_styles',
				'element_name'   => 'uname_linput_woo_ready__',
				'selector'       => '{{WRAPPER}} .woo-ready-form-username input',
				'hover_selector' => '{{WRAPPER}} .woo-ready-form-username input:focus',
				'condition' => [
					'show_form_in_editor' => ['yes']	
				]
	
				]
			);

			$this->box_css(
				[ 
				
				'title'          => esc_html__('Button Wrapper','shop-ready'),
				'slug'           => 'btn_input_box_styles',
				'element_name'   => 'btn_linput_woo_ready__',
				'selector'       => '{{WRAPPER}} .woo-ready-form-btn',
				'hover_selector' => false,
				'condition' => [
					'show_form_in_editor' => ['yes']	
				]
	
				]
			);

			
			$this->text_wrapper_css(
				[ 
				
					'title'          => esc_html__( 'Button' , 'shop-ready' ),
					'slug'           => 'buttons_label_box_style',
					'element_name'   => 'buttons_label_woo_ready__',
					'selector'       => '{{WRAPPER}} .woo-ready-form-btn button',
					'hover_selector' => '{{WRAPPER}} .woo-ready-form-btn button:hover',
					'condition' => [
						'show_form_in_editor' => ['yes']	
					]
				
				]
			);
	
			$this->box_css(
				[ 
					
					'title'        => esc_html__('Form Area','shop-ready'),
					'slug'         => 'fmain_box_style',
					'element_name' => 'form_woo_ready__',
					'selector'     => '{{WRAPPER}} .woo-ready-lost-reset-password',
					'condition' => [
						'show_form_in_editor' => ['yes']	
					]
				]
			);

			$this->text_css(
				[ 
					
					'title'        => esc_html__('Error Notice','shop-ready'),
					'slug'         => 'notice_wr_box_style',
					'element_name' => 'notice_woo_ready__',
					'selector'     => '{{WRAPPER}} ul.woocommerce-error',
					
				]
			);

			$this->text_css(
				[ 
					
					'title'        => esc_html__('Success Notice','shop-ready'),
					'slug'         => 'notice_suc_box_style',
					'element_name' => 'notice_suc_ready__',
					'selector'     => '{{WRAPPER}} .woocommerce-message',
					
				]
			);
	

	}


	protected function html() {

		$settings = $this->get_settings_for_display();
	
		include('style/lost_pass/style1.php');

	}

}