<?php
namespace Shop_Ready\extension\elewidgets\widgets\login_register;

use Shop_Ready\base\elementor\style_controls\common\Widget_Form;

class Login extends \Shop_Ready\extension\elewidgets\Widget_Base {

    use Widget_Form;
	public $wrapper_class = true;


	protected function register_controls() {

		$this->start_controls_section(
			'layout_content_section',
			[
				'label' => __( 'Layout', 'shop-ready' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'preset',
			[
				'label' => __( 'Preset', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'woo-ready-login-form-preset-1',
				'options' => [
					'woo-ready-login-form-preset-1'  => __( 'Preset 1', 'shop-ready' ),
					'woo-ready-login-form-preset-2' => __( 'Preset 2', 'shop-ready' ),
				],
			]
		);

		$this->end_controls_section();
		

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'input / label', 'shop-ready' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'show_label',
				[
					'label'        => esc_html__( 'Show Label', 'shop-ready' ),
					'type'         => \Elementor\Controls_Manager::SWITCHER,
					'label_on'     => esc_html__( 'Yes', 'shop-ready' ),
					'label_off'    => esc_html__( 'No', 'shop-ready' ),
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);

			$this->add_control(
				'username_label',
				[
					'label'       => esc_html__( 'Username Label', 'shop-ready' ),
					'type'        => \Elementor\Controls_Manager::TEXT,
					'default'     => esc_html__( 'Username or email address', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your username label here', 'shop-ready' ),
					'condition'   => [
						'show_label' => ['yes']
					]
				]
			);

			$this->add_control(
				'password_label',
				[
					'label' => esc_html__( 'Password Label', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Username or email address', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your username label here', 'shop-ready' ),
					'condition' => [
						'show_label' => ['yes']	
					]
				]
			);

			// placeholder
			$this->add_control(
				'username_placeholder',
				[
					'label' => esc_html__( 'Username Placeholder', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Username or email address', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your username label here', 'shop-ready' ),
					
				]
			);

			$this->add_control(
				'password_placeholder',
				[
					'label' => esc_html__( 'Password Placeholder', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Username or email address', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your username label here', 'shop-ready' ),
					
				]
			);

			
		
		$this->end_controls_section();


		
		$this->start_controls_section(
			'_remember_content_section',
			[
				'label' => esc_html__( 'Remember Option', 'shop-ready' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'show_remember_checkbox',
				[
					'label' => esc_html__( 'Show Remember', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => esc_html__( 'Yes', 'shop-ready' ),
					'label_off' => esc_html__( 'No', 'shop-ready' ),
					'return_value' => 'yes',
					'default' => 'yes',
				]
			);

			$this->add_control(
				'remember_text',
				[
					'label' => esc_html__( 'Remember Text', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Remember Me', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your remember title here', 'shop-ready' ),
					'condition' => [
						'show_remember_checkbox' => ['yes']	
					]
					
				]
			);

		$this->end_controls_section();

			
		$this->start_controls_section(
			'_submit_btn_section',
			[
				'label' => esc_html__( 'Button', 'shop-ready' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'button_text',
				[
					'label' => esc_html__( 'Button text', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Submit', 'shop-ready' ),
					'placeholder' => esc_html__( 'Type your button label here', 'shop-ready' ),
					
				]
			);
			
			$this->add_control(
				'button_icon',
				[
					'label' => __( 'Icon', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::ICONS,
					
				]
			);

			$this->add_control(
				'icon_align',
				[
					'label' => __( 'Icon Position', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'left' => [
							'title' => __( 'Left', 'shop-ready' ),
							'icon' => 'fa fa-angle-left',
						],
					
						'right' => [
							'title' => __( 'Right', 'shop-ready' ),
							'icon' => 'fa fa-angle-right',
						],
					],
					'default' => 'right',
					'toggle' => true,
				]
			);

		

		$this->end_controls_section();

        

        // text_css
	
		
		$this->text_wrapper_css(
			[ 
			
			'title'        => esc_html__('Username Label','shop-ready'),
			'slug'         => 'usr_label_box_style',
			'element_name' => 'name_label_woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-account-form .woo-ready-username-wrapper label',
			'hover_selector'     => '{{WRAPPER}} .woo-ready-account-form .woo-ready-username-wrapper:hover label',
			'condition' => [
				'show_label' => ['yes']	
			]
			]
		);

		$this->input_field(
			[ 
			
			'title'        => esc_html__('Username input','shop-ready'),
			'slug'         => 'usr_input_box_styles',
			'element_name' => 'uname_linput_woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-account-form .woo-ready-username-wrapper input',
			'hover_selector'     => '{{WRAPPER}} .woo-ready-account-form .woo-ready-username-wrapper input:focus'

			]
		);

		// pass

		$this->text_wrapper_css(
			[ 
			
			'title'          => esc_html__('Password Label','shop-ready'),
			'slug'           => 'pass_label_box_style',
			'element_name'   => 'pass_label_woo_ready__',
			'selector'       => '{{WRAPPER}} .woo-ready-account-form .woo-ready-password-wrapper label',
			'hover_selector' => '{{WRAPPER}} .woo-ready-account-form .woo-ready-password-wrapper:hover label',
			'condition' => [
				'show_label' => ['yes']	
			]
			]
		);

		$this->input_field(
			[ 
			
			'title'          => esc_html__('Password input','shop-ready'),
			'slug'           => 'pass_input_box_styles',
			'element_name'   => 'pass_linput_woo_ready__',
			'selector'       => '{{WRAPPER}} .woo-ready-account-form .woo-ready-password-wrapper input',
			'hover_selector' => '{{WRAPPER}} .woo-ready-account-form .woo-ready-password-wrapper input:focus'

			]
		);

		
		$this->text_wrapper_css(
			[ 
			
			'title'          => esc_html__('Remember Label','shop-ready'),
			'slug'           => 'checkbox_label_box_style',
			'element_name'   => 'checkbox_label_woo_ready__',
			'selector'       => '{{WRAPPER}} .woo-ready-account-form .woo-ready-form-checkbox span',
			'hover_selector' => false,
			'condition' => [
				'show_remember_checkbox' => ['yes']	
			]
			]
		);
		
		$this->checkbox_field(
			[ 
			
			'title'          => esc_html__('Remember checkbox','shop-ready'),
			'slug'           => 'checkbox_input_box_styles',
			'element_name'   => 'checkbox_linput_woo_ready__',
			'selector'       => '{{WRAPPER}} .woo-ready-account-form .woo-ready-form-checkbox input',
			'hover_selector' => '{{WRAPPER}} .woo-ready-account-form .woo-ready-form-checkbox input:after',
			'condition' => [
				'show_remember_checkbox' => ['yes']	
			]
			]
		);

		$this->text_css(
			[ 
			
			'title'          => esc_html__('Button','shop-ready'),
			'slug'           => 'btn_input_box_styles',
			'element_name'   => 'btn_linput_woo_ready__',
			'selector'       => '{{WRAPPER}} .woo-ready-account-form .woo-ready-btn-wrapper button',
			'hover_selector' => '{{WRAPPER}} .woo-ready-account-form .woo-ready-btn-wrapper button:hover'

			]
		);

		$this->text_minimum_css(
			[ 
			
			'title'        => esc_html__('Icon','shop-ready'),
			'slug'         => 'btn_icon_box_style',
			'element_name' => 'name_icon_woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-account-form .woo-ready-btn-wrapper button i',
		

			]
		);

        // Wrapper
    	$this->box_css(
			[ 
			
			'title'        => esc_html__('Username Wrapper','shop-ready'),
			'slug'         => 'usr_box_style',
			'element_name' => 'name__woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-account-form .woo-ready-username-wrapper'

			]
		);

		$this->box_css(
			[ 
			
			'title'        => esc_html__('Password Wrapper','shop-ready'),
			'slug'         => 'pass_box_style',
			'element_name' => 'pass__woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-account-form .woo-ready-password-wrapper'

			]
		);
  
		$this->box_css(
			[ 
			
			'title'        => esc_html__('Checkbox Wrapper','shop-ready'),
			'slug'         => 'check_box_style',
			'element_name' => 'checkbox__woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-account-form .woo-ready-checkbox-wrapper',
			'condition' => [
				'show_remember_checkbox' => ['yes']	
			]
			]
		);

		$this->box_css(
			[ 
			
			'title'        => esc_html__('Button Wrapper','shop-ready'),
			'slug'         => 'button_box_style',
			'element_name' => 'buton__woo_ready__',
			'selector'     => '{{WRAPPER}} .woo-ready-account-form .woo-ready-btn-wrapper'

			]
		);

		$this->box_css(
				[ 
				
				'title'        => esc_html__('Section Area','shop-ready'),
                'slug'         => 'main_box_style',
                'element_name' => 'box__woo_ready__',
                'selector'     => '{{WRAPPER}} .woo-ready-account-form'

                ]
		);


	}


	protected function html() {

		$settings = $this->get_settings_for_display();
	
		include('style/login/style1.php');
		

	}

}