<?php 
use \Elementor\Icons_Manager;

/**
 * Vertical Menu
 * Footer
 * @since 1.0
 */

    $menu_list = $settings['list'];
 
?>

    <ul class="woo-ready-footer-vertical-menu">
        <?php foreach( $menu_list as $item ):  ?>
        <li class="woo-ready-menu-item position:relative elementor-repeater-item-<?php echo esc_attr($item['_id']); ?> ">
            <?php if($item['icon_position'] == 'yes'): ?>
                <?php is_null( $item['menu_icon'] ) ? '' : Icons_Manager::render_icon( $item['menu_icon'], [ 'class' => 'menu-icon' ] ); ?>
            <?php endif; ?>
            <a href="<?php echo esc_url($item['website_link']['url']); ?>">
                <span class="wready-menu-title"> <?php echo esc_html($item['list_title']); ?> </span>
             </a>
             <?php if($item['icon_position'] == ''): ?>
                <?php  is_null( $item['menu_icon'] ) ? '' : Icons_Manager::render_icon( $item['menu_icon'], [ 'class' => 'menu-icon' ] ); ?>
            <?php endif; ?>
            <?php echo sprintf("<span class='bedge'> %s </span>", $item['menu_bedge']) ?>
        </li>
        <?php endforeach; ?>
    </ul>