<?php

namespace Shop_Ready\extension\elewidgets\widgets\general;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Image_Size;
use Elementor\Modules\DynamicTags\Module as TagsModule;
use Elementor\Utils;
/**
 * WooCommerce Breadcrumb
 * @see https://docs.woocommerce.com/document/woocommerce_breadcrumb/
 * @author quomodosoft.com
 */
class Breadcrumb extends \Shop_Ready\extension\elewidgets\Widget_Base {
    
	
    /**
	 * Html Wrapper Class of html 
	 */
	public $wrapper_class = true;

	protected function register_controls() {

			  // Notice 
			$this->start_controls_section(
			'notice_content_section',
				[
					'label' => esc_html__( 'Notice', 'shop-ready' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);
	
				$this->add_control(
					'woo_ready_usage_direction_notice',
					[
						'label'           => esc_html__( 'Important Note', 'shop-ready' ),
						'type'            => \Elementor\Controls_Manager::RAW_HTML,
						'raw'             => esc_html__( 'Use This Widget in WooCommerce page Template.', 'shop-ready' ),
						'content_classes' => 'woo-ready-product-page-notice',
					]
				);
	
			$this->end_controls_section(); 
			
			$this->start_controls_section(
				'editor_content_section',
				[
					'label' => esc_html__( 'Editor Refresh', 'shop-ready' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

				$this->add_control(
					'show_breadcrumb_content',
					[
						'label'        => esc_html__( 'Content Refresh?', 'shop-ready' ),
						'type'         => \Elementor\Controls_Manager::SWITCHER,
						'label_on'     => esc_html__( 'Yes', 'shop-ready' ),
						'label_off'    => esc_html__( 'No', 'shop-ready' ),
						'return_value' => 'yes',
						'default'      => '',
					]
				);

			$this->end_controls_section();

			$this->start_controls_section(
				'layouts_product_data_tabs_section',
				[
					'label' => esc_html__( 'Layout', 'shop-ready' ),
					'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);
	
				$this->add_control(
					'style',
					[
						'label'   => esc_html__( 'Layout', 'shop-ready' ),
						'type' => \Elementor\Controls_Manager::SELECT,
						'default' => '',
						'options' => [
							'default'     => esc_html__('Default','shop-ready'),
							//'wready-rating-two'   => esc_html__('Style 2','shop-ready'),
					
						]
					]
				);
	
	
			$this->end_controls_section();

		
		$this->start_controls_section(
			'content_rating_section',
			[
				'label' => esc_html__( 'Settings', 'shop-ready' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'delemeter',
			[
				'label' => __( 'Delimeter', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => ' -> ',
				'separator' => 'none',
				'description' => 'https://dev.w3.org/html5/html-author/charref <br/> https://www.toptal.com/designers/htmlarrows/symbols/'
				
			]
		);

		$this->add_control(
			'home',
			[
				'label'        => __( 'Home ?', 'shop-ready' ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'shop-ready' ),
				'label_off'    => __( 'Hide', 'shop-ready' ),
				'return_value' => 'yes',
				'default'      => 'yes',
				
			]
		);

		$this->add_control(
			'home_label',
			[
				'label' => __( 'Home Text', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => 'Home',
				'separator' => 'none',
				'condition' => [
					'home' => ['yes']
				]
			]
		);

		
		$this->end_controls_section();

	
		/**
		 * Layouts
		 */

		$this->box_layout(
			[
				'title'          => esc_html__('Container Wrapper','shop-ready'),
				'slug'           => 'wready_wc_breadcrumb',
				'element_name'   => '__wrapper_breadcrumb',
				'selector'       => '{{WRAPPER}} .woo-ready-wc-breadcrumb-layout > *',
				
			]
		);
	
		/* Layouts End */

		$this->text_wrapper_css(
			[
				'title'          => esc_html__('Link','shop-ready'),
				'slug'           => 'wready_wc_breadcrumb_link',
				'element_name'   => 'wrating_product_breadcrumb_link',
				'selector'       => '{{WRAPPER}} .woo-ready-wc-breadcrumb-layout a',
				'hover_selector' => '{{WRAPPER}} .woo-ready-wc-breadcrumb-layout a:hover',
				
			]
		);

		$this->text_minimum_css(
			[
				'title'          => esc_html__('Text','shop-ready'),
				'slug'           => 'wready_wc_breadcrumb_thustext',
				'element_name'   => 'wrating_product_breadcrumb_text',
				'selector'       => '{{WRAPPER}} .woo-ready-wc-breadcrumb-layout > *',
				'hover_selector' => false
				
			]
		);
		


	
	}

	/**
	 * Override By elementor render method
	 * @return void
	 * 
	 */
	protected function html() {

		$settings = $this->get_settings_for_display();

		$args = array(
			'delimiter'  => $settings['delemeter'],
			'home'    => $settings['home'] ? $settings['home_label'] : null,
		);

	    $this->add_render_attribute(
			'wrapper_style',
			[
				'class' => [ 'woo-ready-wc-breadcrumb-layout', $settings['style'] ],
			]
		);

        echo sprintf("<div %s>",$this->get_render_attribute_string( 'wrapper_style' ));

        	woocommerce_breadcrumb($args);
			
		echo '</div>';
	}

}