<?php

namespace Shop_Ready\extension\elewidgets\widgets\checkout;
use Shop_Ready\base\elementor\style_controls\common\Widget_Form;
/**
 * WooCommerce Coupon Form
 * @author quomodosoft.com
 * @see woocommerce.com
 */
class Coupon extends \Shop_Ready\extension\elewidgets\Widget_Base {

	use Widget_Form;
	public $wrapper_class = true;
	protected function register_controls() {

		  // Notice 
		  $this->start_controls_section(
			'notice_content_section',
			[
				'label' => esc_html__( 'Notice', 'shop-ready' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

			$this->add_control(
				'woo_ready_usage_direction_notice',
				[
					'label' => esc_html__( 'Important Note', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::RAW_HTML,
					'raw' => esc_html__( 'Use This Widget in WooCommerce CheckOut And Cart Template.', 'shop-ready' ),
					'content_classes' => 'woo-ready-account-notice',
				]
			);

		$this->end_controls_section(); 

		$this->start_controls_section(
			'editor_content_section',
			[
				'label' => esc_html__( 'Editor Only', 'shop-ready' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

				$this->add_control(
					'show_checkout_content',
					[
						'label'        => esc_html__( 'Refresh?', 'shop-ready' ),
						'type'         => \Elementor\Controls_Manager::SWITCHER,
						'label_on'     => esc_html__( 'Yes', 'shop-ready' ),
						'label_off'    => esc_html__( 'No', 'shop-ready' ),
						'return_value' => 'yes',
						'default'      => '',
					]
				);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Content Settings', 'shop-ready' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		
			$this->add_control(
				'wready_coupon_collapsible',
				[
					'label'        => __( 'Collapsible?', 'shop-ready' ),
					'type'         => \Elementor\Controls_Manager::SWITCHER,
					'label_on'     => __( 'Yes', 'shop-ready' ),
					'label_off'    => __( 'No', 'shop-ready' ),
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);

			$this->add_control(
				'show_coupon_heading',
				[
					'label'        => __( 'Coupon Heading?', 'shop-ready' ),
					'type'         => \Elementor\Controls_Manager::SWITCHER,
					'label_on'     => __( 'Show', 'shop-ready' ),
					'label_off'    => __( 'Hide', 'shop-ready' ),
					'return_value' => 'yes',
					'default'      => '',
				]
			);

			$this->add_control(
				'coupon_heading_text',
				[
					'label' => __( 'Coupon Heading', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::TEXTAREA,
					'default' => esc_html__('If you have a coupon code, please apply it below.','shop-ready'),
					'condition' => [
						'show_coupon_heading' => ['yes']
					] 
				]
			);

		
	
			$this->add_control(
				'coupon_heading_colapse_msg_text',
				[
					'label' => __( 'Coupon Collapse Message', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::TEXTAREA,
					'default' => esc_html__('Have a coupon?','shop-ready'),
					 'condition' => [
						 'wready_coupon_collapsible' => ['yes']
					 ]  
				]
			);
			
			$this->add_control(
				'coupon_heading_colapse_text',
				[
					'label' => __( 'Coupon Collapse Text', 'shop-ready' ),
					'type' => \Elementor\Controls_Manager::TEXTAREA,
					'default' => esc_html__('Click here to enter your code','shop-ready'),
					'condition' => [
						'wready_coupon_collapsible' => ['yes']
					] 
				]
			);
			
		
	

		$this->end_controls_section();

  
		$this->box_css(
			[
			'title'        => esc_html__('Coupon Toggle Container','shop-ready'),
			'slug'         => 'wready_coupon_toggle_container',
			'element_name' => '__wrteady_toggle_',
			'selector'     => '{{WRAPPER}} .woocommerce-form-coupon-toggle .woocommerce-info',
			'condition' => [
				'wready_coupon_collapsible'=> ['yes']
			]
			]
		);

		$this->text_wrapper_css(
			[ 
				'title'  => esc_html__('Message Content','shop-ready'),
				'slug'         => 'wready_ne_box_span_style',
				'element_name' => 'span__wr_content_span',
				'selector'     => '{{WRAPPER}} .woocommerce-form-coupon-toggle span',
				'condition' => [
					'wready_coupon_collapsible'=> ['yes']
				]
			]
		);

		$this->text_wrapper_css(
			[ 
				'title'  => esc_html__('Toggle Content','shop-ready'),
				'slug'         => 'wready_ne_toggle_content_style',
				'element_name' => 'toggle__wr_content_anchor',
				'selector'     => '{{WRAPPER}} .woocommerce-form-coupon-toggle a',
				'condition' => [
					'wready_coupon_collapsible'=> ['yes']
				]
			]
		);

		$this->text_minimum_css(
			[ 
			'title'        => esc_html__('Coupon Heading','shop-ready'),
			'slug'         => 'coupon_form_c_heading_style_',
			'element_name' => 's_wready_coupon_heading_',
			'selector'     => '{{WRAPPER}} .wready-coupon-row-wrapper .wready-coupon-heading-col' ,
			'condition' => [
				'show_coupon_heading' => ['yes']
			] 
			]
		);

		$this->input_field(
			[
				'title'          => esc_html__('Coupon Input','shop-ready'),
				'slug'           => 'wready_wc_default_coupon_input',
				'element_name'   => 'cart_shortcode_table_copupon_input',
				'selector'       => '{{WRAPPER}} .wready-coupon-row-wrapper [name="coupon_code"]',
				'hover_selector' => '{{WRAPPER}} .wready-coupon-row-wrapper [name="coupon_code"]:focus'
			]
		);

		$this->input_field(
			[
				'title'          => esc_html__('Coupon Code','shop-ready'),
				'slug'           => 'wready_wc_defaults_coupon_input',
				'element_name'   => 'cart_shortcode_table_copupon_input',
				'selector'       => '{{WRAPPER}} .wready-coupon-row-wrapper [name="coupon_code"]',
				'hover_selector' => '{{WRAPPER}} .wready-coupon-row-wrapper [name="coupon_code"]:focus'
			]
		);
  
		$this->text_wrapper_css(
			[ 
				'title'  => esc_html__('Coupon Button','shop-ready'),
				'slug'         => 'wready_ntte_coupon_button_style',
				'element_name' => 'coupon__wr_buttons_anchor',
				'selector'     => '{{WRAPPER}} .wready-coup-btn-col [name="apply_coupon"]',
				'hover_selector' => '{{WRAPPER}} .wready-coup-btn-col [name="apply_coupon"]:hover'
			]
		);

		/** Layouts */ 	

	   $this->box_layout(
			[ 
			'title'        => esc_html__('Coupon Form Container','shop-ready'),
			'slug'         => 'coupon_form_container_box_style',
			'element_name' => 's_wready_coupon_form',
			'selector'     => '{{WRAPPER}} .wready-coupon-row-wrapper'
			]
		);

		$this->box_layout_child(
			[ 
			'title'        => esc_html__('Coupon Input','shop-ready'),
			'slug'         => 'coupon_form_container_input_style',
			'element_name' => 's_wready_coupon_input',
			'selector'     => '{{WRAPPER}} .wready-coupon-row-wrapper .woo-ready-coupon-col' 
			]
		);

		$this->box_layout_child(
			[ 
			'title'        => esc_html__('Coupon Button','shop-ready'),
			'slug'         => 'coupon_form_container_button_style',
			'element_name' => 's_wready_coupon_button',
			'selector'     => '{{WRAPPER}} .wready-coupon-row-wrapper .wready-coup-btn-col' 
			]
		);

		$this->box_layout_child(
			[ 
			'title'        => esc_html__('Coupon Heading','shop-ready'),
			'slug'         => 'coupon_form_container_heading_style',
			'element_name' => 's_wready_coupon_heading',
			'selector'     => '{{WRAPPER}} .wready-coupon-row-wrapper .wready-coupon-heading-col' ,
			'condition' => [
				'show_coupon_heading' => ['yes']
			] 
			]
		);

		/** Layouts end */
	

	}


	protected function html() {

		$settings = $this->get_settings_for_display();

		if( is_null( WC()->cart ) ){
			return;	
		}
       
		shop_ready_widget_template_part(
            'checkout/template-part/coupon-form.php',
            array(
                'settings' => $settings,
            )
        );
	
	

	}

}