<?php
  $GLOBALS['product'] = $product;
  $GLOBALS['post'] = get_post($product->get_id());
  $product_tabs = apply_filters( 'woocommerce_product_tabs', array() );
if ( ! empty( $product_tabs ) ) : ?>

<div class="woocommerce-tabs wc-tabs-wrapper">

   
        <ul class="shop-ready-q-tabs">
            <?php foreach ( $product_tabs as $key => $product_tab ) : ?>
               
                <li class="<?php echo esc_attr( $key ); ?>_tab" id="tab-title-<?php echo esc_attr( $key ); ?>" role="tab" aria-controls="tab-<?php echo esc_attr( $key ); ?>">
                    <a href="#tab-<?php echo esc_attr( $key ); ?>">
                        <?php echo wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title', $product_tab['title'], $key ) ); ?>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
 

    <div class="wready-product-tab-content">
        <?php foreach ( $product_tabs as $key => $product_tab ) : ?>
              
                <div class="woocommerce-Tabs-panel woocommerce-Tabs-panel--<?php echo esc_attr( $key ); ?> panel entry-content" id="tab-<?php echo esc_attr( $key ); ?>" role="tabpanel" aria-labelledby="tab-title-<?php echo esc_attr( $key ); ?>">
                    <?php
                        if ( isset( $product_tab['callback'] ) ) {
                            call_user_func( $product_tab['callback'], $key, $product_tab );
                        }
                    ?>
                </div>
        <?php endforeach; ?>
   
    </div>
    
</div>

<?php endif; ?>