<?php

namespace Shop_Ready\extension\elewidgets\deps\product;
use Shop_Ready\helpers\classes\Elementor_Helper as WReady_Helper;
/** 
* @since 1.0 
* WooCommerce Product related 
* 
* @author quomodosoft.com 
*/

class Ajax_Service {
     
    public function register(){
     
      add_action( 'wp_ajax_wready_visited_product' , [$this,'wready_visited_product'] );
      add_action( 'wp_ajax_nopriv_wready_visited_product' , [$this,'wready_visited_product'] );
      
      add_action( 'wp_ajax_wready_compare_products' , [$this,'wready_compare_products'] );
      add_action( 'wp_ajax_nopriv_wready_compare_products' , [$this,'wready_compare_products'] );

      add_action( 'wp_ajax_wready_wishlist_products' , [$this,'wready_wishlist_products'] );
      add_action( 'wp_ajax_nopriv_wready_wishlist_products' , [$this,'wready_wishlist_products'] ); 
      
   

      add_action( 'wp_ajax_wready_quickview_products' , [$this,'wready_quickview_products'] );
      add_action( 'wp_ajax_nopriv_wready_quickview_products' , [$this,'wready_quickview_products'] );

      add_filter( 'woocommerce_add_to_cart_fragments', [$this,'woocommerce_header_add_to_cart_fragment'] );
      add_filter( 'woocommerce_add_to_cart_fragments', [$this,'add_to_cart_fragment_link'] );
      add_filter( 'woocommerce_add_to_cart_fragments', [$this,'cart_total_update'] );
    }
    
    function add_to_cart_fragment_link($fragments){
      
      global $woocommerce;
      $count_icon = WReady_Helper::get_global_setting('woo_ready_widget_cart_count_icon');
      $cart_label = WReady_Helper::get_global_setting('woo_ready_widget_cart_label');
      $singular   = WReady_Helper::get_global_setting('woo_ready_widget_cart_count_singular');
      $plural     = WReady_Helper::get_global_setting('woo_ready_widget_cart_count_plural');
      $before_text = WReady_Helper::get_global_setting('woo_ready_widget_cart_number_before_text');
      ob_start();
    
      ?>
      <a class="woo-ready-user-interface woo-ready-cart-fr" href="<?php echo wc_get_cart_url(); ?>">
            <?php echo shop_ready_render_icons( $count_icon,'wready-cart-count' ); ?>
            <?php if($before_text == 'yes'): ?>
                <?php if(isset(WC()->cart)){ ?>
                    <span class="wready-cart-count-before cart-count-sr-modifire"> <?php echo WC()->cart->get_cart_contents_count()>1?sprintf('%s %s',WC()->cart->get_cart_contents_count(),$plural):sprintf('%s %s',WC()->cart->get_cart_contents_count(),$singular); ?> </span>
                <?php } ?>
            <?php endif; ?>
            <?php if($cart_label !=''): ?>
              <div class="display:inline-block wready-cart-count-text shop-ready-cart-count-text-modifire"> <?php echo esc_html($cart_label); ?> </div> 
            <?php endif; ?>
            <?php if($before_text != 'yes'): ?>
                    <?php if(isset(WC()->cart)){ ?>
                        <span class="wready-cart-count-before cart-count-sr-modifire"> <?php echo WC()->cart->get_cart_contents_count()>1?sprintf('%s %s',WC()->cart->get_cart_contents_count(),$plural):sprintf('%s %s',WC()->cart->get_cart_contents_count(),$singular); ?> </span>
                    <?php } ?>
            <?php endif; ?>

          
      </a>
      <?php
      $fragments['a.woo-ready-cart-fr'] = ob_get_clean();
      ob_start();

      ?>
       <div class="wr-tax-amount"> <?php wc_cart_totals_taxes_total_html(); ?> </div>
      <?php
      $fragments['div.wr-tax-amount'] = ob_get_clean();
      return $fragments;
    
    }

    public function cart_total_update($fragments){
      ob_start();
      ?>
       <div class="wr-checkout-cart-total-bill"> <?php wc_cart_totals_order_total_html(); ?> </div>
      <?php
      $fragments['div.wr-checkout-cart-total-bill'] = ob_get_clean();
      return $fragments;
    }

    function woocommerce_header_add_to_cart_fragment( $fragments ) {
      global $woocommerce;

      $count_icon = WReady_Helper::get_global_setting('woo_ready_widget_cart_count_icon');
      $cart_label = WReady_Helper::get_global_setting('woo_ready_widget_cart_label');
      $singular   = WReady_Helper::get_global_setting('woo_ready_widget_cart_count_singular');
      $plural     = WReady_Helper::get_global_setting('woo_ready_widget_cart_count_plural');
      $before_text = WReady_Helper::get_global_setting('woo_ready_widget_cart_number_before_text');
      ob_start();
    
      ?>
        <div class="woo-ready-user-interface woo-ready-cart-popup">
              <?php echo shop_ready_render_icons( $count_icon,'wready-cart-count' ); ?>
              <?php if($before_text == 'yes'): ?>
                      <?php if(isset(WC()->cart)){ ?>
                          <span class="wready-cart-count-before cart-count-sr-modifire"> <?php echo WC()->cart->get_cart_contents_count()>1?sprintf('%s %s',WC()->cart->get_cart_contents_count(),$plural):sprintf('%s %s',WC()->cart->get_cart_contents_count(),$singular); ?> </span>
                      <?php } ?>
              <?php endif; ?>
              <?php if($cart_label !=''): ?>
                <div class="display:inline-block wready-cart-count-text shop-ready-cart-count-text-modifire"> <?php echo esc_html($cart_label); ?> </div> 
              <?php endif; ?>
              <?php if($before_text != 'yes'): ?>
                      <?php if(isset(WC()->cart)){ ?>
                          <span class="wready-cart-count-after cart-count-sr-modifire"> <?php echo WC()->cart->get_cart_contents_count()>1?sprintf('%s %s',WC()->cart->get_cart_contents_count(),$plural):sprintf('%s %s',WC()->cart->get_cart_contents_count(),$singular); ?> </span>
                      <?php } ?>
              <?php endif; ?>
            
          </div>
      <?php
      $fragments['div.woo-ready-cart-popup'] = ob_get_clean();

      ob_start();
      ?>

      <div class="wr-tax-amount"> <?php wc_cart_totals_taxes_total_html(); ?> </div>

      <?php
      $fragments['div.wr-tax-amount'] = ob_get_clean();
      return $fragments;
    }

    public function wready_visited_product(){
          
          if(isset($_REQUEST['posts_id'])){
            WC()->session->set( 'wready_visited_product' , sanitize_text_field($_REQUEST['posts_id']) );
          }
          wp_die();
    }

    public function senitize($input){
       $ids = [];
       $old_ids = json_decode($input);

       foreach($old_ids as $id){
        $ids[] = sanitize_text_field($id); 
       }

       return $ids;
    }
    
    public function wready_wishlist_products(){

          $ids             = $this->senitize($_REQUEST['posts_id']);
          $template_enable = WReady_Helper::get_global_setting('woo_ready_enable_product_wishlist_template_enable');
          
          $return = array(
              'message'  => esc_html__('Saved','shop-ready'),
              'products' => $this->get_products($ids),
              'template' => $template_enable =='yes'? true : false
          );

          if(isset($_REQUEST['posts_id'])){
           
            WC()->session->set( 'wready_wishlist_products' , $ids );
            $return['message'] = esc_html__('Saved','shop-ready');
            wp_send_json_success($return);
         
          }else{
            $return['message'] = esc_html__('Failed','shop-ready');
          }
  
          wp_send_json_error($return);
          wp_die();
    }
    
    public function wready_compare_products(){

          $ids = json_decode($_REQUEST['posts_id']);
         
          $template_enable = WReady_Helper::get_global_setting('woo_ready_enable_product_compare_template_enable');
          
          $return = array(
              'message'  => esc_html__('Saved','shop-ready'),
              'products' => $this->get_products($ids),
              'template' => $template_enable =='yes'? true : false
          );
  
          WC()->session->set( 'wready_compare_products',$ids );
          
          $return['message'] = esc_html__('Saved','shop-ready');
          wp_send_json_success($return);
       
          wp_die();
    } 
    
    public function wready_quickview_products(){
        
          $template_enable = WReady_Helper::get_global_setting('woo_ready_enable_product_quickview_template_enable');
          $_template_id    = WReady_Helper::get_global_setting('woo_ready_enable_product_quickview_template_id');
        
          if($template_enable == 'yes' && is_numeric($_template_id)){
            $template_enable = 'yes';
          }else{
            $template_enable = '';
          } 
          $return = array(
              'message'  => esc_html__('Found','shop-ready'),
              'template' => $template_enable == 'yes'? true : false
          );

          if(isset($_REQUEST['posts_id'])){
          
            $id                          = sanitize_text_field($_REQUEST['posts_id']);
            $product                     = wc_get_product($id);
            $GLOBALS['product']          = $product;
            $return ['message']          = esc_html__('Found','shop-ready');
            $return ['products']         = $this->get_product($product);
            $return ['template_content'] = \Elementor\Plugin::instance()->frontend->get_builder_content_for_display($_template_id);

            wp_send_json_success($return);
         
          }else{
            $return['message'] = esc_html__('Not found','shop-ready');
          }
  
          wp_send_json_error($return);
          wp_die();
    }

    public function get_products($ids){
      
      $return_list      = [];
      $add_to_cart_text = WReady_Helper::get_global_setting('woo_ready_product_wishlist_add_to_cart_text','add to cart');

      foreach($ids as $key => $id){
        
        $cart_id       = '';
        $product       = wc_get_product( $id );
      
        if($product->is_type('simple')){
          $cart_id = sprintf('<a href="?add-to-cart=%s" data-quantity="1" class="button %s add_to_cart_button ajax_add_to_cart woo-ready-wishlist-cart-btn" data-product_id="%s">%s</a>',$product->get_id(),$product->get_type(),$product->get_id(),$add_to_cart_text);   
        }else{
          $cart_id = sprintf('<a href="%s" class="button %s woo-ready-wishlist-cart-btn " data-product_id="%s">%s</a>',get_permalink( $product->get_id() ),$product->get_type(),$product->get_id(),$add_to_cart_text);   
        }
       
        $return_list[] = [
          'id'         => $id,
          'title'      => sprintf('<a href="%s" class="%s woo-ready-wishlist-pro-title" >%s</a>',get_permalink( $product->get_id() ),$product->get_type(),$product->get_name()),
          'featured'   => $product->get_featured()?esc_html__('Featured','shop-ready'):'',
          'sdesc'      => $product->get_short_description(),
          'link'       => get_permalink( $product->get_id() ),
          'price'      => $product->get_price_html(),
          'stock'      => $product->get_stock_quantity(),
          'stock_status'      => $product->get_stock_status(),
          'sku'      => $product->get_sku(),
          'dweight'    => $product->get_weight(),
          'dlength'    => $product->get_length(),
          'dwidth'     => $product->get_width(),
          'dheight'    => $product->get_height(),
          'dimensions' => $product->get_dimensions(false),
          'image'      => sprintf('<img class="%s woo-ready-wishlist-image sr-wish-table" src="%s" />',$product->get_type(), shop_ready_resize(get_the_post_thumbnail_url($product->get_id()),100,100)),
          'review'     => $product->get_average_rating(),
          'cart'       => $cart_id
        ];

        if($key == 2){
          break;
        }

      }

      return $return_list;
    } 
    
    public function get_product($product){

    
      
      $return_list      = '';
      $cart_id          = '';
      $add_to_cart_text = WReady_Helper::get_global_setting('woo_ready_product_quickview_add_to_cart_text','Add To Cart');
      if($add_to_cart_text == ''){
        $add_to_cart_text = esc_html__( 'Add to Cart', 'shop-ready' );
      }
      if($product->is_type('simple')){

        $cart_id = sprintf('<a href="?add-to-cart=%s" data-quantity="1" class="button %s add_to_cart_button ajax_add_to_cart woo-ready-quickview-cart-btn" data-product_id="%s">%s</a>',$product->get_id(),$product->get_type(),$product->get_id(),$add_to_cart_text);   
      }else{
        $cart_id = sprintf('<a href="%s" class="button %s woo-ready-quickview-cart-btn" data-product_id="%s">%s</a>',get_permalink( $product->get_id() ),$product->get_type(),$product->get_id(),$add_to_cart_text);   
      }
     
      $return_list = [
        'id'         => $product->get_id(),
        'title'      => sprintf('<a href="%s" class="%s woo-ready-wishlist-pro-title" >%s</a>',get_permalink( $product->get_id() ),esc_attr($product->get_type()),esc_html($product->get_name())),
        'featured'   => $product->get_featured()?esc_html__('Featured','shop-ready'):'',
        'sdesc'      => $product->get_short_description(),
        'link'       => get_permalink( $product->get_id() ),
        'price'      => $product->get_price_html(),
        'stock'      => $product->get_stock_quantity(),
        'stock_status'      => $product->get_stock_status(),
        'sku'      => $product->get_sku(),
        'dweight'    => $product->get_weight(),
        'dlength'    => $product->get_length(),
        'dwidth'     => $product->get_width(),
        'dheight'    => $product->get_height(),
        'dimensions' => $product->get_dimensions(false),
        'image'      => sprintf('<img class="%s woo-ready-wishlist-image" src="%s" />',$product->get_type(), get_the_post_thumbnail_url($product->get_id(),'medium')),
        'review'     => $product->get_average_rating(),
        'tab'        => '',
        'cart'       => $cart_id
      ];

      ob_start();
      include('views/product-tabs.php');
      $tab_content = ob_get_clean();
      $return_list['tab'] = $tab_content;

      ob_start();
      $rating  = $product->get_average_rating();
      $count   = $product->get_rating_count();
      echo wc_get_rating_html( $rating , $count );
      $review_html = ob_get_clean();
      $return_list['review'] = $review_html; 

      return $return_list;

    }

    
}