<?php
/**
 * @package Shop Ready
 */
namespace Shop_Ready\base\elementor\style_controls\common;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;

trait Widget_Common_Style {

    public function element_before_psudocode( $atts ) {

        $atts_variable = shortcode_atts(
            [
                'title'           => esc_html__( 'Separate', 'shop-ready' ),
                'slug'            => '_meta_after_before_style',
                'element_name'    => 'after__mangocube__',
                'selector'        => '{{WRAPPER}} ',
                'selector_parent' => '',
                'condition'       => '',
            ], $atts );

        extract( $atts_variable );

        $widget = $this->get_name() . '_' . shop_ready_heading_camelize( $slug );

        /*----------------------------
        ELEMENT__STYLE
        -----------------------------*/
        $tab_start_section_args = [
            'label' => $title,
            'tab'   => Controls_Manager::TAB_STYLE,
        ];

        if ( is_array( $condition ) ) {
            $tab_start_section_args['condition'] = $condition;
        }

        $this->start_controls_section(
            $widget . '_style_after_before_section',
            $tab_start_section_args
        );


        $this->add_control(
            'psdu_' . $element_name . '_color',
            [
                'label'     => esc_html__( 'Color', 'shop-ready' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    $selector => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            $widget . 'main_section_' . $element_name . 'psudud_opacity_color',
            [
                'label'      => esc_html__( 'Opacity', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 1,
                        'step' => 0.1,
                    ],

                ],

                'selectors'  => [
                    $selector_parent => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => $widget . 'main_section_' . $element_name . 'psudud_border_gp_',
                'label'    => esc_html__( 'Border', 'shop-ready' ),
                'selector' => $selector,
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_size_transform',
            [
                'label'      => esc_html__( 'Transform', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => -360,
                        'max'  => 360,
                        'step' => 5,
                    ],

                ],

                'selectors'  => [
                    $selector => 'transform: translateY(-50%) rotate({{SIZE}}deg);',
                ],
            ]
        );

        if ( $selector_parent != '' ) {
            $this->add_responsive_control(
                $widget . 'psudu_padding',
                [
                    'label'      => esc_html__( 'Padding', 'shop-ready' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors'  => [
                        $selector_parent => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );
        }

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_psudu_size_width',
            [
                'label'      => esc_html__( 'Width', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 2100,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . 'psudud_size_height',
            [
                'label'      => esc_html__( 'Height', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 2100,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . 'psudud_position_left_',
            [
                'label'      => esc_html__( 'Position Left', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => -2700,
                        'max'  => 2700,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . 'psudud_position_top_',
            [
                'label'      => esc_html__( 'Position Top', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => -2700,
                        'max'  => 2700,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            $widget . '_section__psudu_section_show_hide_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Display', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'block' => esc_html__( 'Block', 'shop-ready' ),
                    'none'  => esc_html__( 'None', 'shop-ready' ),
                    ''      => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'display: {{VALUE}};',
                ],
            ]

        );

        $this->end_controls_section();
    }

    public function element_size( $atts ) {

        $atts_variable = shortcode_atts(
            [
                'title'        => esc_html__( 'Size Style', 'shop-ready' ),
                'slug'         => '_size_style',
                'element_name' => '__mangocube__',
                'selector'     => '{{WRAPPER}} ',
                'condition'    => '',
            ], $atts );

        extract( $atts_variable );

        $widget = $this->get_name() . '_' . shop_ready_heading_camelize( $slug );

        /*----------------------------
        ELEMENT__STYLE
        -----------------------------*/
        $tab_start_section_args = [
            'label' => $title,
            'tab'   => Controls_Manager::TAB_STYLE,
        ];

        if ( is_array( $condition ) ) {
            $tab_start_section_args['condition'] = $condition;
        }

        $this->start_controls_section(
            $widget . '_style_section',
            $tab_start_section_args
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_size_width',
            [
                'label'      => esc_html__( 'Width', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'vw'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 2100,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_size_max_width',
            [
                'label'      => esc_html__( 'Max Width', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'vw'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 2100,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'max-width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_size_height',
            [
                'label'      => esc_html__( 'Height', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'vh'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 2100,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_size_max_height',
            [
                'label'      => esc_html__( 'Max Height', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'vh'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 2100,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'max-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => $widget . 'size_border',
                'label'    => esc_html__( 'Border', 'shop-ready' ),
                'selector' => $selector,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name'     => $widget . 'main_section_' . $element_name . '_r_box_shadow',
                'label'    => __( 'Box Shadow', 'shop-ready' ),
                'selector' => $selector,
            ]
        );

        // Radius
        $this->add_responsive_control(
            $widget . 'seze_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    $selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    public function text_css( $atts ) {

        $atts_variable = shortcode_atts(
            [
                'title'          => esc_html__( 'Text Style', 'shop-ready' ),
                'slug'           => '_text_style',
                'element_name'   => '__woo_ready__',
                'selector'       => '{{WRAPPER}} ',
                'hover_selector' => '{{WRAPPER}} ',
                'condition'      => '',
            ], $atts );

        extract( $atts_variable );

        $widget = $this->get_name() . '_' . shop_ready_heading_camelize( $slug );

        /*----------------------------
        ELEMENT__STYLE
        -----------------------------*/
        $tab_start_section_args = [
            'label' => $title,
            'tab'   => Controls_Manager::TAB_STYLE,
        ];

        if ( is_array( $condition ) ) {
            $tab_start_section_args['condition'] = $condition;
        }

        $this->start_controls_section(
            $widget . '_style_section',
            $tab_start_section_args
        );

        

        $this->start_controls_tabs( $widget . '_tabs_style' );

        
        $this->start_controls_tab(
            $widget . '_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'shop-ready' ),
            ]
        );



        // Typgraphy
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => $widget . '_typography',
                'selector' => $selector,
            ]
        );

        // Icon Color
        $this->add_control(
            $widget . '_text_color',
            [
                'label'     => esc_html__( 'Color', 'shop-ready' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    $selector => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Text_Shadow::get_type(),
            [
                'name'     => $widget . 'text_shadow_',
                'label'    => esc_html__( 'Text Shadow', 'shop-ready' ),
                'selector' => $selector,
            ]
        );

        // Background
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => $widget . 'text_background',
                'label'    => esc_html__( 'Background', 'shop-ready' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => $selector,
            ]
        );

        // Border
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => $widget . '_border',
                'label'    => esc_html__( 'Border', 'shop-ready' ),
                'selector' => $selector,
            ]
        );

        // Radius
        $this->add_responsive_control(
            $widget . '_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    $selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Shadow
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => $widget . 'normal_shadow',
                'selector' => $selector,
            ]
        );

        // Margin
        $this->add_responsive_control(
            $widget . '_margin',
            [
                'label'      => esc_html__( 'Margin', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    $selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Padding
        $this->add_responsive_control(
            $widget . '_padding',
            [
                'label'      => esc_html__( 'Padding', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            $widget . 'ele_box_transition',
            [
                'label'      => esc_html__( 'Transition', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0.1,
                        'max'  => 3,
                        'step' => 0.1,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 0.5,
                ],
                'selectors'  => [
                    $selector => 'transition: {{SIZE}}s;',

                ],
            ]
        );


        $this->end_controls_tab();
        
        if ( $hover_selector != false || $hover_selector != '' ) {

            $this->start_controls_tab(
                $widget . '_hover_tab',
                [
                    'label' => esc_html__( 'Hover', 'shop-ready' ),
                ]
            );

            //Hover Color
            $this->add_control(
                'hover_' . $element_name . '_color',
                [
                    'label'     => esc_html__( 'Color', 'shop-ready' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        $hover_selector => 'color: {{VALUE}} !important;',
                    ],
                ]
            );

            $this->add_group_control(
                \Elementor\Group_Control_Text_Shadow::get_type(),
                [
                    'name'     => $widget . 'text_shadow_hover_',
                    'label'    => esc_html__( 'Text Shadow', 'shop-ready' ),
                    'selector' => $hover_selector,
                ]
            );

            // Hover Background
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name'     => 'hover_' . $element_name . '_background',
                    'label'    => esc_html__( 'Background', 'shop-ready' ),
                    'types'    => ['classic', 'gradient'],
                    'selector' => $hover_selector,
                ]
            );

            // Border
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'     => 'hover_' . $element_name . '_border',
                    'label'    => esc_html__( 'Border', 'shop-ready' ),
                    'selector' => $hover_selector,
                ]
            );

            // Radius
            $this->add_responsive_control(
                'hover_' . $element_name . '_radius',
                [
                    'label'      => esc_html__( 'Border Radius', 'shop-ready' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors'  => [
                        $hover_selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            // Shadow
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name'     => 'hover_' . $element_name . '_shadow',
                    'selector' => $hover_selector,
                ]
            );

            $this->end_controls_tab();

            $this->start_controls_tab(
                $widget . '_position_tab',
                [
                    'label' => esc_html__( 'Position', 'shop-ready' ),
                ]
            ); 
    
                $this->add_responsive_control(
                    $widget . '_section__' . $element_name . '_position_type',
                    [
                        'label'     => esc_html__( 'Position', 'shop-ready' ),
                        'type'      => \Elementor\Controls_Manager::SELECT,
                        'default'   => '',
                        'options'   => [
                            'fixed'    => esc_html__( 'Fixed', 'shop-ready' ),
                            'absolute' => esc_html__( 'Absolute', 'shop-ready' ),
                            'relative' => esc_html__( 'Relative', 'shop-ready' ),
                            'sticky'   => esc_html__( 'Sticky', 'shop-ready' ),
                            'static'   => esc_html__( 'Static', 'shop-ready' ),
                            'inherit'  => esc_html__( 'inherit', 'shop-ready' ),
                            ''         => esc_html__( 'none', 'shop-ready' ),
                        ],
                        'selectors' => [
                            $selector => 'position: {{VALUE}};',
                        ],
    
                    ]
                );
    
                $this->add_responsive_control(
                    $widget . 'main_section_' . $element_name . '_position_left',
                    [
                        'label'      => esc_html__( 'Position Left', 'shop-ready' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%'],
                        'range'      => [
                            'px' => [
                                'min'  => -1600,
                                'max'  => 1600,
                                'step' => 5,
                            ],
                            '%'  => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
    
                        'selectors'  => [
                            $selector => 'left: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
    
                $this->add_responsive_control(
                    $widget . 'main_section_' . $element_name . '_r_position_top',
                    [
                        'label'      => esc_html__( 'Position Top', 'shop-ready' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%'],
                        'range'      => [
                            'px' => [
                                'min'  => -1600,
                                'max'  => 1600,
                                'step' => 5,
                            ],
                            '%'  => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
    
                        'selectors'  => [
                            $selector => 'top: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
    
                $this->add_responsive_control(
                    $widget . 'main_section_' . $element_name . '_r_position_bottom',
                    [
                        'label'      => esc_html__( 'Position Bottom', 'shop-ready' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%'],
                        'range'      => [
                            'px' => [
                                'min'  => -1600,
                                'max'  => 1600,
                                'step' => 5,
                            ],
                            '%'  => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
    
                        'selectors'  => [
                            $selector => 'bottom: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
                $this->add_responsive_control(
                    $widget . 'main_section_' . $element_name . '_r_position_right',
                    [
                        'label'      => esc_html__( 'Position Right', 'shop-ready' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%'],
                        'range'      => [
                            'px' => [
                                'min'  => -1600,
                                'max'  => 1600,
                                'step' => 5,
                            ],
                            '%'  => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
    
                        'selectors'  => [
                            $selector => 'right: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
            $this->end_controls_tab();
            $this->start_controls_tab(
                $widget . '_size_tab',
                [
                    'label' => esc_html__( 'Size', 'shop-ready' ),
                ]
            ); 
    
                $this->add_responsive_control(
                    $widget . 'main_section_' . $element_name . '_r_itemdsd_el__width',
                    [
                        'label'      => esc_html__( 'Width', 'shop-ready' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%'],
                        'range'      => [
                            'px' => [
                                'min'  => 0,
                                'max'  => 3000,
                                'step' => 5,
                            ],
                            '%'  => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
    
                        'selectors'  => [
                            $selector => 'width: {{SIZE}}{{UNIT}};',
    
                        ],
                    ]
                );
    
                $this->add_responsive_control(
                    $widget . 'main_section_' . $element_name . '_r_item_dsd_maxel__width',
                    [
                        'label'      => esc_html__( 'Max Width', 'shop-ready' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%'],
                        'range'      => [
                            'px' => [
                                'min'  => 0,
                                'max'  => 3000,
                                'step' => 5,
                            ],
                            '%'  => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
    
                        'selectors'  => [
                            $selector => 'max-width: {{SIZE}}{{UNIT}};',
    
                        ],
                    ]
                );
    
                $this->add_responsive_control(
                    $widget . 'main_section_' . $element_name . '_r_item_errt_min_el__width',
                    [
                        'label'      => esc_html__( 'Min Width', 'shop-ready' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%'],
                        'range'      => [
                            'px' => [
                                'min'  => 0,
                                'max'  => 3000,
                                'step' => 5,
                            ],
                            '%'  => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
    
                        'selectors'  => [
                            $selector => 'min-width: {{SIZE}}{{UNIT}};',
    
                        ],
                    ]
                );

                $this->add_responsive_control(
                    $widget . 'main_section_' . $element_name . '_r_item_errt_min_el__height',
                    [
                        'label'      => esc_html__( 'Height', 'shop-ready' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%'],
                        'range'      => [
                            'px' => [
                                'min'  => 0,
                                'max'  => 500,
                                'step' => 5,
                            ],
                            '%'  => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
    
                        'selectors'  => [
                            $selector => 'height: {{SIZE}}{{UNIT}};',
    
                        ],
                    ]
                );
    
    
            $this->end_controls_tab();

            

            do_action('custom_tab_'.$widget,$this);
        } // hover_select check end
        $this->end_controls_tabs();

        $this->add_responsive_control(
            $widget . '_section___section_show_hide_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Display', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'flex'         => esc_html__( 'Flex', 'shop-ready' ),
                    'inline-flex'  => esc_html__( 'Inline Flex', 'shop-ready' ),
                    'block'        => esc_html__( 'Block', 'shop-ready' ),
                    'inline-block' => esc_html__( 'Inline Block', 'shop-ready' ),
                    'grid'         => esc_html__( 'Grid', 'shop-ready' ),
                    'none'         => esc_html__( 'None', 'shop-ready' ),
                    ''             => esc_html__( 'Default', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'display: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            $widget . '_section___section_flex_direction_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Flex Direction', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'column'         => esc_html__( 'Column', 'shop-ready' ),
                    'row'            => esc_html__( 'Row', 'shop-ready' ),
                    'column-reverse' => esc_html__( 'Column Reverse', 'shop-ready' ),
                    'row-reverse'    => esc_html__( 'Row Reverse', 'shop-ready' ),
                    'revert'         => esc_html__( 'Revert', 'shop-ready' ),
                    'none'           => esc_html__( 'None', 'shop-ready' ),
                    ''               => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'flex-direction: {{VALUE}};',
                ],
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
            ]

        );

        $this->add_responsive_control(
            $widget . 'txt_wr_section_' . $element_name . '_flex_gap',
            [
                'label'      => esc_html__( 'Gap', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'gap: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . '_section__s_section_flex_wrap_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Flex Wrap', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'wrap'         => esc_html__( 'Wrap', 'shop-ready' ),
                    'wrap-reverse' => esc_html__( 'Wrap Reverse', 'shop-ready' ),
                    'nowrap'       => esc_html__( 'No Wrap', 'shop-ready' ),
                    'unset'        => esc_html__( 'Unset', 'shop-ready' ),
                    'normal'       => esc_html__( 'None', 'shop-ready' ),
                    'inherit'      => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'flex-wrap: {{VALUE}};',
                ],
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
            ]

        );

        $this->add_responsive_control(
            $widget . '_alignment', [
                'label'     => esc_html__( 'Alignment', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [

                    'left'    => [

                        'title' => esc_html__( 'Left', 'shop-ready' ),
                        'icon'  => 'fa fa-align-left',

                    ],
                    'center'  => [

                        'title' => esc_html__( 'Center', 'shop-ready' ),
                        'icon'  => 'fa fa-align-center',

                    ],
                    'right'   => [

                        'title' => esc_html__( 'Right', 'shop-ready' ),
                        'icon'  => 'fa fa-align-right',

                    ],

                    'justify' => [

                        'title' => esc_html__( 'Justified', 'shop-ready' ),
                        'icon'  => 'fa fa-align-justify',

                    ],
                ],

                'selectors' => [
                    $selector => 'text-align: {{VALUE}};',
                ],
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['block', 'inline-block']],
            ]
        ); //Responsive control end

        $this->add_responsive_control(
            $widget . '_section_align_sessction_e_' . $element_name . '_flex_align',
            [
                'label'     => esc_html__( 'Alignment', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'flex-start'    => esc_html__( 'Left', 'shop-ready' ),
                    'flex-end'      => esc_html__( 'Right', 'shop-ready' ),
                    'center'        => esc_html__( 'Center', 'shop-ready' ),
                    'space-around'  => esc_html__( 'Space Around', 'shop-ready' ),
                    'space-between' => esc_html__( 'Space Between', 'shop-ready' ),
                    'space-evenly'  => esc_html__( 'Space Evenly', 'shop-ready' ),
                    ''              => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],

                'selectors' => [
                    $selector => 'justify-content: {{VALUE}};',
                ],
            ]

        );

        $this->add_responsive_control(
            $widget . 'er_section_align_items_ssection_e_' . $element_name . '_flex_align',
            [
                'label'     => esc_html__( 'Align Items', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'flex-start' => esc_html__( 'Left', 'shop-ready' ),
                    'flex-end'   => esc_html__( 'Right', 'shop-ready' ),
                    'center'     => esc_html__( 'Center', 'shop-ready' ),
                    'baseline'   => esc_html__( 'Baseline', 'shop-ready' ),
                    ''           => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],

                'selectors' => [
                    $selector => 'align-items: {{VALUE}};',
                ],
            ]

        );
 

        $this->end_controls_section();
        /*----------------------------
    ELEMENT__STYLE END
    -----------------------------*/
    }

    public function text_wrapper_css( $atts ) {

        $atts_variable = shortcode_atts(
            [
                'title'          => esc_html__( 'Text Style', 'shop-ready' ),
                'slug'           => '_text_style',
                'element_name'   => '__mangocube__',
                'selector'       => '{{WRAPPER}} ',
                'hover_selector' => '{{WRAPPER}} ',
                'condition'      => '',
            ], $atts );

        extract( $atts_variable );

        $widget = $this->get_name() . '_' . shop_ready_heading_camelize( $slug );

        /*----------------------------
        ELEMENT__STYLE
        -----------------------------*/
        $tab_start_section_args = [
            'label' => $title,
            'tab'   => Controls_Manager::TAB_STYLE,
        ];

        if ( is_array( $condition ) ) {
            $tab_start_section_args['condition'] = $condition;
        }

        $this->start_controls_section(
            $widget . '_style_section',
            $tab_start_section_args
        );

        $this->start_controls_tabs( $widget . '_tabs_style' );
      
        do_action('custom_tab_'.$widget,$this);
        $this->start_controls_tab(
            $widget . '_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'shop-ready' ),
            ]
        );

        $this->add_control(
			$widget.'_sr_extension_hook_id',
			[
				'label' => __( 'Extension Hook id', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			    'default' => 'custom_'.$widget
			]
		);

        do_action('custom_'.$widget,$this);
        // Typgraphy
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => $widget . '_typography',
                'selector' => $selector,
            ]
        );

        

        // Icon Color
        $this->add_control(
            $widget . '_text_color',
            [
                'label'     => esc_html__( 'Color', 'shop-ready' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    $selector => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Text_Shadow::get_type(),
            [
                'name'     => $widget . 'text_shadow_',
                'label'    => esc_html__( 'Text Shadow', 'shop-ready' ),
                'selector' => $selector,
            ]
        );

        // Background
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => $widget . 'text_background',
                'label'    => esc_html__( 'Background', 'shop-ready' ),
                'types'    => ['classic', 'gradient', 'video'],
                'selector' => $selector,
            ]
        );

        // Border
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => $widget . '_border',
                'label'    => esc_html__( 'Border', 'shop-ready' ),
                'selector' => $selector,
            ]
        );

        // Radius
        $this->add_responsive_control(
            $widget . '_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    $selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Shadow
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => $widget . 'normal_shadow',
                'selector' => $selector,
            ]
        );

        // Margin
        $this->add_responsive_control(
            $widget . '_margin',
            [
                'label'      => esc_html__( 'Margin', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    $selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Padding
        $this->add_responsive_control(
            $widget . '_padding',
            [
                'label'      => esc_html__( 'Padding', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
            $widget . 'ele_box_transition',
            [
                'label'      => esc_html__( 'Transition', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0.1,
                        'max'  => 3,
                        'step' => 0.1,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 0.5,
                ],
                'selectors'  => [
                    $selector => 'transition: {{SIZE}}s;',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_item_el__width',
            [
                'label'      => esc_html__( 'Width', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 3000,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'width: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_item__maxel__width',
            [
                'label'      => esc_html__( 'Max Width', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 3000,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'max-width: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_item__min_el__width',
            [
                'label'      => esc_html__( 'Min Width', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 3000,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'min-width: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->end_controls_tab();
        if ( $hover_selector != false || $hover_selector != '' ) {

            $this->start_controls_tab(
                $widget . '_hover_tab',
                [
                    'label' => esc_html__( 'Hover', 'shop-ready' ),
                ]
            );

            //Hover Color
            $this->add_control(
                'hover_' . $element_name . '_color',
                [
                    'label'     => esc_html__( 'Color', 'shop-ready' ),
                    'type'      => Controls_Manager::COLOR,
                    'selectors' => [
                        $hover_selector => 'color: {{VALUE}} !important;',
                    ],
                ]
            );

            $this->add_group_control(
                \Elementor\Group_Control_Text_Shadow::get_type(),
                [
                    'name'     => $widget . 'text_shadow_hover_',
                    'label'    => esc_html__( 'Text Shadow', 'shop-ready' ),
                    'selector' => $hover_selector,
                ]
            );

            // Hover Background
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name'     => 'hover_' . $element_name . '_background',
                    'label'    => esc_html__( 'Background', 'shop-ready' ),
                    'types'    => ['classic', 'gradient'],
                    'selector' => $hover_selector,
                ]
            );

            // Border
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'     => 'hover_' . $element_name . '_border',
                    'label'    => esc_html__( 'Border', 'shop-ready' ),
                    'selector' => $hover_selector,
                ]
            );

            // Radius
            $this->add_responsive_control(
                'hover_' . $element_name . '_radius',
                [
                    'label'      => esc_html__( 'Border Radius', 'shop-ready' ),
                    'type'       => Controls_Manager::DIMENSIONS,
                    'size_units' => ['px', '%', 'em'],
                    'selectors'  => [
                        $hover_selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            // Shadow
            $this->add_group_control(
                Group_Control_Box_Shadow::get_type(),
                [
                    'name'     => 'hover_' . $element_name . '_shadow',
                    'selector' => $hover_selector,
                ]
            );


            $this->end_controls_tab();
        } // hover_select check end
        $this->end_controls_tabs();

        $this->add_responsive_control(
            $widget . '_section___section_show_hide_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Layout', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'flex'         => esc_html__( 'Flex Layout', 'shop-ready' ),
                    'inline-flex'  => esc_html__( 'Inline Flex Layout', 'shop-ready' ),
                    'block'        => esc_html__( 'Block layout', 'shop-ready' ),
                    'inline-block' => esc_html__( 'Inline Layout', 'shop-ready' ),
                    'grid'         => esc_html__( 'Grid layout', 'shop-ready' ),
                    'grid'         => esc_html__( 'Flow Layout', 'shop-ready' ),
                    'none'         => esc_html__( 'Hide', 'shop-ready' ),
                    ''             => esc_html__( 'Default', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'display: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            $widget . '_section___section_flex_direction_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Flex Direction', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'column'         => esc_html__( 'Column', 'shop-ready' ),
                    'row'            => esc_html__( 'Row', 'shop-ready' ),
                    'column-reverse' => esc_html__( 'Column Reverse', 'shop-ready' ),
                    'row-reverse'    => esc_html__( 'Row Reverse', 'shop-ready' ),
                    'revert'         => esc_html__( 'Revert', 'shop-ready' ),
                    'none'           => esc_html__( 'None', 'shop-ready' ),
                    ''               => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'flex-direction: {{VALUE}};',
                ],
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
            ]

        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_basis',
            [
                'label'      => esc_html__( 'Item Width', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],
                    '%'  => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'flex-basis: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_grow',
            [
                'label'      => esc_html__( 'Item Grow', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'flex-grow: {{SIZE}}',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_shrink',
            [
                'label'      => esc_html__( 'Item Shrink', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'flex-shrink: {{SIZE}}',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_order',
            [
                'label'      => esc_html__( 'Item Order', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'order: {{SIZE}}',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'text_section_' . $element_name . '_flexs_gap',
            [
                'label'      => esc_html__( 'Gap', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'gap: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . '_section__s_section_flexr_wrap_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Flex Wrap', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'wrap'         => esc_html__( 'Wrap', 'shop-ready' ),
                    'wrap-reverse' => esc_html__( 'Wrap Reverse', 'shop-ready' ),
                    'nowrap'       => esc_html__( 'No Wrap', 'shop-ready' ),
                    'unset'        => esc_html__( 'Unset', 'shop-ready' ),
                    'normal'       => esc_html__( 'None', 'shop-ready' ),
                    'inherit'      => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'flex-wrap: {{VALUE}};',
                ],
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
            ]

        );

        $this->add_responsive_control(
            $widget . '_section_align_sessctionr_e_' . $element_name . '_flex_align',
            [
                'label'     => esc_html__( 'Alignment', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'flex-start'    => esc_html__( 'Left', 'shop-ready' ),
                    'flex-end'      => esc_html__( 'Right', 'shop-ready' ),
                    'center'        => esc_html__( 'Center', 'shop-ready' ),
                    'space-around'  => esc_html__( 'Space Around', 'shop-ready' ),
                    'space-between' => esc_html__( 'Space Between', 'shop-ready' ),
                    'space-evenly'  => esc_html__( 'Space Evenly', 'shop-ready' ),
                    ''              => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],

                'selectors' => [
                    $selector => 'justify-content: {{VALUE}};',
                ],
            ]

        );

        $this->add_responsive_control(
            $widget . 'er_section_align_items_rssection_e_' . $element_name . '_flex_align',
            [
                'label'     => esc_html__( 'Align Items', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'flex-start' => esc_html__( 'Left', 'shop-ready' ),
                    'flex-end'   => esc_html__( 'Right', 'shop-ready' ),
                    'center'     => esc_html__( 'Center', 'shop-ready' ),
                    'baseline'   => esc_html__( 'Baseline', 'shop-ready' ),
                    ''           => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],

                'selectors' => [
                    $selector => 'align-items: {{VALUE}};',
                ],
            ]

        );

        $this->add_control(
            $widget . '_section___section_popover_' . $element_name . '_position',
            [
                'label'        => esc_html__( 'Position', 'shop-ready' ),
                'type'         => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label_off'    => esc_html__( 'Default', 'shop-ready' ),
                'label_on'     => esc_html__( 'Custom', 'shop-ready' ),
                'return_value' => 'yes',
            ]
        );

        $this->start_popover();
        $this->add_responsive_control(
            $widget . '_section__' . $element_name . '_position_type',
            [
                'label'     => esc_html__( 'Position', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'fixed'    => esc_html__( 'Fixed', 'shop-ready' ),
                    'absolute' => esc_html__( 'Absolute', 'shop-ready' ),
                    'relative' => esc_html__( 'Relative', 'shop-ready' ),
                    'sticky'   => esc_html__( 'Sticky', 'shop-ready' ),
                    'static'   => esc_html__( 'Static', 'shop-ready' ),
                    'inherit'  => esc_html__( 'inherit', 'shop-ready' ),
                    ''         => esc_html__( 'none', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'position: {{VALUE}};',
                ],

            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_position_left',
            [
                'label'      => esc_html__( 'Position Left', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => -1600,
                        'max'  => 1600,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_position_top',
            [
                'label'      => esc_html__( 'Position Top', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => -1600,
                        'max'  => 1600,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_position_bottom',
            [
                'label'      => esc_html__( 'Position Bottom', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => -1600,
                        'max'  => 1600,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_position_right',
            [
                'label'      => esc_html__( 'Position Right', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => -1600,
                        'max'  => 1600,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_popover();

        $this->end_controls_section();
        /*----------------------------
    ELEMENT__STYLE END
    -----------------------------*/
    }
    public function text_minimum_css( $atts ) {

        $atts_variable = shortcode_atts(
            [
                'title'          => esc_html__( 'Text Style', 'shop-ready' ),
                'slug'           => '_text_style',
                'element_name'   => '__mangocube__',
                'selector'       => '{{WRAPPER}} ',
                'hover_selector' => '{{WRAPPER}} ',
                'condition'      => '',
                'tab'            => Controls_Manager::TAB_STYLE,
            ], $atts );

        extract( $atts_variable );

        $widget = $this->get_name() . '_' . shop_ready_heading_camelize( $slug );

        /*----------------------------
        ELEMENT__STYLE
        -----------------------------*/

        $tab_start_section_args = [
            'label' => $title,
            'tab'   => $tab,
        ];

        if ( is_array( $condition ) ) {
            $tab_start_section_args['condition'] = $condition;
        }

        $this->start_controls_section(
            $widget . '_style_section',
            $tab_start_section_args
        );

        $this->start_controls_tabs( $widget . '_tabs_style' );
      
        do_action('custom_tab_'.$widget,$this);
        $this->start_controls_tab(
            $widget . '_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'shop-ready' ),
            ]
        );

        $this->add_control(
			$widget.'_sr_extension_hook_id',
			[
				'label' => __( 'Extension Hook id', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			    'default' => 'custom_'.$widget
			]
		);

        do_action('custom_'.$widget,$this);
        // Typgraphy
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => $widget . '_stypography',
                'selector' => $selector,
            ]
        );

        // Icon Color
        $this->add_control(
            $widget . '_text_color',
            [
                'label'     => esc_html__( 'Color', 'shop-ready' ),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    $selector => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        //  Background
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'gens_' . $element_name . '_background',
                'label'    => esc_html__( 'Background', 'shop-ready' ),
                'types'    => ['classic', 'gradient'],
                'selector' => $selector,
            ]
        );

        // Border
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => 'gens_' . $element_name . '_border',
                'label'    => esc_html__( 'Border', 'shop-ready' ),
                'selector' => $selector,
            ]
        );

        $this->add_responsive_control(
            $widget . '_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    $selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Margin
        $this->add_responsive_control(
            $widget . '_smargin',
            [
                'label'      => esc_html__( 'Margin', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    $selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Padding
        $this->add_responsive_control(
            $widget . '_padding',
            [
                'label'      => esc_html__( 'Padding', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            $widget . '_section___section_show_hide_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Display', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'flex'         => esc_html__( 'Flex', 'shop-ready' ),
                    'inline-flex'  => esc_html__( 'Inline Flex', 'shop-ready' ),
                    'block'        => esc_html__( 'Block', 'shop-ready' ),
                    'inline-block' => esc_html__( 'Inline Block', 'shop-ready' ),
                    'none'         => esc_html__( 'None', 'shop-ready' ),
                    ''             => esc_html__( 'Default', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'display: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            $widget . 'ele_box_transition',
            [
                'label'      => esc_html__( 'Transition', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0.1,
                        'max'  => 3,
                        'step' => 0.1,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 0.5,
                ],
                'selectors'  => [
                    $selector => 'transition: {{SIZE}}s;',

                ],
            ]
        );

        $this->end_controls_tab();
        // Hover selector
        if ( $hover_selector != false || $hover_selector != '' ) {

            $this->start_controls_tab(
                $widget . '_hover_tab',
                [
                    'label' => esc_html__( 'Hover', 'shop-ready' ),
                ]
            );

            // Icon Color
            $this->add_control(
                $widget . 'hover_text_color',
                [
                    'label'     => esc_html__( 'Color', 'shop-ready' ),
                    'type'      => Controls_Manager::COLOR,
                    'default'   => '',
                    'selectors' => [
                        $hover_selector => 'color: {{VALUE}} !important;',
                    ],
                ]
            );

            // Hover Background
            $this->add_group_control(
                Group_Control_Background::get_type(),
                [
                    'name'     => 'hovers_' . $element_name . '_background',
                    'label'    => esc_html__( 'Background', 'shop-ready' ),
                    'types'    => ['classic', 'gradient'],
                    'selector' => $hover_selector,
                ]
            );

            // Border
            $this->add_group_control(
                Group_Control_Border::get_type(),
                [
                    'name'     => 'hovers_' . $element_name . '_border',
                    'label'    => esc_html__( 'Border', 'shop-ready' ),
                    'selector' => $hover_selector,
                ]
            );

            $this->end_controls_tab();
        } // hover_select check end
        $this->end_controls_tabs();

        $this->end_controls_section();
        /*----------------------------
    ELEMENT__STYLE END
    -----------------------------*/
    }

}