<?php
/**
 * @package Shop Ready
 */
namespace Shop_Ready\base\elementor\style_controls\box;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

trait Widget_Box_Style {

    public function box_minimum_css( $atts ) {

        $atts_variable = shortcode_atts(
            [
                'title'        => esc_html__( 'Box Style', 'shop-ready' ),
                'slug'         => 'mini_box_style',
                'element_name' => '__mangocube__',
                'selector'     => '{{WRAPPER}} ',
                'condition'    => '',
                'tab'          => Controls_Manager::TAB_STYLE,

            ], $atts );

        extract( $atts_variable );

        $widget = $this->get_name() . '_' . shop_ready_heading_camelize( $slug );

        $tab_start_section_args = [
            'label' => $title,
            'tab'   => $tab,
        ];

        if ( is_array( $condition ) ) {
            $tab_start_section_args['condition'] = $condition;
        }

        /*----------------------------
        ELEMENT__STYLE
        -----------------------------*/
        $this->start_controls_section(
            $widget . '_style_section',
            $tab_start_section_args
        );

        $this->start_controls_tabs( $widget . '_tabs_style' );
        $this->start_controls_tab(
            $widget . '_normal_tab',
            [
                'label' => esc_html__( 'Style', 'shop-ready' ),
            ]
        );

        $this->add_responsive_control(
            $widget . 'grid_service_yuit_alignment', [
                'label'     => esc_html__( 'Alignment', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [

                    'left'    => [

                        'title' => esc_html__( 'Left', 'shop-ready' ),
                        'icon'  => 'fa fa-align-left',

                    ],
                    'center'  => [

                        'title' => esc_html__( 'Center', 'shop-ready' ),
                        'icon'  => 'fa fa-align-center',

                    ],
                    'right'   => [

                        'title' => esc_html__( 'Right', 'shop-ready' ),
                        'icon'  => 'fa fa-align-right',

                    ],

                    'justify' => [

                        'title' => esc_html__( 'Justified', 'shop-ready' ),
                        'icon'  => 'fa fa-align-justify',

                    ],
                ],

                'selectors' => [
                    $selector => 'text-align: {{VALUE}};',
                ],
               
            ]
        ); //Responsive control end
        // Background
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => $widget . '_background',
                'label'    => esc_html__( 'Background', 'shop-ready' ),
                'types'    => ['classic', 'gradient'],
                'selector' => $selector,
            ]
        );

        // Border
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => $widget . '_border',
                'label'    => esc_html__( 'Border', 'shop-ready' ),
                'selector' => $selector,
            ]
        );

        // Radius
        $this->add_responsive_control(
            $widget . '_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    $selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );

        // Margin
        $this->add_responsive_control(
            $widget . '_margin',
            [
                'label'      => esc_html__( 'Margin', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [

                    $selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Padding
        $this->add_responsive_control(
            $widget . '_padding',
            [
                'label'      => esc_html__( 'Padding', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
            $widget . '_section___section_show_hide_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Display', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'flex'         => esc_html__( 'Flex Layout', 'shop-ready' ),
                    'block'        => esc_html__( 'Block Layout', 'shop-ready' ),
                    'inline-block' => esc_html__( 'Inline Layout', 'shop-ready' ),
                    'none'         => esc_html__( 'None', 'shop-ready' ),
                    ''             => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'display: {{VALUE}};',
                ],
            ]

        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_basis',
            [
                'label'      => esc_html__( 'Item Width', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['inherit']],
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],
                    '%'  => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'flex-basis: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_order',
            [
                'label'      => esc_html__( 'Item Order', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex', 'inherit', 'initial', 'grid']],
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'order: {{SIZE}}',

                ],
            ]
        );

        $this->end_controls_section();
        /*----------------------------
    ELEMENT__STYLE END
    -----------------------------*/
    }
    public function box_css( $atts ) {

        $atts_variable = shortcode_atts(
            [
                'title'        => esc_html__( 'Box Style', 'shop-ready' ),
                'slug'         => '_box_style',
                'element_name' => 'woo_ready__',
                'selector'     => '{{WRAPPER}} ',
                'condition'    => '',
                'tab'          => Controls_Manager::TAB_STYLE,

            ], $atts );

        extract( $atts_variable );

        $widget = $this->get_name() . '_' . shop_ready_heading_camelize( $slug );

        $tab_start_section_args = [
            'label' => $title,
            'tab'   => $tab,
        ];

        if ( is_array( $condition ) ) {
            $tab_start_section_args['condition'] = $condition;
        }

        /*----------------------------
        ELEMENT__STYLE
        -----------------------------*/
        $this->start_controls_section(
            $widget . '_style_section',
            $tab_start_section_args
        );

        $this->start_controls_tabs( $widget . '_tabs_style' );

        $this->start_controls_tab(
            $widget . '_normal_tab',
            [
                'label' => esc_html__( 'Normal', 'shop-ready' ),
            ]
        );

        $this->add_control(
			$widget.'_sr_extension_hook_id',
			[
				'label' => __( 'Extension Hook id', 'shop-ready' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			
                'default' => 'custom_'.$widget
			]
		);

        do_action('custom_'.$widget,$this);

        $this->add_responsive_control(
            $widget . 'grids_service_yuit_alignment', [
                'label'     => esc_html__( 'Alignment', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::CHOOSE,
                'options'   => [

                    'left'    => [

                        'title' => esc_html__( 'Left', 'shop-ready' ),
                        'icon'  => 'fa fa-align-left',

                    ],
                    'center'  => [

                        'title' => esc_html__( 'Center', 'shop-ready' ),
                        'icon'  => 'fa fa-align-center',

                    ],
                    'right'   => [

                        'title' => esc_html__( 'Right', 'shop-ready' ),
                        'icon'  => 'fa fa-align-right',

                    ],

                    'justify' => [

                        'title' => esc_html__( 'Justified', 'shop-ready' ),
                        'icon'  => 'fa fa-align-justify',

                    ],
                ],

                'selectors' => [
                    $selector => 'text-align: {{VALUE}};',
                ],
               
            ]
        ); //Responsive control end
        // Background
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => $widget . '_background',
                'label'    => esc_html__( 'Background', 'shop-ready' ),
                'types'    => ['classic', 'gradient'],
                'selector' => $selector,
            ]
        );

        // Border
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'     => $widget . '_border',
                'label'    => esc_html__( 'Border', 'shop-ready' ),
                'selector' => $selector,
            ]
        );

        // Radius
        $this->add_responsive_control(
            $widget . '_radius',
            [
                'label'      => esc_html__( 'Border Radius', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    $selector => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );

        // Shadow
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => $widget . '_shadow',
                'selector' => $selector,
            ]
        );

        // Margin
        $this->add_responsive_control(
            $widget . '_margin',
            [
                'label'      => esc_html__( 'Margin', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [

                    $selector => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Padding
        $this->add_responsive_control(
            $widget . '_padding',
            [
                'label'      => esc_html__( 'Padding', 'shop-ready' ),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors'  => [
                    $selector => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',

                ],
            ]
        );

        $this->end_controls_tab();


        $this->start_controls_tab(
            $widget . '_positionl_tab',
            [
                'label' => esc_html__( 'Position', 'shop-ready' ),
            ]
        );

        $this->add_responsive_control(
            $widget.'_section__' . $element_name . '_position_type',
            [
                'label'     => esc_html__( 'Position', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'fixed'    => esc_html__( 'Fixed', 'shop-ready' ),
                    'absolute' => esc_html__( 'Absolute', 'shop-ready' ),
                    'relative' => esc_html__( 'Relative', 'shop-ready' ),
                    'sticky'   => esc_html__( 'Sticky', 'shop-ready' ),
                    'static'   => esc_html__( 'Static', 'shop-ready' ),
                    'inherit'  => esc_html__( 'inherit', 'shop-ready' ),
                    ''         => esc_html__( 'none', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'position: {{VALUE}};',

                ],

            ]
        );

        $this->add_responsive_control(
            $widget.'wrain_section_'.$element_name.'_position_left',
            [
                'label'      => esc_html__( 'Position Left', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => -3000,
                        'max'  => 3000,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'left: {{SIZE}}{{UNIT}};'

                ],
            ]
        );

        $this->add_responsive_control(
            $widget.'main_section_' . $element_name . '_r_position_top',
            [
                'label'      => esc_html__( 'Position Top', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => -3000,
                        'max'  => 3000,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'top: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget.'main_section_' . $element_name . '_r_position_bottom',
            [
                'label'      => esc_html__( 'Position Bottom', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => -2100,
                        'max'  => 3000,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'bottom: {{SIZE}}{{UNIT}};',

                ],
            ]
        );
        $this->add_responsive_control(
            $widget.'main_section_' . $element_name . '_r_position_right',
            [
                'label'      => esc_html__( 'Position Right', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => -1600,
                        'max'  => 3000,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'right: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->end_controls_tab();
  
        $this->start_controls_tab(
            $widget . '_size_tab',
            [
                'label' => esc_html__( 'Size', 'shop-ready' ),
            ]
        ); 

                $this->add_responsive_control(
                    $widget . 'main_section_' . $element_name . '_r_section__width',
                    [
                        'label'      => esc_html__( 'Width', 'shop-ready' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%', 'vw'],
                        'range'      => [
                            'px' => [
                                'min'  => 0,
                                'max'  => 3000,
                                'step' => 5,
                            ],
                            '%'  => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],

                        'selectors'  => [
                            $selector => 'width: {{SIZE}}{{UNIT}};',

                        ],
                    ]
                );

                $this->add_responsive_control(
                    $widget . 'main_section_' . $element_name . '_r_container_height',
                    [
                        'label'      => esc_html__( 'Height', 'shop-ready' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%', 'vh'],
                        'range'      => [
                            'px' => [
                                'min'  => 0,
                                'max'  => 3000,
                                'step' => 5,
                            ],
                            '%'  => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],

                        'selectors'  => [
                            $selector => 'height: {{SIZE}}{{UNIT}};',

                        ],
                    ]
                );

                $this->add_responsive_control(
                    $widget . 'main_section_' . $element_name . '_r_section_min__width',
                    [
                        'label'      => esc_html__( 'Min Width', 'shop-ready' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%', 'vw'],
                        'range'      => [
                            'px' => [
                                'min'  => 0,
                                'max'  => 3000,
                                'step' => 5,
                            ],
                            '%'  => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],

                        'selectors'  => [
                            $selector => 'min-width: {{SIZE}}{{UNIT}};',

                        ],
                    ]
                );

                $this->add_responsive_control(
                    $widget . 'main_section_' . $element_name . '_r_section_max__width',
                    [
                        'label'      => esc_html__( 'Max Width', 'shop-ready' ),
                        'type'       => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%', 'vh'],
                        'range'      => [
                            'px' => [
                                'min'  => 0,
                                'max'  => 3000,
                                'step' => 5,
                            ],
                            '%'  => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],

                        'selectors'  => [
                            $selector => 'max-width: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );

        $this->end_controls_tab();
        do_action('custom_tab_'.$widget,$this);
      
        $this->end_controls_tabs();

        $this->add_responsive_control(
            $widget . '_section___section_show_hide_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Display', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'flex'          => esc_html__( 'Flex Layout', 'shop-ready' ),
                    'inherit'       => esc_html__( 'Flex Child Layout', 'shop-ready' ),
                    'inline-flex'   => esc_html__( 'Inline Flex Layout', 'shop-ready' ),
                    'block'         => esc_html__( 'Block Layout', 'shop-ready' ),
                    'inline-block'  => esc_html__( 'Inline Layout', 'shop-ready' ),
                    'grid'          => esc_html__( 'Grid Layout', 'shop-ready' ),
                    'inline-grid'   => esc_html__( 'Grid Inline Layout', 'shop-ready' ),
                    'initial'       => esc_html__( 'Grid Child Layout', 'shop-ready' ),
                    'table-caption' => esc_html__( 'Table Layout', 'shop-ready' ),
                    'flow-root'     => esc_html__( 'Flow Layout', 'shop-ready' ),
                    'none'          => esc_html__( 'None', 'shop-ready' ),
                    ''              => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'display: {{VALUE}};',
                ],
            ]

        );

        $this->add_responsive_control(
            $widget . '_section___section_flex_direction_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Flex Direction', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'column'         => esc_html__( 'Column', 'shop-ready' ),
                    'row'            => esc_html__( 'Row', 'shop-ready' ),
                    'column-reverse' => esc_html__( 'Column Reverse', 'shop-ready' ),
                    'row-reverse'    => esc_html__( 'Row Reverse', 'shop-ready' ),
                    'revert'         => esc_html__( 'Revert', 'shop-ready' ),
                    'none'           => esc_html__( 'None', 'shop-ready' ),
                    ''               => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'flex-direction: {{VALUE}};',
                ],
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
            ]

        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_basis',
            [
                'label'      => esc_html__( 'Item Width', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['inherit']],
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],
                    '%'  => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'flex-basis: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_grow',
            [
                'label'      => esc_html__( 'Item Grow', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex', 'inherit']],
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'flex-grow: {{SIZE}}',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_shrink',
            [
                'label'      => esc_html__( 'Item Shrink', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex', 'inherit']],
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'flex-shrink: {{SIZE}}',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_order',
            [
                'label'      => esc_html__( 'Item Order', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex', 'inherit', 'initial', 'grid']],
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'order: {{SIZE}}',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_gap',
            [
                'label'      => esc_html__( 'Gap', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'gap: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . '_section___section_flex_wrap_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Flex Wrap', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'wrap'         => esc_html__( 'Wrap', 'shop-ready' ),
                    'wrap-reverse' => esc_html__( 'Wrap Reverse', 'shop-ready' ),
                    'nowrap'       => esc_html__( 'No Wrap', 'shop-ready' ),
                    'unset'        => esc_html__( 'Unset', 'shop-ready' ),
                    'normal'       => esc_html__( 'None', 'shop-ready' ),
                    'inherit'      => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'flex-wrap: {{VALUE}};',
                ],
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
            ]

        );

        $this->add_responsive_control(
            $widget . '_section_align_section_e_' . $element_name . '_flex_align',
            [
                'label'     => esc_html__( 'Alignment', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'flex-start'    => esc_html__( 'Left', 'shop-ready' ),
                    'flex-end'      => esc_html__( 'Right', 'shop-ready' ),
                    'center'        => esc_html__( 'Center', 'shop-ready' ),
                    'space-around'  => esc_html__( 'Space Around', 'shop-ready' ),
                    'space-between' => esc_html__( 'Space Between', 'shop-ready' ),
                    'space-evenly'  => esc_html__( 'Space Evenly', 'shop-ready' ),
                    ''              => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],

                'selectors' => [
                    $selector => 'justify-content: {{VALUE}};',
                ],
            ]

        );

        $this->add_responsive_control(
            $widget . '_section_align_items_section_e_' . $element_name . '_flex_align',
            [
                'label'     => esc_html__( 'Align Items', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'flex-start' => esc_html__( 'Left', 'shop-ready' ),
                    'flex-end'   => esc_html__( 'Right', 'shop-ready' ),
                    'center'     => esc_html__( 'Center', 'shop-ready' ),
                    'baseline'   => esc_html__( 'Baseline', 'shop-ready' ),
                    ''           => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],

                'selectors' => [
                    $selector => 'align-items: {{VALUE}};',
                ],
            ]

        );

        // grid

        $this->add_responsive_control(
            $widget . '_section_align_items_section_e_' . $element_name . '_grid_align_items',
            [
                'label'     => esc_html__( 'Place Items', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'left',
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['grid', 'inline-grid']],
                'options'   => [
                    'start'                => esc_html__( 'Left/ Start', 'shop-ready' ),
                    'end'                  => esc_html__( 'Right / End', 'shop-ready' ),
                    'center'               => esc_html__( 'Center', 'shop-ready' ),
                    'center start'         => esc_html__( 'center Left', 'shop-ready' ),
                    'center end'           => esc_html__( 'center end', 'shop-ready' ),
                    'center stretch'       => esc_html__( 'center stretch', 'shop-ready' ),
                    'end space-between'    => esc_html__( 'end space-between', 'shop-ready' ),
                    'start space-between'  => esc_html__( 'left space-between', 'shop-ready' ),
                    'center space-between' => esc_html__( 'center space-between', 'shop-ready' ),
                    'center space-evenly'  => esc_html__( 'center space-evenly', 'shop-ready' ),
                    'start space-evenly'   => esc_html__( 'start space-evenly', 'shop-ready' ),
                    'end space-evenly'     => esc_html__( 'end space-evenly', 'shop-ready' ),

                    ''                     => esc_html__( 'default', 'shop-ready' ),
                ],

                'selectors' => [
                    $selector => 'place-items: {{VALUE}};',
                ],
            ]

        );

        $this->add_responsive_control(
            $widget . '_section_align_items_section_e_' . $element_name . '_grid_align_place_content',
            [
                'label'     => esc_html__( 'Place Content', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'center',
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['grid', 'inline-grid']],
                'options'   => [
                    'start'                => esc_html__( 'Start / Left', 'shop-ready' ),
                    'end'                  => esc_html__( 'Right / End', 'shop-ready' ),
                    'center'               => esc_html__( 'Center', 'shop-ready' ),
                    'center start'         => esc_html__( 'center Left', 'shop-ready' ),
                    'center end'           => esc_html__( 'center end', 'shop-ready' ),
                    'center stretch'       => esc_html__( 'center stretch', 'shop-ready' ),
                    'end space-between'    => esc_html__( 'end space-between', 'shop-ready' ),
                    'start space-between'  => esc_html__( 'left space-between', 'shop-ready' ),
                    'center space-between' => esc_html__( 'center space-between', 'shop-ready' ),
                    'center space-evenly'  => esc_html__( 'center space-evenly', 'shop-ready' ),
                    'start space-evenly'   => esc_html__( 'start space-evenly', 'shop-ready' ),
                    'end space-evenly'     => esc_html__( 'end space-evenly', 'shop-ready' ),

                    ''                     => esc_html__( 'default', 'shop-ready' ),
                ],

                'selectors' => [
                    $selector => 'place-content: {{VALUE}};',
                ],
            ]

        );

        $this->add_responsive_control(
            $widget . '_section_align_items_section_e_' . $element_name . '_grid_justify_items_align',
            [
                'label'     => esc_html__( 'Place Self Column', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'left',
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['inline-grid', 'initial']],
                'options'   => [
                    'start auto'           => esc_html__( 'Start / Left', 'shop-ready' ),
                    'end normal'           => esc_html__( 'End / Right', 'shop-ready' ),
                    'center normal'        => esc_html__( 'Center', 'shop-ready' ),
                    'baseline normal'      => esc_html__( 'Baseline', 'shop-ready' ),
                    'stretch auto'         => esc_html__( 'Stretch', 'shop-ready' ),
                    'first baseline auto'  => esc_html__( 'First Base', 'shop-ready' ),
                    'last baseline normal' => esc_html__( 'last baseline normal', 'shop-ready' ),
                    'space-between'        => esc_html__( 'space-between', 'shop-ready' ),
                    ''                     => esc_html__( 'inherit', 'shop-ready' ),
                ],

                'selectors' => [
                    $selector => 'place-self: {{VALUE}};',
                ],
            ]

        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_grid_cols_gap',
            [
                'label'      => esc_html__( 'Columns Gap', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['grid', 'inline-grid']],
                'size_units' => ['px'],
                'range'      => [

                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'column-gap: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_grid_row_gap',
            [
                'label'      => esc_html__( 'Row Gap', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['grid', 'inline-grid']],
                'size_units' => ['px'],
                'range'      => [

                    'px' => [
                        'min'  => 0,
                        'max'  => 500,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'row-gap: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_grid_col',
            [
                'label'      => esc_html__( 'Column', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['grid', 'inline-grid']],
                'size_units' => ['px'],
                'range'      => [

                    'px' => [
                        'min'  => 0,
                        'max'  => 10,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'grid-template-columns: repeat( {{SIZE}}, 1fr);',

                ],
            ]
        );


        $this->end_controls_section();
        /*----------------------------
    ELEMENT__STYLE END
    -----------------------------*/
    }

    public function box_layout( $atts ) {

        $atts_variable = shortcode_atts(
            [
                'title'        => esc_html__( 'Box Layout', 'shop-ready' ),
                'slug'         => '_layout_style',
                'element_name' => '__mangocube__',
                'selector'     => '{{WRAPPER}} ',
                'condition'    => '',

            ], $atts );

        extract( $atts_variable );

        $widget = $this->get_name() . '_' . shop_ready_heading_camelize( $slug );

        $tab_start_section_args = [
            'label' => $title,
            'tab'   => Controls_Manager::TAB_LAYOUT,
        ];

        if ( is_array( $condition ) ) {
            $tab_start_section_args['condition'] = $condition;
        }

        /*----------------------------
        ELEMENT__STYLE
        -----------------------------*/
        $this->start_controls_section(
            $widget . '_style_section',
            $tab_start_section_args
        );

        $this->add_responsive_control(
            $widget . '_section___section_show_hide_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Display', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'flex'          => esc_html__( 'Flex Layout', 'shop-ready' ),
                    'inherit'       => esc_html__( 'Flex Child Layout', 'shop-ready' ),
                    'inline-flex'   => esc_html__( 'Inline Flex Layout', 'shop-ready' ),
                    'block'         => esc_html__( 'Block Layout', 'shop-ready' ),
                    'inline-block'  => esc_html__( 'Inline Layout', 'shop-ready' ),
                    'grid'          => esc_html__( 'Grid Layout', 'shop-ready' ),
                    'inline-grid'   => esc_html__( 'Grid Inline Layout', 'shop-ready' ),
                    'initial'       => esc_html__( 'Grid Child Layout', 'shop-ready' ),
                    'table-caption' => esc_html__( 'Table Layout', 'shop-ready' ),
                    'flow-root'     => esc_html__( 'Flow Layout', 'shop-ready' ),
                    'none'          => esc_html__( 'None', 'shop-ready' ),
                    ''              => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'display: {{VALUE}};',
                ],
            ]

        );

        $this->add_responsive_control(
            $widget . '_section___section_flex_direction_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Flex Direction', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'default'   => '',
                'options'   => [
                    'column'         => esc_html__( 'Column', 'shop-ready' ),
                    'row'            => esc_html__( 'Row', 'shop-ready' ),
                    'column-reverse' => esc_html__( 'Column Reverse', 'shop-ready' ),
                    'row-reverse'    => esc_html__( 'Row Reverse', 'shop-ready' ),
                    'revert'         => esc_html__( 'Revert', 'shop-ready' ),
                    'none'           => esc_html__( 'None', 'shop-ready' ),
                    ''               => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'flex-direction: {{VALUE}};',
                ],

            ]

        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_basis',
            [
                'label'      => esc_html__( 'Item Width', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['inherit']],
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],
                    '%'  => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'flex-basis: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_grow',
            [
                'label'      => esc_html__( 'Item Grow', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex', 'inherit']],
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'flex-grow: {{SIZE}}',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_shrink',
            [
                'label'      => esc_html__( 'Item Shrink', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex', 'inherit']],
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'flex-shrink: {{SIZE}}',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_order',
            [
                'label'      => esc_html__( 'Item Order', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['inherit']],
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => -30,
                        'max'  => 100,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'order: {{SIZE}}',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_gap',
            [
                'label'      => esc_html__( 'Gap', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'gap: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . '_section___section_flex_wrap_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Flex Wrap', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'wrap',
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'options'   => [
                    'wrap'         => esc_html__( 'Wrap', 'shop-ready' ),
                    'wrap-reverse' => esc_html__( 'Wrap Reverse', 'shop-ready' ),
                    'nowrap'       => esc_html__( 'No Wrap', 'shop-ready' ),
                    'unset'        => esc_html__( 'Unset', 'shop-ready' ),
                    'normal'       => esc_html__( 'None', 'shop-ready' ),
                    'inherit'      => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'flex-wrap: {{VALUE}};',
                ],

            ]

        );

        $this->add_responsive_control(
            $widget . '_section_align_section_e_' . $element_name . '_flex_align',
            [
                'label'     => esc_html__( 'Alignment', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'flex-start',
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'options'   => [
                    'flex-start'    => esc_html__( 'Left', 'shop-ready' ),
                    'flex-end'      => esc_html__( 'Right', 'shop-ready' ),
                    'center'        => esc_html__( 'Center', 'shop-ready' ),
                    'space-around'  => esc_html__( 'Space Around', 'shop-ready' ),
                    'space-between' => esc_html__( 'Space Between', 'shop-ready' ),
                    'space-evenly'  => esc_html__( 'Space Evenly', 'shop-ready' ),
                    ''              => esc_html__( 'inherit', 'shop-ready' ),
                ],

                'selectors' => [
                    $selector => 'justify-content: {{VALUE}};',
                ],
            ]

        );

        $this->add_responsive_control(
            $widget . '_section_align_items_section_e_' . $element_name . '_flex_align',
            [
                'label'     => esc_html__( 'Align Items', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'left',
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'options'   => [
                    'flex-start' => esc_html__( 'Left', 'shop-ready' ),
                    'flex-end'   => esc_html__( 'Right', 'shop-ready' ),
                    'center'     => esc_html__( 'Center', 'shop-ready' ),
                    'baseline'   => esc_html__( 'Baseline', 'shop-ready' ),
                    ''           => esc_html__( 'inherit', 'shop-ready' ),
                ],

                'selectors' => [
                    $selector => 'align-items: {{VALUE}};',
                ],
            ]

        );
        // grid

        $this->add_responsive_control(
            $widget . '_section_al_items_section_e_' . $element_name . '_grid_align_items',
            [
                'label'     => esc_html__( 'Place Items', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'left',
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['grid', 'inline-grid']],
                'options'   => [
                    'start'                => esc_html__( 'Left/ Start', 'shop-ready' ),
                    'end'                  => esc_html__( 'Right / End', 'shop-ready' ),
                    'center'               => esc_html__( 'Center', 'shop-ready' ),
                    'center start'         => esc_html__( 'center Left', 'shop-ready' ),
                    'center end'           => esc_html__( 'center end', 'shop-ready' ),
                    'center stretch'       => esc_html__( 'center stretch', 'shop-ready' ),
                    'end space-between'    => esc_html__( 'end space-between', 'shop-ready' ),
                    'start space-between'  => esc_html__( 'left space-between', 'shop-ready' ),
                    'center space-between' => esc_html__( 'center space-between', 'shop-ready' ),
                    'center space-evenly'  => esc_html__( 'center space-evenly', 'shop-ready' ),
                    'start space-evenly'   => esc_html__( 'start space-evenly', 'shop-ready' ),
                    'end space-evenly'     => esc_html__( 'end space-evenly', 'shop-ready' ),

                    ''                     => esc_html__( 'default', 'shop-ready' ),
                ],

                'selectors' => [
                    $selector => 'place-items: {{VALUE}};',
                ],
            ]

        );

        $this->add_responsive_control(
            $widget . '_section_al_items_section_e_' . $element_name . '_grid_align_place_content',
            [
                'label'     => esc_html__( 'Place Content', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'center',
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['grid', 'inline-grid']],
                'options'   => [
                    'start'                => esc_html__( 'Start / Left', 'shop-ready' ),
                    'end'                  => esc_html__( 'Right / End', 'shop-ready' ),
                    'center'               => esc_html__( 'Center', 'shop-ready' ),
                    'center start'         => esc_html__( 'center Left', 'shop-ready' ),
                    'center end'           => esc_html__( 'center end', 'shop-ready' ),
                    'center stretch'       => esc_html__( 'center stretch', 'shop-ready' ),
                    'end space-between'    => esc_html__( 'end space-between', 'shop-ready' ),
                    'start space-between'  => esc_html__( 'left space-between', 'shop-ready' ),
                    'center space-between' => esc_html__( 'center space-between', 'shop-ready' ),
                    'center space-evenly'  => esc_html__( 'center space-evenly', 'shop-ready' ),
                    'start space-evenly'   => esc_html__( 'start space-evenly', 'shop-ready' ),
                    'end space-evenly'     => esc_html__( 'end space-evenly', 'shop-ready' ),

                    ''                     => esc_html__( 'default', 'shop-ready' ),
                ],

                'selectors' => [
                    $selector => 'place-content: {{VALUE}};',
                ],
            ]

        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_grid_cols_gap',
            [
                'label'      => esc_html__( 'Column Gap', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['initial', 'grid', 'inline-grid']],
                'size_units' => ['px'],
                'range'      => [

                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'column-gap: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_grid_row_gap',
            [
                'label'      => esc_html__( 'Row Gap', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['grid', 'inline-grid']],
                'size_units' => ['px'],
                'range'      => [

                    'px' => [
                        'min'  => 0,
                        'max'  => 500,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'row-gap: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_grid_col',
            [
                'label'      => esc_html__( 'Column', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['grid', 'inline-grid', 'initial']],
                'size_units' => ['px'],
                'range'      => [

                    'px' => [
                        'min'  => 0,
                        'max'  => 10,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'grid-template-columns: repeat( {{SIZE}}, 1fr);',

                ],
            ]
        );

        $this->add_control(
            $widget . '_section___section_popover_' . $element_name . '_position',
            [
                'label'        => esc_html__( 'Position', 'shop-ready' ),
                'type'         => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label_off'    => esc_html__( 'Default', 'shop-ready' ),
                'label_on'     => esc_html__( 'Custom', 'shop-ready' ),
                'return_value' => 'yes',
            ]
        );

        $this->start_popover();
        $this->add_responsive_control(
            $widget . '_section__' . $element_name . '_position_type',
            [
                'label'     => esc_html__( 'Position', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => '',
                'options'   => [
                    'fixed'    => esc_html__( 'Fixed', 'shop-ready' ),
                    'absolute' => esc_html__( 'Absolute', 'shop-ready' ),
                    'relative' => esc_html__( 'Relative', 'shop-ready' ),
                    'sticky'   => esc_html__( 'Sticky', 'shop-ready' ),
                    'static'   => esc_html__( 'Static', 'shop-ready' ),
                    'inherit'  => esc_html__( 'inherit', 'shop-ready' ),
                    ''         => esc_html__( 'none', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'position: {{VALUE}};',

                ],

            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_position_left',
            [
                'label'      => esc_html__( 'Position Left', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => -5000,
                        'max'  => 3000,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'left: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_position_top',
            [
                'label'      => esc_html__( 'Position Top', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => -3000,
                        'max'  => 3000,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'top: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_position_bottom',
            [
                'label'      => esc_html__( 'Position Bottom', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => -2500,
                        'max'  => 3000,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'bottom: {{SIZE}}{{UNIT}};',

                ],
            ]
        );
        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_position_right',
            [
                'label'      => esc_html__( 'Position Right', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => -2600,
                        'max'  => 3000,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'right: {{SIZE}}{{UNIT}};',

                ],
            ]
        );
        $this->end_popover();

        $this->add_control(
            $widget . 'main_section_' . $element_name . '_rbox_popover_section_sizen',
            [
                'label'        => esc_html__( 'Box Size', 'shop-ready' ),
                'type'         => \Elementor\Controls_Manager::POPOVER_TOGGLE,
                'label_off'    => esc_html__( 'Default', 'shop-ready' ),
                'label_on'     => esc_html__( 'Custom', 'shop-ready' ),
                'return_value' => 'yes',

            ]
        );

        $this->start_popover();

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_section__width',
            [
                'label'      => esc_html__( 'Width', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'vw'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 3000,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'width: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_r_container_height',
            [
                'label'      => esc_html__( 'Height', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'vh'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 3000,
                        'step' => 5,
                    ],
                    '%'  => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors'  => [
                    $selector => 'height: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->end_popover();

        $this->end_controls_section();
        /*----------------------------
    ELEMENT__STYLE END
    -----------------------------*/
    }
    public function box_layout_child( $atts ) {

        $atts_variable = shortcode_atts(
            [
                'title'        => esc_html__( 'Box Layout', 'shop-ready' ),
                'slug'         => '_layout_style',
                'element_name' => '__mangocube__',
                'selector'     => '{{WRAPPER}} ',
                'condition'    => '',

            ], $atts );

        extract( $atts_variable );

        $widget = $this->get_name() . '_' . shop_ready_heading_camelize( $slug );

        $tab_start_section_args = [
            'label' => $title,
            'tab'   => Controls_Manager::TAB_LAYOUT,
        ];

        if ( is_array( $condition ) ) {
            $tab_start_section_args['condition'] = $condition;
        }

        /*----------------------------
        ELEMENT__STYLE
        -----------------------------*/
        $this->start_controls_section(
            $widget . '_style_section',
            $tab_start_section_args
        );

        $this->add_responsive_control(
            $widget . '_section___section_show_hide_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Display', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'inherit',
                'options'   => [
                    'inherit'      => esc_html__( 'Flex Child Layout', 'shop-ready' ),
                    'flex'         => esc_html__( 'Flex Layout', 'shop-ready' ),
                    'inline-flex'  => esc_html__( 'Inline Flex Layout', 'shop-ready' ),
                    'block'        => esc_html__( 'Block Layout', 'shop-ready' ),
                    'inline-block' => esc_html__( 'Inline Layout', 'shop-ready' ),
                    'none'         => esc_html__( 'None', 'shop-ready' ),
                    ''             => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'display: {{VALUE}};',
                ],
            ]

        );

        $this->add_responsive_control(
            $widget . '_section___section_flex_direction_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Flex Direction', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'default'   => '',
                'options'   => [
                    'column'         => esc_html__( 'Column', 'shop-ready' ),
                    'row'            => esc_html__( 'Row', 'shop-ready' ),
                    'column-reverse' => esc_html__( 'Column Reverse', 'shop-ready' ),
                    'row-reverse'    => esc_html__( 'Row Reverse', 'shop-ready' ),
                    'revert'         => esc_html__( 'Revert', 'shop-ready' ),
                    'none'           => esc_html__( 'None', 'shop-ready' ),
                    ''               => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'flex-direction: {{VALUE}};',
                ],

            ]

        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_basis',
            [
                'label'      => esc_html__( 'Item Flex Width', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['inherit']],
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],
                    '%'  => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'flex-basis: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_widthss',
            [
                'label'      => esc_html__( 'Item Width', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
               
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],
                    '%'  => [
                        'min'  => 0,
                        'max'  => 100,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'width: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_grow',
            [
                'label'      => esc_html__( 'Item Grow', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex', 'inherit']],
                'size_units' => ['px', '%'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'flex-grow: {{SIZE}}',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_shrink',
            [
                'label'      => esc_html__( 'Item Shrink', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex', 'inherit']],
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'flex-shrink: {{SIZE}}',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_order',
            [
                'label'      => esc_html__( 'Item Order', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['inherit']],
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => -30,
                        'max'  => 100,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'order: {{SIZE}}',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . 'main_section_' . $element_name . '_flex_gap',
            [
                'label'      => esc_html__( 'Gap', 'shop-ready' ),
                'type'       => Controls_Manager::SLIDER,
                'condition'  => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min'  => 0,
                        'max'  => 800,
                        'step' => 1,
                    ],

                ],

                'selectors'  => [
                    $selector => 'gap: {{SIZE}}{{UNIT}};',

                ],
            ]
        );

        $this->add_responsive_control(
            $widget . '_section___section_flex_wrap_' . $element_name . '_display',
            [
                'label'     => esc_html__( 'Flex Wrap', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'wrap',
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'options'   => [
                    'wrap'         => esc_html__( 'Wrap', 'shop-ready' ),
                    'wrap-reverse' => esc_html__( 'Wrap Reverse', 'shop-ready' ),
                    'nowrap'       => esc_html__( 'No Wrap', 'shop-ready' ),
                    'unset'        => esc_html__( 'Unset', 'shop-ready' ),
                    'normal'       => esc_html__( 'None', 'shop-ready' ),
                    'inherit'      => esc_html__( 'inherit', 'shop-ready' ),
                ],
                'selectors' => [
                    $selector => 'flex-wrap: {{VALUE}};',
                ],

            ]

        );

        $this->add_responsive_control(
            $widget . '_section_align_section_e_' . $element_name . '_flex_align',
            [
                'label'     => esc_html__( 'Alignment', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'flex-start',
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'options'   => [
                    'flex-start'    => esc_html__( 'Left', 'shop-ready' ),
                    'flex-end'      => esc_html__( 'Right', 'shop-ready' ),
                    'center'        => esc_html__( 'Center', 'shop-ready' ),
                    'space-around'  => esc_html__( 'Space Around', 'shop-ready' ),
                    'space-between' => esc_html__( 'Space Between', 'shop-ready' ),
                    'space-evenly'  => esc_html__( 'Space Evenly', 'shop-ready' ),
                    ''              => esc_html__( 'inherit', 'shop-ready' ),
                ],

                'selectors' => [
                    $selector => 'justify-content: {{VALUE}};',
                ],
            ]

        );

        $this->add_responsive_control(
            $widget . '_section_align_items_section_e_' . $element_name . '_flex_align',
            [
                'label'     => esc_html__( 'Align Items', 'shop-ready' ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'default'   => 'left',
                'condition' => [$widget . '_section___section_show_hide_' . $element_name . '_display' => ['flex', 'inline-flex']],
                'options'   => [
                    'flex-start' => esc_html__( 'Left', 'shop-ready' ),
                    'flex-end'   => esc_html__( 'Right', 'shop-ready' ),
                    'center'     => esc_html__( 'Center', 'shop-ready' ),
                    'baseline'   => esc_html__( 'Baseline', 'shop-ready' ),
                    ''           => esc_html__( 'inherit', 'shop-ready' ),
                ],

                'selectors' => [
                    $selector => 'align-items: {{VALUE}};',
                ],
            ]

        );

        $this->end_controls_section();
        /*----------------------------
    ELEMENT__STYLE END
    -----------------------------*/
    }

}