<?php
namespace Shop_Ready\base\elementor\query\Controls;

use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;

class Generel_Controls {
    public function register() {

        add_action( 'shop_ready_section_general_tab', [ $this, 'settings_section' ], 10, 2 );
        add_action( 'shop_ready_section_product_minimum_general_tab', [ $this, 'product_minimum_general_tab' ], 10, 2 );
    }

    public function settings_section( $ele, $widget ) {

        $ele->start_controls_section(
            'section_general_tab',
            [
                'label' => esc_html__( 'General', 'shop-ready' ),
            ]
        );

        $ele->add_control(
            'post_count',
            [
                'label'   => esc_html__( 'Count', 'shop-ready' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => '6',
            ]
        );

        $ele->add_control(
            'post_title_crop',
            [
                'label'   => esc_html__( 'Title crop', 'shop-ready' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => '10',
            ]
        );

        $ele->add_control(
            'show_content',
            [
                'label'     => esc_html__( 'Show content', 'shop-ready' ),
                'type'      => Controls_Manager::SWITCHER,
                'label_on'  => esc_html__( 'Yes', 'shop-ready' ),
                'label_off' => esc_html__( 'No', 'shop-ready' ),
                'default'   => 'yes',
            ]
        );

        $ele->add_control(
            'post_content_crop',
            [
                'label'   => esc_html__( 'Content crop', 'shop-ready' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => '18',
            ]
        );

        $ele->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'        => 'product_image_size',
                'exclude'     => [],
                'default'     => 'medium',
                'label_block' => true,
            ]
        );

        $ele->add_control(
            'show_date',
            [
                'label'     => esc_html__( 'Show Date', 'shop-ready' ),
                'type'      => Controls_Manager::SWITCHER,
                'label_on'  => esc_html__( 'Yes', 'shop-ready' ),
                'label_off' => esc_html__( 'No', 'shop-ready' ),
                'default'   => 'yes',
            ]
        );

        $ele->add_control(
            'show_cat',
            [
                'label'     => esc_html__( 'Show Category', 'shop-ready' ),
                'type'      => Controls_Manager::SWITCHER,
                'label_on'  => esc_html__( 'Yes', 'shop-ready' ),
                'label_off' => esc_html__( 'No', 'shop-ready' ),
                'default'   => 'yes',
            ]
        );

        $ele->add_control(
            'show_author',
            [
                'label'     => esc_html__( 'Show Author', 'shop-ready' ),
                'type'      => Controls_Manager::SWITCHER,
                'label_on'  => esc_html__( 'Yes', 'shop-ready' ),
                'label_off' => esc_html__( 'No', 'shop-ready' ),
                'default'   => 'yes',
            ]
        );

        $ele->add_control(
            'show_author_img',
            [
                'label'     => esc_html__( 'Show Author image', 'shop-ready' ),
                'type'      => Controls_Manager::SWITCHER,
                'label_on'  => esc_html__( 'Yes', 'shop-ready' ),
                'label_off' => esc_html__( 'No', 'shop-ready' ),
                'default'   => 'no',
            ]
        );

        $ele->add_control(
            'show_readmore',
            [
                'label'     => esc_html__( 'Show Readmore', 'shop-ready' ),
                'type'      => Controls_Manager::SWITCHER,
                'label_on'  => esc_html__( 'Yes', 'shop-ready' ),
                'label_off' => esc_html__( 'No', 'shop-ready' ),
                'default'   => 'yes',
            ]
        );

        $ele->end_controls_section();
    }

    public function product_minimum_general_tab( $ele, $widget ) {

        $ele->start_controls_section(
            'section_general_tab',
            [
                'label' => esc_html__( 'General', 'shop-ready' ),
            ]
        );

        $ele->add_control(
            'post_count',
            [
                'label'   => esc_html__( 'Count', 'shop-ready' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => '6',
            ]
        );

        $ele->add_control(
            'post_title_crop',
            [
                'label'   => esc_html__( 'Title crop', 'shop-ready' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => '10',
            ]
        );

        $ele->add_control(
            'show_content',
            [
                'label'     => esc_html__( 'Show content', 'shop-ready' ),
                'type'      => Controls_Manager::SWITCHER,
                'label_on'  => esc_html__( 'Yes', 'shop-ready' ),
                'label_off' => esc_html__( 'No', 'shop-ready' ),
                'default'   => 'yes',
            ]
        );

        $ele->add_control(
            'post_content_crop',
            [
                'label'   => esc_html__( 'Content crop', 'shop-ready' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => '18',
            ]
        );

        $ele->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name'        => 'product_image_size',
                'exclude'     => [],
                'default'     => 'medium',
                'label_block' => true,
            ]
        );

        $ele->end_controls_section();
    }

}