<?php
namespace QSDarkMode\Base;

use QSDarkMode\Base\BaseController;

class SettingsLinks extends BaseController
{
	public function register() {

        add_filter( 'plugin_row_meta', [ $this, 'plugin_row_meta' ], 10, 2 );
        add_filter( 'plugin_action_links_'.QS_DARK_MODE_PLUGIN_BASE, [ $this ,'add_plugin_page_settings_link'] );
       
    }

    function add_plugin_page_settings_link( $links ) {
	 
        $links[] = '<a href="' .
            admin_url( 'admin.php?page='.QS_DARK_MODE_SETTING_PATH ) .
            '">' . esc_html__('Settings','qs-dark-mode') . '</a>';

            $installed_plugins = array_keys( get_plugins() );
       
            if ( !in_array('qs-dark-mode-pro/qs-dark-mode-pro.php',$installed_plugins) ) {
    
                $links[] = '<a style="color: #325DF6; font-weight: bold;"  href="' .
                esc_url( QS_DARK_MODE_DEMO_URL ) .
                '">' . esc_html__('Go Pro','qs-dark-mode') . '</a>';
            }

        return $links;
    
    }

    public function plugin_row_meta( $plugin_meta, $plugin_file ) {

		if ( QS_DARK_MODE_PLUGIN_BASE === $plugin_file ) {
			$row_meta = [
				'docs' => '<a href="'.QS_DARK_MODE_DEMO_URL.'docs/dark-mode'.'" aria-label="' . esc_attr__( 'View Documentation', 'qs-dark-mode' ) . '" target="_blank">' . esc_html__( 'Docs & FAQs', 'qs-dark-mode' ) . '</a>',

				'plugin-demos' => '<a href="'.QS_DARK_MODE_DEMO_URL.'" aria-label="' . esc_attr__( 'View Demos', 'qs-dark-mode' ) . '" target="_blank">' . esc_html__( 'Demos', 'qs-dark-mode' ) . '</a>',

				'plugin-support' => '<a href="'.QS_DARK_MODE_DEMO_URL.'support" aria-label="' . esc_attr__( 'Get Support', 'qs-dark-mode' ) . '" target="_blank">' . esc_html__( 'Get Support', 'qs-dark-mode' ) . '</a>',
			];

			$plugin_meta = array_merge( $plugin_meta, $row_meta );
		}

		return $plugin_meta;
	}
}