<?php
// Adds widget: (Theme) Newsletter
class Applic_Newsletter_Widget extends WP_Widget {

    function __construct() {
        parent::__construct(
            'themenewsletter_widget',
            esc_html__( '(Theme) Newsletter', 'applic' )
        );
    }

    private $widget_fields = array(
        array(
            'label' => 'Message',
            'id' => 'applic_nl_m',
            'default' => 'Lorem ipsum dolor sit amet consec tetur adipisicing elit sed modo',
            'type' => 'text',
        ),
        array(
            'label' => 'Action URL',
            'id' => 'applic_nl_url',
            'type' => 'url',
            'default' => 'https://sampadinfo.us19.list-manage.com/subscribe/post?u=11ff52ac0862b78f48b4975c7&amp;id=c8deac38d3',
        ),
        array(
            'label' => 'Button Label',
            'id' => 'applic_nl_btn',
            'default' => 'subscribe',
            'type' => 'text',
        ),
    );

    public function widget( $args, $instance ) {
        echo wp_kses_post($args['before_widget']);

        if ( ! empty( $instance['title'] ) ) {
            echo wp_kses_post($args['before_title']) . apply_filters( 'widget_title', $instance['title'] ) . wp_kses_post($args['after_title']);
        }
        ?>
        <p><?php echo esc_html($instance['applic_nl_m']); ?></p>
        <div class="footer-subscriber-form">
            <form TARGET="_blank" action="<?php echo esc_url($instance['applic_nl_url']); ?>" method="post">
                <input type="email" name="EMAIL" id="email" placeholder="mail@example.com">
                <button type="submit"><?php echo esc_html($instance['applic_nl_btn']); ?></button>
            </form>
        </div>
        <?php
        echo wp_kses_post($args['after_widget']);
    }

    public function field_generator( $instance ) {
        $output = '';
        foreach ( $this->widget_fields as $widget_field ) {
            $default = '';
            if ( isset($widget_field['default']) ) {
                $default = $widget_field['default'];
            }
            $widget_value = ! empty( $instance[$widget_field['id']] ) ? $instance[$widget_field['id']] : esc_html__( $default, 'applic' );
            switch ( $widget_field['type'] ) {
                default:
                    $output .= '<p>';
                    $output .= '<label for="'.esc_attr( $this->get_field_id( $widget_field['id'] ) ).'">'.esc_attr( $widget_field['label'], 'applic' ).':</label> ';
                    $output .= '<input class="widefat" id="'.esc_attr( $this->get_field_id( $widget_field['id'] ) ).'" name="'.esc_attr( $this->get_field_name( $widget_field['id'] ) ).'" type="'.$widget_field['type'].'" value="'.esc_attr( $widget_value ).'">';
                    $output .= '</p>';
            }
        }
        echo $output;
    }

    public function form( $instance ) {
        $title = ! empty( $instance['title'] ) ? $instance['title'] : esc_html__( '', 'applic' );
        ?>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>"><?php esc_attr_e( 'Title:', 'applic' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'title' ) ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
        </p>
        <?php
        $this->field_generator( $instance );
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        foreach ( $this->widget_fields as $widget_field ) {
            switch ( $widget_field['type'] ) {
                default:
                    $instance[$widget_field['id']] = ( ! empty( $new_instance[$widget_field['id']] ) ) ? strip_tags( $new_instance[$widget_field['id']] ) : '';
            }
        }
        return $instance;
    }
}

function register_applic_newsletter_widget() {
    register_widget( 'Applic_Newsletter_Widget' );
}
add_action( 'widgets_init', 'register_applic_newsletter_widget' );