<?php

// Enqueue additional admin scripts
add_action('admin_enqueue_scripts', 'applic_wdscript');
function applic_wdscript() {
    wp_enqueue_media();
}

// Adds widget: Footer Left
class Applic_aboutus extends WP_Widget {

	function __construct() {
		parent::__construct(
			'about_us',
			esc_html__( '(Theme) About Us', 'applic' )
		);
		add_action( 'admin_footer', array( $this, 'media_fields' ) );
		add_action( 'customize_controls_print_footer_scripts', array( $this, 'media_fields' ) );
	}

	public function widget( $args, $instance ) {
        $s = ! empty( $instance['search_form'] ) ? '1' : '0';
		echo wp_kses_post($args['before_widget']);
        ?>
        <div class="footer-logo">
            <a href="<?php echo home_url( '/' ); ?>"><img src="<?php echo esc_url($instance['image_uri']); ?>" alt=""></a>
        </div>
        <p><?php echo esc_html($instance['content']); ?></p>
        <?php if ( $s ) { ?>
            <div class="footer-search-form">
                <form role="search" action="<?php echo home_url('/'); ?>" method="get">
                    <input type="search"
                           placeholder="<?php echo esc_attr_x('Search Here.', 'placeholder') ?>"
                           value="<?php echo get_search_query() ?>" name="s" id="s"
                    />
                    <button type="submit"><i class="dripicons-search"></i></button>
                </form>
            </div>
            <?php
        }
		echo wp_kses_post($args['after_widget']);
	}

	public function media_fields() {
		?><script>
            jQuery(document).ready(function ($) {
                function media_upload(button_selector) {
                    var _custom_media = true,
                        _orig_send_attachment = wp.media.editor.send.attachment;
                    $('body').on('click', button_selector, function () {
                        var button_id = $(this).attr('id');
                        wp.media.editor.send.attachment = function (props, attachment) {
                            if (_custom_media) {
                                $('.' + button_id + '_img').attr('src', attachment.url);
                                $('.' + button_id + '_url').val(attachment.url);
                            } else {
                                return _orig_send_attachment.apply($('#' + button_id), [props, attachment]);
                            }
                        }
                        wp.media.editor.open($('#' + button_id));
                        return false;
                    });
                }
                media_upload('.js_custom_upload_media');
            });
		</script><?php
	}

    function form($instance) {
        $s_form = isset($instance['search_form']) ? (bool) $instance['search_form'] :false;
        ?>
        <p>
            <label for="<?= $this->get_field_id( 'image_uri' ); ?>"><?php esc_html_e('logo', 'applic'); ?></label>
            <img class="<?= $this->id ?>_img" src="<?= (!empty($instance['image_uri'])) ? $instance['image_uri'] : ''; ?>" style="margin:0;padding:0;max-width:100%;display:block"/>
            <input type="text" class="widefat <?= $this->id ?>_url" name="<?= $this->get_field_name( 'image_uri' ); ?>" value="<?= $instance['image_uri']; ?>" style="margin-top:5px;" />
            <input type="button" id="<?= $this->id ?>" class="button button-primary js_custom_upload_media" value="Upload Image" style="margin-top:5px;" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('text'); ?>"><?php esc_html_e('Content', 'applic'); ?></label><br />
            <textarea rows="5" type="text" name="<?php echo $this->get_field_name('content'); ?>" id="<?php echo $this->get_field_id('content'); ?>" class="widefat"><?php echo $instance['content']; ?></textarea>
        </p>
        <input type="checkbox" class="checkbox" id="<?php echo $this->get_field_id('search_form'); ?>" name="<?php echo $this->get_field_name('search_form'); ?>"<?php checked( $s_form ); ?> />
        <label for="<?php echo $this->get_field_id('search_form'); ?>"><?php _e( 'Show Search Form' ); ?></label><br />
        <?php
    }

    function update($new_instance, $old_instance) {
        $instance = $old_instance;
        $instance['content'] = strip_tags( $new_instance['content'] );
        $instance['image_uri'] = strip_tags( $new_instance['image_uri'] );
        $instance['search_form'] = !empty($new_instance['search_form']) ? 1 : 0;
        return $instance;
    }
}

function register_footerleft_widget() {
	register_widget( 'Applic_aboutus' );
}
add_action( 'widgets_init', 'register_footerleft_widget' );