<?php

// Adds widget: Theme About Me
class Applic_aboutme_Widget extends WP_Widget
{

    function __construct()
    {
        parent::__construct(
            'applic_aboutme_widget',
            esc_html__('(Theme) About Me', 'applic'),
            array(
                'description' => __('Your site’s about me widget.', 'applic'),
                'classname' => 'widget_about'
            ) // Args
        );
        add_action('admin_footer', array($this, 'media_fields'));
        add_action('customize_controls_print_footer_scripts', array($this, 'media_fields'));
    }

    private $widget_fields = array(
        array(
            'label' => 'Author Image',
            'id' => 'author_img',
            'type' => 'media',
        ),
        array(
            'label' => 'Author Name',
            'id' => 'author_name',
            'default' => 'Roberto B. Lukaku',
            'type' => 'text',
        ),
        array(
            'label' => 'Description',
            'id' => 'author_desc',
            'default' => 'We are the Backpack Traveler, your favorite travel assistants! With more interested....',
            'type' => 'textarea',
        ),
        array(
            'label' => 'Facebook URL',
            'id' => 'f_url',
            'default' => '#',
            'type' => 'text',
        ),
        array(
            'label' => 'Twitter URL',
            'id' => 't_url',
            'default' => '#',
            'type' => 'text',
        ),
        array(
            'label' => 'google_plus_url',
            'id' => 'g_p_url',
            'default' => '#',
            'type' => 'text',
        ),
        array(
            'label' => 'Youtube URL',
            'id' => 'y_url',
            'default' => '#',
            'type' => 'text',
        ),
        array(
            'label' => 'Linkedin URL',
            'id' => 'l_url',
            'default' => '#',
            'type' => 'text',
        ),
    );

    public function widget($args, $instance)
    {
        echo wp_kses_post($args['before_widget']);

        if (!empty($instance['title'])) {
            echo $args['before_title'] . apply_filters('widget_title', $instance['title']) . $args['after_title'];
        }
        ?>
        <div class="about-details">
            <?php
            if ($instance['author_img']) {
                echo wp_get_attachment_image($instance['author_img'], 'medium');
            }
            ?>
            <h4><?php echo $instance['author_name']; ?></h4>
            <p><?php echo $instance['author_desc']; ?></p>
            <ul class="social-bookmark">
                <?php if (!empty($instance['f_url'])): ?>
                    <li class="facebook"><a href="<?php echo esc_url($instance['f_url']); ?>"><i
                                    class="fa fa-facebook"></i></a></li>
                <?php endif; ?>
                <?php if (!empty($instance['t_url'])): ?>
                    <li class="twitter"><a href="<?php echo esc_url($instance['t_url']); ?>"><i
                                    class="fa fa-twitter"></i></a></li>
                <?php endif; ?>
                <?php if (!empty($instance['g_p_url'])): ?>
                    <li class="google-plus"><a href="<?php echo esc_url($instance['g_p_url']); ?>"><i
                                    class="fa fa-google-plus"></i></a></li>
                <?php endif; ?>
                <?php if (!empty($instance['y_url'])): ?>
                    <li class="youtube"><a href="<?php echo esc_url($instance['y_url']); ?>"><i
                                    class="fa fa-youtube"></i></a></li>
                <?php endif; ?>
                <?php if (!empty($instance['l_url'])): ?>
                    <li class="linkedin"><a href="<?php echo esc_url($instance['l_url']); ?>"><i
                                    class="fa fa-linkedin"></i></a></li>
                <?php endif; ?>
            </ul>
        </div>

        <?php
        echo wp_kses_post($args['after_widget']);
    }

    public function media_fields()
    {
        ?>
        <script>
            jQuery(document).ready(function ($) {
                if (typeof wp.media !== 'undefined') {
                    var _custom_media = true,
                        _orig_send_attachment = wp.media.editor.send.attachment;
                    $(document).on('click', '.custommedia', function (e) {
                        var send_attachment_bkp = wp.media.editor.send.attachment;
                        var button = $(this);
                        var id = button.attr('id');
                        _custom_media = true;
                        wp.media.editor.send.attachment = function (props, attachment) {
                            if (_custom_media) {
                                $('input#' + id).val(attachment.id);
                                $('span#preview' + id).css('background-image', 'url(' + attachment.url + ')');
                                $('input#' + id).trigger('change');
                            } else {
                                return _orig_send_attachment.apply(this, [props, attachment]);
                            }
                            ;
                        }
                        wp.media.editor.open(button);
                        return false;
                    });
                    $('.add_media').on('click', function () {
                        _custom_media = false;
                    });
                    $(document).on('click', '.remove-media', function () {
                        var parent = $(this).parents('p');
                        parent.find('input[type="media"]').val('').trigger('change');
                        parent.find('span').css('background-image', 'url()');
                    });
                }
            });
        </script><?php
    }

    public function field_generator($instance)
    {
        $output = '';
        foreach ($this->widget_fields as $widget_field) {
            $default = '';
            if (isset($widget_field['default'])) {
                $default = $widget_field['default'];
            }
            $widget_value = !empty($instance[$widget_field['id']]) ? $instance[$widget_field['id']] : esc_html__($default, 'applic');
            switch ($widget_field['type']) {
                case 'media':
                    $media_url = '';
                    if ($widget_value) {
                        $media_url = wp_get_attachment_url($widget_value);
                    }
                    $output .= '<p>';
                    $output .= '<label for="' . esc_attr($this->get_field_id($widget_field['id'])) . '">' . esc_attr($widget_field['label'], 'applic') . ':</label> ';
                    $output .= '<input style="display:none;" class="widefat" id="' . esc_attr($this->get_field_id($widget_field['id'])) . '" name="' . esc_attr($this->get_field_name($widget_field['id'])) . '" type="' . $widget_field['type'] . '" value="' . $widget_value . '">';
                    $output .= '<span id="preview' . esc_attr($this->get_field_id($widget_field['id'])) . '" style="margin-right:10px;border:2px solid #eee;display:block;width: 100px;height:100px;background-image:url(' . $media_url . ');background-size:contain;background-repeat:no-repeat;"></span>';
                    $output .= '<button id="' . $this->get_field_id($widget_field['id']) . '" class="button select-media custommedia">Add Media</button>';
                    $output .= '<input style="width: 19%;" class="button remove-media" id="buttonremove" name="buttonremove" type="button" value="Clear" />';
                    $output .= '</p>';
                    break;
                case 'textarea':
                    $output .= '<p>';
                    $output .= '<label for="' . esc_attr($this->get_field_id($widget_field['id'])) . '">' . esc_attr($widget_field['label'], 'applic') . ':</label> ';
                    $output .= '<textarea class="widefat" id="' . esc_attr($this->get_field_id($widget_field['id'])) . '" name="' . esc_attr($this->get_field_name($widget_field['id'])) . '" rows="6" cols="6" value="' . esc_attr($widget_value) . '">' . $widget_value . '</textarea>';
                    $output .= '</p>';
                    break;
                default:
                    $output .= '<p>';
                    $output .= '<label for="' . esc_attr($this->get_field_id($widget_field['id'])) . '">' . esc_attr($widget_field['label'], 'applic') . ':</label> ';
                    $output .= '<input class="widefat" id="' . esc_attr($this->get_field_id($widget_field['id'])) . '" name="' . esc_attr($this->get_field_name($widget_field['id'])) . '" type="' . $widget_field['type'] . '" value="' . esc_attr($widget_value) . '">';
                    $output .= '</p>';
            }
        }
        echo $output;
    }

    public function form($instance)
    {
        $title = !empty($instance['title']) ? $instance['title'] : esc_html__('', 'applic');
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_attr_e('Title:', 'applic'); ?></label>
            <input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>"
                   name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text"
                   value="<?php echo esc_attr($title); ?>">
        </p>
        <?php
        $this->field_generator($instance);
    }

    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
        foreach ($this->widget_fields as $widget_field) {
            switch ($widget_field['type']) {
                default:
                    $instance[$widget_field['id']] = (!empty($new_instance[$widget_field['id']])) ? strip_tags($new_instance[$widget_field['id']]) : '';
            }
        }
        return $instance;
    }
}

function register_applicaboutme_widget()
{
    register_widget('Applic_aboutme_Widget');
}

add_action('widgets_init', 'register_applicaboutme_widget');