<?php

namespace ApplicCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class Applic_video_area extends Widget_Base {

	public function get_name() {
		return 'applic-video-area';
	}

	public function get_title() {
		return __( 'Video Area', 'applic-core' );
	}

	public function get_icon() {
		return 'eicon-play';
	}

	public function get_categories() {
		return [ 'applic-elements' ];
	}

	protected function _register_controls() {

		/* ------------------------------  Video Area content tab ------------------------------
		-------------------------------------------------------------------------------------*/
		/**
		 * Video Area Markup
		 **/
		$this->start_controls_section(
			'video_markup_id',
			[
				'label' => __( 'Video Area Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style', [
				'label'       => esc_html__( 'Markup Style', 'applic-core' ),
				'type'        => Controls_Manager::SELECT,
				'label_block' => true,
				'options'     => [
					'style_01' => esc_html__( 'Video Presentation', 'applic-core' ),
					'style_02' => esc_html__( 'Video Presentation With Counter', 'applic-core' )
				],
				'default'     => 'style_01'
			]
		);
		$this->end_controls_section(); // End Feature Iamge Markup

		/**
		 * Video Area Section Content
		 **/
		$this->start_controls_section(
			'video_content_id',
			[
				'label' => __( 'Video Section Content', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'v_title',
			[
				'label'       => __( 'Title', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => __( 'Watch Video Presentation', 'applic-core' ),
			]
		);
		$this->add_control(
			'v_subtitle',
			[
				'label'       => __( 'Subtitle', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => __( 'LATEST VIDEO', 'applic-core' ),
				'condition'   => [
					'style' => 'style_02',
				],
			]
		);
		$this->add_control(
			'v_desc',
			[
				'label'       => __( 'Description', 'applic-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default'     => __( 'Lorem ipsum dolor sit amet, consectetur adipisicing elit sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.', 'applic-core' ),
			]
		);
		$this->add_control(
			'v_data_id',
			[
				'label'       => __( 'Video Data ID', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => '7TUOI23spt0',
			]
		);
		$this->end_controls_section(); // end Section content

		/**
		 * Video Area Countdown Content
		 **/
		$this->start_controls_section(
			'video_countdown_id',
			[
				'label'     => __( 'Countdown List', 'applic-core' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'style' => 'style_02',
				],
			]
		);
		$this->add_control(
			'countdown', [
				'label'       => __( 'Countdown List', 'applic-core' ),
				'type'        => Controls_Manager::REPEATER,
				'title_field' => '{{{ title }}}',
				'fields'      => [
					[
						'name'        => 'title',
						'label'       => __( 'Title', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => 'Happy User'
					],
					[
						'name'        => 'number',
						'label'       => __( 'Number', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => '85'
					],
					[
						'name'        => 'currency',
						'label'       => __( 'Currency', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => 'k'
					]
				],
			]
		);
		$this->end_controls_section(); // end Section content


		/*-------------------------------- Section background image -------------------------------*/
		$this->start_controls_section(
			'v_style_id', [
				'label' => __( 'Background', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'v_bg', [
				'label'   => esc_html__( 'Background Image', 'applic-core' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => plugins_url( 'images/video-bg-2.jpg', __FILE__ )
				]
			]
		);

		$this->add_control(
			'v_bg1', [
				'label' => __( 'Background Overlay', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'style' => 'style_01',
				],
			]
		);

		$this->add_control(
			'v_bg_color2', [
				'label' => __( 'Background Overlay 02', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'style' => 'style_01',
				],
				'selectors' => [
					'{{WRAPPER}} .video-promo-area .area-bg::after' => 'background: rgba(0, 0, 0, 0) linear-gradient(180deg, {{v_bg1.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
				],
			]
		);

		$this->add_control(
			'opacity',
			[
				'label' => __( 'Background Opacity', 'applic-core' ),
				'type' => Controls_Manager::SLIDER,
				'condition' => [
					'style' => 'style_01',
				],
				'range' => [
					'px' => [
						'min' => 0.1,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'default' => [
					'size' => 0.8,
				],
				'selectors' => [
					'{{WRAPPER}} .video-promo-area .area-bg::after' => 'opacity: {{SIZE}};',
				],
			]
		);

		$this->end_controls_section();

		/*
        * Video Area Section Title and Subtitle color
        */
		$this->start_controls_section(
			'vido_sec_id',
			[
				'label' => __( 'Section Title & Subtitle Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'v_title_style',
			[
				'label'     => __( 'Title Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .video-promo-area .area-content h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography_v_title',
				
				'selector' => '{{WRAPPER}} .video-promo-area .area-content h3',
			]
		);
		$this->add_control(
			'g_subtitle_style',
			[
				'label'     => __( 'Subtitle Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .video-promo-area .area-content h4' => 'color: {{VALUE}};',
				],
				'condition' => [
					'style' => 'style_02',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'      => 'typography_v_subtitle',
				
				'selector'  => '{{WRAPPER}} .video-promo-area .area-content h4',
				'condition' => [
					'style' => 'style_02',
				],
			]
		);
		$this->add_control(
			'v_desc_style',
			[
				'label'     => __( 'Description Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .video-promo-area .area-content p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography_v_desc',
				
				'selector' => '{{WRAPPER}} .video-promo-area .area-content p',
			]
		);
		$this->end_controls_section();

		/*-------------------------------- Video Option style two -------------------------------*/
		$this->start_controls_section(
			'v_poster_id', [
				'label' => __( 'Video Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'v_poster_bg', [
				'label'     => esc_html__( 'Video Poster Image', 'applic-core' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => [
					'url' => plugins_url( 'images/video-bg.jpg', __FILE__ )
				],
				'condition' => [
					'style' => 'style_02',
				],
			]
		);
		$this->add_control(
			'v_layer_bg', [
				'label'     => esc_html__( 'Background Dotted Layer', 'applic-core' ),
				'type'      => Controls_Manager::MEDIA,
				'default'   => [
					'url' => plugins_url( 'images/dots-layer.png', __FILE__ )
				],
				'condition' => [
					'style' => 'style_02',
				],
			]
		);
		$this->start_controls_tabs( 'tabs_v_button_style' );
		$this->start_controls_tab(
			'v_button_normal',
			[
				'label' => __( 'Normal', 'applic-core' ),
			]
		);
		$this->add_control(
			'v_btn_icon_color', [
				'label'     => __( 'Video Button Icon Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video-button button' => 'color: {{VALUE}}'
				],
			]
		);
		$this->add_control(
			'v_btn_bg_color', [
				'label'     => __( 'Video Button Background Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video-button button' => 'background: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'v_button_hover',
			[
				'label' => __( 'Hover', 'applic-core' ),
			]
		);
		$this->add_control(
			'v_btn_icon_color_h', [
				'label'     => __( 'Video Button Icon Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video-button button:hover' => 'color: {{VALUE}}'
				],
			]
		);

        $this->add_control(
            'bg_color', [
                'label' => __( 'Video Button Background Color', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            'bg_color2', [
                'label' => __( 'Video Button Background Color 02', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .video-button button:hover' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{bg_color.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name'     => 'button_box_shadow',
                'selector' => '{{WRAPPER}} .video-button button:hover',
                'condition' => [
                    'style' => 'style_01',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		/*-------------------------------- Countdown Option style two -------------------------------*/
		$this->start_controls_section(
			'v_count_style_id', [
				'label'     => __( 'Countdown Style', 'applic-core' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					'style' => 'style_02',
				],
			]
		);
		$this->add_control(
			'v_count_title',
			[
				'label'     => __( 'Title Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video-promo-area .single-fun-fact p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography_v_c_t',
				'selector' => '{{WRAPPER}} .video-promo-area .single-fun-fact p',
			]
		);
		$this->add_control(
			'v_count_numb',
			[
				'label'     => __( 'Number Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .video-promo-area .single-fun-fact h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

		if ( $settings['style'] == 'style_01' ) { ?>
            <!--VIDEO PROMO AREA-->
            <section class="video-promo-area section-padding white">
                <div style="background: url(<?php echo esc_url( $settings['v_bg']['url'] ) ?>) no-repeat scroll center center / 100% 100%"
                     class="area-bg"></div>
                <div class="container">
                    <div class="row">
                        <div class="col-md-8 col-md-offset-2 col-lg-8 col-lg-offset-2 col-sm-12 col-xs-12">
                            <div class="area-content center wow fadeInUp">
                                <div class="video-button mb40">
                                    <button class="video-popup h_w" data-video-id="<?php echo esc_attr($settings['v_data_id']); ?>"><i class="fa fa-play"></i>
                                    </button>
                                </div>
                                <h3><?php echo esc_html( $settings['v_title'] ); ?></h3>
                                <p><?php echo esc_html( $settings['v_desc'] ); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--VIDEO PROMO AREA END-->
		<?php } elseif ( $settings['style'] == 'style_02' ) { ?>
            <!--VIDEO PROMO AREA-->
            <section class="video-promo-area section-padding white">
                <div style="background: url(<?php echo esc_url( $settings['v_bg']['url'] ) ?>) no-repeat scroll center center / 100% 100%"
                     class="area-bg"></div>
                <div class="container">
                    <div class="row flex-v-center">
                        <div class="col-md-6 col-lg-6 col-sm-12 col-xs-12">
                            <div class="area-image-content sm-center xs-center sm-mb50 xs-mb50 wow fadeInRight"
                                 data-wow-delay="0.3s">
                                <div class="video-bg-layer" data-parallax='{"x": -50,"y": -50}'><img
                                            src="<?php echo esc_url( $settings['v_layer_bg']['url'] ); ?>" alt=""></div>
                                <img src="<?php echo esc_url( $settings['v_poster_bg']['url'] ); ?>" alt="">
                                <div class="video-button item-center">
                                    <button class="video-popup" data-video-id="<?php echo esc_attr($settings['v_data_id']); ?>"><i class="fa fa-play"></i>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-6 col-sm-12 col-xs-12">
                            <div class="area-content sm-center xs-center wow fadeInRight" data-wow-delay="0.6s">
                                <h4 class="subtitle"><?php echo esc_html( $settings['v_subtitle'] ); ?></h4>
                                <h3><?php echo esc_html( $settings['v_title'] ); ?></h3>
                                <p><?php echo esc_html( $settings['v_desc'] ); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="row">
						<?php
						$d = 0.3;
						foreach ( $settings['countdown'] as $countdown ): ?>
                            <div class="col-md-3 col-sm-6 col-xs-12">
                                <div class="single-fun-fact mt50 wow fadeInRight" data-wow-delay="<?php echo $d; ?>s">
                                    <h3><span class="odometer"
                                              data-count="<?php echo esc_attr( $countdown['number'] ); ?>">00</span><?php echo esc_html( $countdown['currency'] ); ?>
                                    </h3>
                                    <p><?php echo esc_html( $countdown['title'] ); ?></p>
                                </div>
                            </div>
							<?php
							$d = $d + 0.3;
						endforeach; ?>
                    </div>
                </div>
            </section>
            <!--VIDEO PROMO AREA END-->
		<?php }
	}
}
