<?php

namespace ApplicCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class Applic_testimonials extends Widget_Base {

	public function get_name() {
		return 'applic-testimonials';
	}

	public function get_title() {
		return __( 'Testimonials', 'applic-hero' );
	}

	public function get_icon() {
		return ' eicon-testimonial-carousel';
	}

	public function get_categories() {
		return [ 'applic-elements' ];
	}

	protected function _register_controls() {

		/*
		 * Section Content
		 * */
		$this->start_controls_section(
			'sec_id', [
				'label' => __( 'Section Content', 'applic-core' ),
			]
		);
		$this->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'What Our Client’s Say About Us'
			]
		);
		$this->add_control(
			'subtitle', [
				'label'       => esc_html__( 'Subtitle text', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'testimonial'
			]
		);
		$this->end_controls_section(); // End section content

		// ------------------------------ Testimonial items ------------------------------
		$this->start_controls_section(
			'testimonial_sec', [
				'label' => __( 'Testimonial Items', 'applic-core' ),
			]
		);
		$this->add_control(
			'testimonials', [
				'label'       => __( 'Testimonials', 'applic-core' ),
				'type'        => Controls_Manager::REPEATER,
				'title_field' => '{{{ author_name }}}',
				'fields'      => [
					[
						'name'    => 'author_name',
						'label'   => esc_html__( 'Quote Author Name', 'appland-core' ),
						'type'    => Controls_Manager::TEXT,
						'default' => 'Eh Jewel',
					],
					[
						'name'    => 'author_designation',
						'type'    => Controls_Manager::TEXT,
						'label'   => esc_html__( 'Author Designation', 'appland-core' ),
						'default' => 'Web Designer'
					],
					[
						'name'    => 'quote',
						'type'    => Controls_Manager::TEXTAREA,
						'label'   => esc_html__( 'Quote Text', 'appland-core' ),
						'default' => 'Lorem ipsum dolor sit amet consectetur adipisicing elit sed do eiusmod temporse incididunt utses labore et dolore magna aliqua. Ut enim minim veniam quis.'
					],
					[
						'name'  => 'author_image',
						'type'  => Controls_Manager::MEDIA,
						'label' => esc_html__( 'Quote Author image', 'appland-core' ),
					],
				],
			]
		);
		$this->end_controls_section();


		/**
		 * Style Tab
		 *
		 * Section Content Style
		 */
        $this->start_controls_section(
            'sec_bg_id', [
                'label' => __( 'Section Background Color', 'applic-core' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'bg_color', [
                'label'     => __( 'Background Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .testmonial-area' => 'background: {{VALUE}};',
                ]
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'sec_color_id', [
				'label' => __( 'Section Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color', [
				'label'     => __( 'Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .area-title h2' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'typography_title',
				'selector' => '{{WRAPPER}} .area-title h2',
			]
		);
		$this->add_control(
			'color_subtitle', [
				'label'     => __( 'Subtitle Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .area-title .subtitle' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'typography_subtitle',
				'selector' => '{{WRAPPER}} .area-title .subtitle',
			]
		);
		$this->end_controls_section();


		/*
		 * Testimonial Content Style
		 * */
		$this->start_controls_section(
			'tes_section', [
				'label' => __( 'Testimonial Content Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'author_color', [
				'label'     => __( 'Author Name Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .testmonial-slider .author-name-and-thumb h4' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'designation_color', [
				'label'     => __( 'Author Designation Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .testmonial-slider .author-name-and-thumb p' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'quote_color', [
				'label'     => __( 'Quote Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .testmonial-slider .author-content p' => 'color: {{VALUE}};',
				]
			]
		);
		$this->start_controls_tabs(
			'owl_nav_tabs'
		);
		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => __( 'Normal', 'applic-core' ),
			]
		);
		$this->add_control(
			'owl_nav_color',
			[
				'label'     => __( 'Owl Navigation Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .owl-carousel .owl-dots > div' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'owl_nav_hover_tab',
			[
				'label' => __( 'Active', 'applic-core' ),
			]
		);
		$this->add_control(
			'owl_nav_color_hover',
			[
				'label'     => __( 'Owl Navigation Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .owl-carousel .owl-dots > div.active' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();
		$quotes   = isset( $settings['testimonials'] ) ? $settings['testimonials'] : '';
		?>
        <style>
            .single-testmonial::after {
                content: url(<?php echo plugin_dir_url( __FILE__ ) . 'images/quote.png'; ?>);
            }
        </style>
        <!--TESTMONIAL AREA-->
        <section class="testmonial-area section-padding fix" id="process">
            <div class="testmonial-layers">
                <div class="testmonial-layer-1" data-parallax='{"y": 200, "smoothness": 100}'><img
                            src="<?php echo plugin_dir_url( __FILE__ ) . 'images/layers-1.png'; ?>" alt="layer_bg_01">
                </div>
                <div class="testmonial-layer-2" data-parallax='{"x": 80}'><img
                            src="<?php echo plugin_dir_url( __FILE__ ) . 'images/layers-2.png'; ?>" alt="layer_bg_02">
                </div>
                <div class="testmonial-layer-3" data-parallax='{"x": -200, "smoothness": 100}'><img
                            src="<?php echo plugin_dir_url( __FILE__ ) . 'images/layers-3.png'; ?>" alt="layer_bg_03">
                </div>
            </div>
            <div class="container">
                <div class="row">
                    <div class="col-md-6 col-lg-6 col-md-offset-3 col-lg-offset-3 col-sm-12 col-xs-12">
                        <div class="area-title center">
							<?php if ( ! empty( $settings['subtitle'] ) ): ?>
                                <h4 class="subtitle"><?php echo esc_html( $settings['subtitle'] ); ?></h4>
							<?php endif; ?>
							<?php if ( ! empty( $settings['title'] ) ): ?>
                                <h2><?php echo esc_html( $settings['title'] ); ?></h2>
							<?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="testmonial-slider">
							<?php
							if ( is_array( $quotes ) ) {
								foreach ( $quotes as $quote ) {
									?>
                                    <div class="single-testmonial">
                                        <div class="author-content">
                                            <p><?php echo $quote['quote'] ?></p>
                                        </div>
                                        <div class="author-name-and-thumb">
											<?php if ( ! empty( $quote['author_image']['url'] ) ) : ?>
                                                <div class="author-tumb"><img
                                                            src="<?php echo esc_url( $quote['author_image']['url'] ); ?>"
                                                            alt="Author image"></div>
											<?php endif; ?>
                                            <h4><?php echo $quote['author_name']; ?></h4>
                                            <p><?php echo $quote['author_designation']; ?></p>
                                        </div>
                                    </div>
									<?php
								}
							}
							?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--TESTMONIAL AREA END-->

        <script>
            /*---------------------------
				TESTMONIAL SLIDER
			-----------------------------*/
            jQuery(document).ready(function () {
                var testmonialCarousel = jQuery('.testmonial-slider');
                if (testmonialCarousel.length > 0) {
                    testmonialCarousel.owlCarousel({
                        merge: true,
                        smartSpeed: 1000,
                        loop: true,
                        nav: false,
                        center: false,
                        dots: true,
                        navText: ['<i class="dripicons-arrow-thin-left"></i>', '<i class="dripicons-arrow-thin-right"></i>'],
                        autoplay: true,
                        autoplayTimeout: 3000,
                        margin: 0,
                        responsiveClass: true,
                        responsive: {
                            0: {
                                items: 1
                            },
                            600: {
                                items: 2
                            },
                            1000: {
                                items: 3
                            },
                            1200: {
                                items: 3
                            }
                        }
                    });
                }
            });
        </script>
		<?php
	}
}