<?php

namespace ApplicCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class Applic_team extends Widget_Base {

	public function get_name() {
		return 'applic-team';
	}

	public function get_title() {
		return __( 'Team', 'applic-core' );
	}

	public function get_icon() {
		return 'eicon-person';
	}

	public function get_categories() {
		return [ 'applic-elements' ];
	}

	protected function _register_controls() {

		/* ------------------------------  Team content tab ------------------------------
		-------------------------------------------------------------------------------------*/
		/*-------------------------------- section content --------------------------------*/
		$this->start_controls_section(
			'section_id',
			[
				'label' => __( 'Section Content', 'applic-core' ),
			]
		);
		$this->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'How Does Applic Apps Processing Works'
			]
		);
		$this->add_control(
			'subtitle', [
				'label'       => esc_html__( 'Subtitle', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'WORKING PROGRESS'
			]
		);
		$this->end_controls_section(); // End section content

		/*-------------------------------- Team List --------------------------------*/
		$this->start_controls_section(
			'team_id',
			[
				'label' => __( 'Team List', 'applic-core' ),
			]
		);
		$this->add_control(
			'teams', [
				'label'       => __( 'Teams', 'applic-core' ),
				'type'        => Controls_Manager::REPEATER,
				'title_field' => '{{{ title }}}',
				'fields'      => [
					[
						'name'        => 'title',
						'label'       => __( 'Author name', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => 'Eh Jewel'
					],
					[
						'name'        => 'designation',
						'label'       => __( 'Designation', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
                        'default'     => 'CEO'
					],
                    [
                        'name'        => 'author_img',
                        'label'       => __( 'Author Image', 'applic-core' ),
                        'type'        => Controls_Manager::MEDIA,
                    ],
                    [
                        'name'        => 'social_icon1',
                        'label'       => __( 'Social Icon 1', 'applic-core' ),
                        'type'        => Controls_Manager::ICON,
                        'label_block' => true,
                    ],
                    [
                        'name'    => 'url1',
                        'label'   => __( 'Social URL 1', 'applic-core' ),
                        'type'    => Controls_Manager::URL,
                        'placeholder' => __( 'https://your-link.com', 'applic-core' ),
                        'show_external' => true,
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                        ],
                    ],
                    [
                        'name'        => 'social_icon2',
                        'label'       => __( 'Social Icon 2', 'applic-core' ),
                        'type'        => Controls_Manager::ICON,
                        'label_block' => true,
                    ],
                    [
                        'name'    => 'url2',
                        'label'   => __( 'Social URL 2', 'applic-core' ),
                        'type'    => Controls_Manager::URL,
                        'placeholder' => __( 'https://your-link.com', 'applic-core' ),
                        'show_external' => true,
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                        ],
                    ],
                    [
                        'name'        => 'social_icon3',
                        'label'       => __( 'Social Icon 3', 'applic-core' ),
                        'type'        => Controls_Manager::ICON,
                        'label_block' => true,
                    ],
                    [
                        'name'    => 'url3',
                        'label'   => __( 'Social URL 3', 'applic-core' ),
                        'type'    => Controls_Manager::URL,
                        'placeholder' => __( 'https://your-link.com', 'applic-core' ),
                        'show_external' => true,
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                        ],
                    ],
				],
			]
		);
		$this->end_controls_section(); // End Team


		/*-------------------------------- Team Style Tab --------------------------------*/
		/*----------------------- section title and subtitle ---------------------------- */
		$this->start_controls_section(
			'sec_style', [
				'label' => __( 'Section Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color', [
				'label'     => __( 'Title Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .team-area .area-title h2' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'typography_title',
				'selector' => '{{WRAPPER}} .team-area .area-title h2',
			]
		);
		$this->add_control(
			'subtitle_color', [
				'label'     => __( 'Subtitle Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .team-area .subtitle' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'typography_subtitle',
				'selector' => '{{WRAPPER}} .team-area .subtitle',
			]
		);
        $this->add_control(
            'team_bg',
            [
                'label' => __( 'Background Color', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
              
                'selectors' => [
                    '{{WRAPPER}} .team-area' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'sec_padding', [
                'label' => __( 'Section padding', 'applic-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .team-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '100',
                    'right' => '0',
                    'bottom' => '50',
                    'left' => '0',
                    'unit' => 'px', // The selected CSS Unit. 'px', '%', 'em',
                    'isLinked' => false,
                ],
            ]
        );
		$this->end_controls_section();

		/*----------------------- Team List Style  ---------------------------- */
		$this->start_controls_section(
			'team_style', [
				'label' => __( 'Team List Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			't_title_c', [
				'label'     => __( 'Title Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .single-team h3' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'd_color', [
				'label'     => __( 'Designation Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .single-team .designation' => 'color: {{VALUE}};',
				]
			]
		);

        $this->add_control(
            't_icon_color', [
                'label' => __( 'Icon Color', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
              
                'selectors' => [
                    '{{WRAPPER}} .member-social ul li a' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			's_bg_color', [
				'label' => __( 'Icon Background Color', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
			]
		);

		$this->add_control(
			's_bg_color2', [
				'label' => __( 'Icon Background Color 02', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .member-social'=> 'background: rgba(0, 0, 0, 0) linear-gradient(90deg, {{s_bg_color.VALUE}} 0%, {{VALUE}} 100%) repeat scroll 0 0;',
				],
			]
		);

		$this->start_controls_tabs(
			'owl_nav_tabs'
		);
		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => __( 'Normal', 'applic-core' ),
			]
		);
		$this->add_control(
			'owl_nav_color',
			[
				'label'     => __( 'Owl Navigation Icon Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .team-slider-two .owl-nav > div' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'owl_nav_hover_tab',
			[
				'label' => __( 'Hover', 'applic-core' ),
			]
		);
        $this->add_control(
            'owl_nav_color_h',
            [
                'label'     => __( 'Owl Navigation Icon Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .team-slider-two .owl-nav > div:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'n_bg_color', [
                'label' => __( 'Owl Navigation Background Color', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            'n_bg_color2', [
                'label' => __( 'Owl Navigation Background Color 02', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .team-slider-two .owl-nav > div:hover' => 'background: rgba(0, 0, 0, 0) linear-gradient(90deg, {{n_bg_color.VALUE}} 0%, {{VALUE}} 100%) repeat scroll 0 0;',
                ],
            ]
        );
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();
		$teams = isset($settings['teams']) ? $settings['teams'] : '';
		?>
		<!--TEAM AREA-->
		<section class="team-area">
			<div class="container">
				<div class="row">
					<div class="col-md-6 col-lg-6 col-sm-12 col-xs-12">
						<div class="area-title">
                            <?php if(!empty($settings['subtitle'])): ?>
							    <h4 class="subtitle"><?php echo esc_html($settings['subtitle']); ?></h4>
                            <?php endif; ?>
							<?php if(!empty($settings['title'])): ?>
							    <h2><?php echo esc_html($settings['title']); ?></h2>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<div class="row">
					<div class="col-md-12">
						<div class="team-slider-two">
                            <?php foreach ($teams as $team):
                                $target1 = $team['url1']['is_external'] ? ' target="_blank"' : '';
                                $target2 = $team['url2']['is_external'] ? ' target="_blank"' : '';
                                $target3 = $team['url3']['is_external'] ? ' target="_blank"' : '';

                                $nofollow1 = $team['url1']['nofollow'] ? ' rel="nofollow"' : '';
                                $nofollow2 = $team['url2']['nofollow'] ? ' rel="nofollow"' : '';
                                $nofollow3 = $team['url3']['nofollow'] ? ' rel="nofollow"' : '';
                                ?>
                                <div class="single-team">
                                    <div class="member-thumb">
                                        <?php if(!empty($team['author_img']['url'])): ?>
                                            <img src="<?php echo esc_url($team['author_img']['url'])?>" alt="Author Image">
                                        <?php endif; ?>
                                        <div class="member-social">
                                            <ul>
                                                <li><a <?php echo $target1 ; ?> <?php echo $nofollow1 ; ?> href="<?php echo esc_url($team['url1']['url']); ?>"><i class="<?php echo esc_attr($team['social_icon1']); ?>"></i></a></li>
                                                <li><a <?php echo $target2 ; ?> <?php echo $nofollow2 ; ?> href="<?php echo esc_url($team['url2']['url']); ?>"><i class="<?php echo esc_attr($team['social_icon2']); ?>"></i></a></li>
                                                <li><a <?php echo $target3 ; ?> <?php echo $nofollow3 ; ?> href="<?php echo esc_url($team['url3']['url']); ?>"><i class="<?php echo esc_attr($team['social_icon3']); ?>"></i></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                    <div class="name-designation">
                                        <h3><?php echo esc_html($team['title']); ?></h3>
                                        <p class="designation"><?php echo esc_html($team['designation']); ?></p>
                                    </div>
                                </div>
                            <?php endforeach; ?>
						</div>
					</div>
				</div>
			</div>
		</section>
		<!--TEAM AREA END-->
		<script>
            /*---------------------------
						 TEAM SLIDER
					 -----------------------------*/
            jQuery(document).ready(function () {
                var teamCarousel = jQuery('.team-slider-two');
                if (teamCarousel.length > 0) {
                    teamCarousel.owlCarousel({
                        merge: true,
                        smartSpeed: 1000,
                        loop: true,
                        nav: true,
                        center: false,
                        dots: false,
                        navText: ['<i class="dripicons-arrow-thin-left"></i>', '<i class="dripicons-arrow-thin-right"></i>'],
                        autoplay: true,
                        autoplayTimeout: 3000,
                        margin: 30,
                        responsiveClass: true,
                        responsive: {
                            0: {
                                items: 1,
                                nav:false,
                            },
                            600: {
                                items: 2,
                                nav:false,
                            },
                            1000: {
                                items: 3
                            },
                            1200: {
                                items: 3
                            },
                            1900: {
                                items: 3
                            }
                        }
                    });
                }
            });
		</script>
		<?php
	}


}
