<?php

namespace ApplicCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

use Elementor\Group_Control_Typography;


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class Applic_screenshot_area extends Widget_Base {

	public function get_name() {
		return 'applic-screenshot';
	}

	public function get_title() {
		return __( 'Screenshot Area', 'applic-core' );
	}

	public function get_icon() {
		return 'eicon-clone';
	}

	public function get_categories() {
		return [ 'applic-elements' ];
	}

	protected function _register_controls() {

		/* ------------------------------  Screenshot content tab ------------------------------
		-------------------------------------------------------------------------------------*/
		/* Screenshor section Markup */
		$this->start_controls_section(
			'scree_style_id',
			[
				'label' => __( 'Screenshot Section Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style', [
				'label'       => esc_html__( 'Markup Style', 'applic-core' ),
				'type'        => Controls_Manager::SELECT,
				'label_block' => true,
				'options'     => [
					'style_01' => esc_html__( 'Content With Slide Multi Image', 'applic-core' ),
					'style_02' => esc_html__( 'Content With Slide One Image', 'applic-core' ),
					'style_03' => esc_html__( 'Slide Only Image ', 'applic-core' )
				],
				'default'     => 'style_01'
			]
		);
		$this->end_controls_section(); // end hero section style
		/*-------------------------------- section content --------------------------------*/
		$this->start_controls_section(
			'screen_con',
			[
				'label'     => __( 'Section Content', 'applic-core' ),
				'condition' => [
					'style' => [ 'style_01', 'style_02' ]
				],
			]
		);
		$this->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Applic Apps Screenshot'
			]
		);
		$this->add_control(
			'subtitle', [
				'label'       => esc_html__( 'Subtitle', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'CLEAN DESIGN'
			]
		);
		$this->add_control(
			'desc', [
				'label'       => esc_html__( 'Description', 'applic-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default'     => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam quis no strud exercitation ullamco laboris nisi ut aliquip exea commodo consequat.'
			]
		);
		$this->end_controls_section(); // End section content

		/*-------------------------------- Screenshot Image List --------------------------------*/
		$this->start_controls_section(
			'feature_id',
			[
				'label' => __( 'Screenshot Image', 'applic-core' ),
			]
		);
		$this->add_control(
			's_gallery',
			[
				'label'   => __( 'Image', 'applic-core' ),
				'type'    => Controls_Manager::GALLERY,
				'default' => [],
			]
		);
		$this->end_controls_section(); // End title section

		/*
		 * Screenshot Style Tab
		 * */
		$this->start_controls_section(
			'sec_style', [
				'label' => __( 'Screenshot Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color', [
				'label'     => __( 'Title Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .screenshot-area .area-content h3' => 'color: {{VALUE}};',
				],
				'condition' => [
					'style' => [ 'style_01', 'style_02' ]
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'typography_title',
				
				'selector' => '{{WRAPPER}} .screenshot-area .area-content h3',
				'condition' => [
					'style' => [ 'style_01', 'style_02' ]
				],
			]
		);
		$this->add_control(
			'subtitle_color', [
				'label'     => __( 'Subtitle Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .screenshot-area .area-content h4' => 'color: {{VALUE}};',
				],
				'condition' => [
					'style' => [ 'style_01', 'style_02' ]
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'typography_subtitle',
				
				'selector' => '{{WRAPPER}} .screenshot-area .area-content h4',
				'condition' => [
					'style' => [ 'style_01', 'style_02' ]
				],
			]
		);
		$this->add_control(
			'desc_color', [
				'label'     => __( 'Description Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .screenshot-area .area-content p' => 'color: {{VALUE}};',
				],
				'condition' => [
					'style' => [ 'style_01', 'style_02' ]
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'typography_desc',
				
				'selector' => '{{WRAPPER}} .screenshot-area .area-content p',
				'condition' => [
					'style' => [ 'style_01', 'style_02' ]
				],
			]
		);
		$this->start_controls_tabs(
			'owl_nav_tabs'
		);
		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => __( 'Normal', 'applic-core' ),
			]
		);
		$this->add_control(
			'owl_nav_color',
			[
				'label'     => __( 'Owl Navigation Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .screenshot-area .owl-nav i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .screenshot-area .owl-carousel .owl-dots > div' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'owl_nav_hover_tab',
			[
				'label' => __( 'Hover', 'applic-core' ),
			]
		);
		$this->add_control(
			'owl_nav_color_hover',
			[
				'label'     => __( 'Owl Navigation Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .screenshot-area .owl-nav i:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .screenshot-area .owl-carousel .owl-dots > div.active' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
	}

	protected function render() {
		$settings    = $this->get_settings();
		$screenshots = isset( $settings['s_gallery'] ) ? $settings['s_gallery'] : '';
		if ( $settings['style'] == 'style_01' ) {
			?>
            <!--SCREENSHOT AREA-->
            <section class="screenshot-area fix section-padding">
                <div class="container">
                    <div class="row">
                        <div class="col-md-4 col-sm-6 col-xs-12">
                            <div class="area-content xs-center xs-mb50">
								<?php if ( ! empty( $settings['subtitle'] ) ): ?>
                                    <h4 class="subtitle"><?php echo esc_html( $settings['subtitle'] ); ?></h4>
								<?php endif; ?>
								<?php if ( ! empty( $settings['title'] ) ): ?>
                                    <h3><?php echo esc_html( $settings['title'] ); ?></h3>
								<?php endif; ?>
								<?php if ( ! empty( $settings['desc'] ) ): ?>
                                    <p><?php echo esc_html( $settings['desc'] ); ?></p>
								<?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-8 col-sm-6 col-xs-12">
                            <div class="screenshot-slider">
								<?php foreach ( $screenshots as $screenshot ) { ?>
                                    <div class="single-screenshot">
                                        <img src="<?php echo esc_url( $screenshot['url'] ) ?>" alt="">
                                    </div>
								<?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--SCREENSHOT AREA END-->
            <script>
                jQuery(document).ready(function () {
                    var screenshotCarousel = jQuery('.screenshot-slider');
                    if (screenshotCarousel.length > 0) {
                        screenshotCarousel.owlCarousel({
                            merge: true,
                            smartSpeed: 1000,
                            loop: true,
                            nav: true,
                            dots: false,
                            center: false,
                            navText: ['<i class="dripicons-arrow-thin-left"></i>', '<i class="dripicons-arrow-thin-right"></i>'],
                            autoplay: false,
                            autoplayTimeout: 3000,
                            margin: 0,
                            responsiveClass: true,
                            responsive: {
                                0: {
                                    center: true,
                                    nav: false,
                                    dots: true,
                                    items: 1
                                },
                                600: {
                                    nav: false,
                                    dots: true,
                                    items: 2
                                },
                                1000: {
                                    items: 3,
                                    nav: false,
                                    dots: true,
                                },
                                1200: {
                                    items: 3
                                },
                                1900: {
                                    items: 3
                                }
                            }
                        });
                    }
                });
            </script>


		<?php } elseif ( $settings['style'] == 'style_02' ) {
			?>
            <!--SCREENSHOT AREA-->
            <section class="screenshot-area fix section-padding" id="screenshots">
                <div class="container">
                    <div class="row">
                        <div class="col-md-4 col-sm-12 col-xs-12">
                            <div class="area-content xs-center sm-mb50 xs-mb50">
								<?php if ( ! empty( $settings['subtitle'] ) ): ?>
                                    <h4 class="subtitle"><?php echo esc_html( $settings['subtitle'] ); ?></h4>
								<?php endif; ?>
								<?php if ( ! empty( $settings['title'] ) ): ?>
                                    <h3><?php echo esc_html( $settings['title'] ); ?></h3>
								<?php endif; ?>
								<?php if ( ! empty( $settings['desc'] ) ): ?>
                                    <p><?php echo esc_html( $settings['desc'] ); ?></p>
								<?php endif; ?>
                            </div>
                        </div>
                        <div class="col-md-8 col-sm-12 col-xs-12">
                            <div class="screenshot-slider-4">
								<?php foreach ( $screenshots as $screenshot ) { ?>
                                    <div class="single-screenshot">
                                        <img src="<?php echo esc_url( $screenshot['url'] ) ?>" alt="">
                                    </div>
								<?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--SCREENSHOT AREA END-->

            <script>
                jQuery(document).ready(function () {
                    var screenshotCarousel = jQuery('.screenshot-slider-4');
                    if (screenshotCarousel.length > 0) {
                        screenshotCarousel.owlCarousel({
                            merge: true,
                            smartSpeed: 1000,
                            loop: true,
                            nav: true,
                            dots: false,
                            center: false,
                            navText: ['<i class="dripicons-arrow-thin-left"></i>', '<i class="dripicons-arrow-thin-right"></i>'],
                            autoplay: true,
                            autoplayTimeout: 3000,
                            margin: 0,
                            responsiveClass: true,
                            responsive: {
                                0: {
                                    center: true,
                                    items: 1
                                },
                                600: {
                                    items: 1
                                },
                                1000: {
                                    items: 1,
                                    nav:false,
                                },
                                1200: {
                                    items: 1
                                },
                                1900: {
                                    items: 1
                                }
                            }
                        });
                    }

                });
            </script>

		<?php } elseif ( $settings['style'] == 'style_03' ) {
			?>
            <!--SCREENSHOT AREA-->
            <section class="screenshot-area fix section-padding" id="screenshots">
                <div class="container-fluid">
                    <div class="row">
                        <div class="col-md-12 col-sm-12 col-xs-12">
                            <div class="screenshot-slider2">
								<?php foreach ( $screenshots as $screenshot ) { ?>
                                    <div class="single-screenshot">
                                        <img src="<?php echo esc_url( $screenshot['url'] ) ?>" alt="">
                                    </div>
								<?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--SCREENSHOT AREA END-->
            <script>
                jQuery(document).ready(function () {
                    var screenshotCarousel = jQuery('.screenshot-slider2');
                    if (screenshotCarousel.length > 0) {
                        screenshotCarousel.owlCarousel({
                            merge: true,
                            smartSpeed: 1000,
                            loop: true,
                            nav: false,
                            dots: true,
                            center: true,
                            navText: ['<i class="dripicons-arrow-thin-left"></i>', '<i class="dripicons-arrow-thin-right"></i>'],
                            autoplay: true,
                            autoplayTimeout: 3000,
                            margin: 0,
                            responsiveClass: true,
                            responsive: {
                                0: {
                                    center: true,
                                    nav: false,
                                    dots: true,
                                    items: 1
                                },
                                600: {
                                    nav: false,
                                    dots: true,
                                    items: 2
                                },
                                1000: {
                                    items: 3,
                                    nav: false,
                                    dots: true,
                                },
                                1200: {
                                    items: 3
                                },
                                1900: {
                                    items: 3
                                }
                            }
                        });
                    }

                });
            </script>

		<?php }
	}


}
