<?php

namespace ApplicCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class Applic_process_area extends Widget_Base {

	public function get_name() {
		return 'applic-process-area';
	}

	public function get_title() {
		return __( 'Process Area', 'applic-core' );
	}

	public function get_icon() {
		return 'eicon-toggle';
	}

	public function get_categories() {
		return [ 'applic-elements' ];
	}

	protected function _register_controls() {

		/* ------------------------------  Process Area content tab ------------------------------
		-------------------------------------------------------------------------------------*/
		/**
		 * Process Area Markup
		 **/
		$this->start_controls_section(
			'process_markup_id',
			[
				'label' => __( 'Process Area Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style', [
				'label'       => esc_html__( 'Markup Style', 'applic-core' ),
				'type'        => Controls_Manager::SELECT,
				'label_block' => true,
				'options'     => [
					'style_01' => esc_html__( 'Default List', 'applic-core' ),
					'style_02' => esc_html__( 'Box List', 'applic-core' )
				],
				'default'     => 'style_01'
			]
		);
		$this->end_controls_section(); // end Process Area Markup

		/**
		 * Process Area Section Content
		 **/
		$this->start_controls_section(
			'process_sec_id',
			[
				'label' => __( 'Process Area Section Content', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'p_title',
			[
				'label'       => __( 'Title', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => __( 'How Does Applic Apps Processing Works', 'applic-core' ),
			]
		);
		$this->add_control(
			's_title',
			[
				'label'       => __( 'Subtitle', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => __( 'WORKING PROGRESS', 'applic-core' ),
			]
		);

		$this->end_controls_section(); // end Section content
		/**
		 * Process Area List Item style one
		 **/
		$this->start_controls_section(
			'process_list_id',
			[
				'label'     => __( 'Process Area Lists', 'applic-core' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'style' => 'style_01',
				],
			]
		);
		$this->add_control(
			'process_lists', [
				'label'       => __( 'Add Item', 'applic-core' ),
				'type'        => Controls_Manager::REPEATER,
				'title_field' => '{{{ title }}}',
				'fields'      => [
					[
						'name'        => 'title',
						'label'       => __( 'Title', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => 'Log In First'
					],
					[
						'name'        => 'desc',
						'label'       => __( 'Description', 'applic-core' ),
						'type'        => Controls_Manager::TEXTAREA,
						'label_block' => true,
						'default'     => 'Lorem ipsum dolor sit ameconecte ur adipisicing elit sed do eiusmod tempor incididunt labore dolore magnad'
					],
					[
						'name'  => 'icon',
						'label' => __( 'Icon', 'applic-core' ),
						'type'  => Controls_Manager::ICON,

					]
				]
			]
		);
		$this->end_controls_section(); // end Process Area List style one

		/**
		 * Process Area List Item style two
		 **/
		$this->start_controls_section(
			'process_list_2_id',
			[
				'label'     => __( 'Process Area Lists', 'applic-core' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'style' => 'style_02',
				],
			]
		);
		$this->add_control(
			'process_2_lists', [
				'label'       => __( 'Add Item', 'applic-core' ),
				'type'        => Controls_Manager::REPEATER,
				'title_field' => '{{{ title }}}',
				'fields'      => [
					[
						'name'        => 'title',
						'label'       => __( 'Title', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => 'Log In First'
					],
					[
						'name'        => 'desc',
						'label'       => __( 'Description', 'applic-core' ),
						'type'        => Controls_Manager::TEXTAREA,
						'label_block' => true,
						'default'     => 'Lorem ipsum dolor sit ameconecte ur adipisicing elit sed do eiusmod tempor incididunt labore dolore magnad'
					],
					[
						'name'  => 'icon',
						'label' => __( 'Icon', 'applic-core' ),
						'type'  => Controls_Manager::ICON,

					],
					[
						'name'         => 'active',
						'label'        => __( 'Active', 'applic-core' ),
						'type'         => Controls_Manager::SWITCHER,
						'label_on'     => __( 'Active', 'applic-core' ),
						'label_off'    => __( 'Inactive', 'applic-core' ),
						'return_value' => 'yes',
						'default'      => 'yes',
					]

				],
			]
		);
		$this->end_controls_section(); // end Process Area List style one


		/*-------------------------------- Process Area Style Tab --------------------------------*/
		/*
		 * Process Area Background
		 */
		$this->start_controls_section(
			'process_bg_id',
			[
				'label' => __( 'Section Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
            'process_bg',
            [
                'label' => __( 'Background Color', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
              
                'selectors' => [
                    '{{WRAPPER}} .process-area' => 'background: {{VALUE}}',
                    '{{WRAPPER}} .process-two-area' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'sec_padding', [
                'label' => __( 'Section padding', 'applic-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .process-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .process-two-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '100',
                    'right' => '0',
                    'bottom' => '0',
                    'left' => '0',
                    'unit' => 'px', // The selected CSS Unit. 'px', '%', 'em',
                    'isLinked' => false,
                ],
            ]
        );

		$this->end_controls_section();

		/*
        * Process Area Section Title and Subtitle color
        */
		$this->start_controls_section(
			'process_sec_color_id',
			[
				'label' => __( 'Section Title & Subtitle Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'p_sec_title',
			[
				'label'       => __( 'Title Color', 'applic-core' ),
				'type'        => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .process-area .area-title h2, .process-two-area .area-title h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography_s_t',
				
				'selector' => '{{WRAPPER}} .process-area .area-title h2, .process-two-area .area-title h2',
			]
		);
		$this->add_control(
			'p_sec_sub',
			[
				'label'       => __( 'Subtitle Color', 'applic-core' ),
				'type'        => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .process-area .subtitle, .process-two-area .subtitle' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
		/*
        * Process Area Icon Style One
        */
		$this->start_controls_section(
			'p_icon_s_id',
			[
				'label' => __( 'Icon Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'style' => 'style_01',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'     => 'process_icon_bg_s',
				'label'    => __( 'Background', 'applic-core' ),
				'types'    => ['gradient'],
				'selector' => '{{WRAPPER}} .process-area .process-icon i',
			]
		);
		$this->add_control(
			'p_icon_bg',
			[
				'label'       => __( 'Icon Background', 'applic-core' ),
				'type'        => Controls_Manager::MEDIA,
			]
		);
		$this->end_controls_section();
		/*
        * Process Area Content Style One
        */
		$this->start_controls_section(
			'p_contnet_id',
			[
				'label' => __( 'Process List Content Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'style' => 'style_01',
				],
			]
		);
		$this->add_control(
			'p_l_title',
			[
				'label'       => __( 'Title Color', 'applic-core' ),
				'type'        => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .process-area .single-process-box h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'p_l_desc',
			[
				'label'       => __( 'Description Color', 'applic-core' ),
				'type'        => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .process-area .single-process-box p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'p_l_num',
			[
				'label'       => __( 'List Number Background Color', 'applic-core' ),
				'type'        => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .process-area .process-icon::before' => 'background: {{VALUE}};',
				],
			]
		);
        $this->start_controls_tabs(
            'p_bar_tabs'
        );
        $this->start_controls_tab(
            'bar_normal_tab',
            [
                'label' => __( 'Normal', 'applic-core' ),
            ]
        );
        $this->add_control(
            'bar_color',
            [
                'label'     => __( 'Process Bar Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .single-process-box::after' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'bar_hover_tab',
            [
                'label' => __( 'Hover', 'applic-core' ),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'bar_hover_color',
                'label'    => __( 'Background', 'applic-core' ),
                'types'    => ['gradient'],
                'selector' => '{{WRAPPER}} .single-process-box:hover::after',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();



		/*
        * Process Box Content Style Two
        */
		$this->start_controls_section(
			'p_box_id',
			[
				'label' => __( 'Process Box Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'style' => 'style_02',
				],
			]
		);

		$this->start_controls_tabs(
			'p_box_tabs'
		);
		$this->start_controls_tab(
			'p_box_normal',
			[
				'label' => __( 'Normal', 'applic-core' ),
			]
		);
		$this->add_control(
			'p_box_title',
			[
				'label'     => __( 'Title Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .single-process-box-two h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'p_box_desc',
			[
				'label'     => __( 'Description Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .single-process-box-two p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'p_box_icon',
			[
				'label'     => __( 'Icon Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .process-icon-two' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'p_box_icon_bg',
			[
				'label'     => __( 'Icon Background Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .process-icon-two' => 'background: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'p_box_bg',
			[
				'label'     => __( 'Box Background Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .single-process-box-two' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'p_box_hover',
			[
				'label' => __( 'Hover', 'applic-core' ),
			]
		);
		$this->add_control(
			'p_box_title_hover',
			[
				'label'     => __( 'Title Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .single-process-box-two:hover h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'p_box_desc_hover',
			[
				'label'     => __( 'Description Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .single-process-box-two:hover p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'p_box_icon_hover',
			[
				'label'     => __( 'Icon Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .single-process-box-two:hover .process-icon-two' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'p_box_icon_bg_h', [
				'label' => __( 'Icon Background Color', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
			]
		);

		$this->add_control(
			'p_box_icon_bg_h2', [
				'label' => __( 'Icon Background Color 02', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .process-icon-two:before' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{p_box_icon_bg_h.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
				],
			]
		);

		$this->add_control(
			'p_box_bg_h', [
				'label' => __( 'Box Background Color', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
			]
		);

		$this->add_control(
			'p_box_bg_h2', [
				'label' => __( 'Box Background Color 02', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-process-box-two:hover::before' => 'background: rgba(0, 0, 0, 0) linear-gradient(180deg, {{p_box_bg_h.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
				],
			]
		);
		$this->end_controls_tab();
		$this->start_controls_tab(
			'p_box_active',
			[
				'label' => __( 'Active', 'applic-core' ),
			]
		);
		$this->add_control(
			'p_box_title_active',
			[
				'label'     => __( 'Title Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .single-process-box-two.active h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'p_box_desc_active',
			[
				'label'     => __( 'Description Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .single-process-box-two.active p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'p_box_icon_active',
			[
				'label'     => __( 'Icon Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .single-process-box-two.active .process-icon-two' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'p_box_icon_bg_a', [
				'label' => __( 'Icon Background Color', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
			]
		);

		$this->add_control(
			'p_box_icon_bg_a2', [
				'label' => __( 'Icon Background Color 02', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-process-box-two.active .process-icon-two:before' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{p_box_icon_bg_a.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
				],
			]
		);

		$this->add_control(
			'p_box_bg_a', [
				'label' => __( 'Box Background Color', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
			]
		);

		$this->add_control(
			'p_box_bg_a2', [
				'label' => __( 'Box Background Color 02', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-process-box-two.active::before' => 'background: rgba(0, 0, 0, 0) linear-gradient(180deg, {{p_box_bg_a.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();


	}

	protected function render() {
		$settings = $this->get_settings();
		if ( $settings['style'] == 'style_01' ) {
			?>
            <!--PROCESS AREA-->
            <section class="process-area">
                <div class="container">
                    <div class="row">
                        <div class="col-md-6 col-lg-6 col-md-offset-3 col-lg-offset-3 col-sm-12 col-xs-12">
                            <div class="area-title center">
								<?php if ( ! empty( $settings['s_title'] ) ): ?>
                                    <h4 class="subtitle"><?php echo esc_html( $settings['s_title'] ); ?></h4>
								<?php endif; ?>
								<?php if ( ! empty( $settings['p_title'] ) ): ?>
                                    <h2><?php echo esc_html( $settings['p_title'] ); ?></h2>
								<?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <div class="process-content">
                                <div class="area-bg"></div>
                                <div class="row">
									<?php
									$f = 0.3;
									foreach ( $settings['process_lists'] as $p_list ): ?>
                                        <div class="col-md-4 col-sm-6 col-xs-12">
                                            <div class="single-process-box text-icon-box xs-mb50 wow fadeInLeft"
                                                 data-wow-delay="<?php echo $f; ?>s">
                                                <div style="background: url(<?php echo esc_url( $settings['p_icon_bg']['url'] ) ?>) no-repeat scroll center center / 100% 100%" class="process-icon"><i
                                                            class="<?php echo esc_attr( $p_list['icon'] ); ?>"></i>
                                                </div>
                                                <h3><?php echo esc_html( $p_list['title'] ); ?></h3>
                                                <p><?php echo esc_html( $p_list['desc'] ); ?></p>
                                            </div>
                                        </div>
										<?php
										$f = $f + 0.3;
									endforeach;
									?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--PROCESS AREA END-->
			<?php
		} elseif ( $settings['style'] == 'style_02' ) {
			?>
            <!--PROCESS AREA-->
            <section class="process-two-area">
                <div class="container">
                    <div class="row">
                        <div class="col-md-6 col-lg-6 col-md-offset-3 col-lg-offset-3 col-sm-12 col-xs-12">
                            <div class="area-title center">
								<?php if ( ! empty( $settings['s_title'] ) ): ?>
                                    <h4 class="subtitle"><?php echo esc_html( $settings['s_title'] ); ?></h4>
								<?php endif; ?>
								<?php if ( ! empty( $settings['p_title'] ) ): ?>
                                    <h2><?php echo esc_html( $settings['p_title'] ); ?></h2>
								<?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="row">
						<?php
						$i          = 1;
						$f          = 0.3;
						foreach ( $settings['process_2_lists'] as $p_list ):
							$m = ( $i % 3 == 0 ) ? 'mb50 mt40' : '';
							$active = 'yes' === $p_list['active'] ? 'active' : '';
							?>
                            <div class="col-md-4 col-sm-6 col-xs-12">
                                <div class="single-process-box-two text-icon-box mb50 mt40 wow fadeInLeft <?php echo $m; ?><?php echo $active; ?>"
                                     data-wow-delay="<?php echo $f; ?>s">
                                    <div class="process-icon-two"><i
                                                class="<?php echo esc_attr( $p_list['icon'] ); ?>"></i></div>
                                    <h3><?php echo esc_html( $p_list['title'] ); ?></h3>
                                    <p><?php echo esc_html( $p_list['desc'] ); ?></p>
                                </div>
                            </div>
							<?php
							$f = $f + 0.3;
						endforeach;
						?>

                    </div>
                </div>
            </section>
            <!--PROCESS AREA END-->
			<?php
		}
	}
}
