<?php

namespace ApplicCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class Applic_pricing extends Widget_Base {

	public function get_name() {
		return 'applic-pricing-table';
	}

	public function get_title() {
		return __( 'Pricing table', 'applic-core' );
	}

	public function get_icon() {
		return ' eicon-price-table';
	}

	public function get_categories() {
		return [ 'applic-elements' ];
	}

	protected function _register_controls() {

		/*
		*-------Pricing Table Content TAG
		* Section Title and Subtitle
		 * */
		$this->start_controls_section(
			'sec_id', [
				'label' => __( 'Section Content', 'applic-core' ),
			]
		);
		$this->add_control(
			'title', [
				'label'       => esc_html__( 'Title text', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Our Latest Pricing Plan'
			]
		);
		$this->add_control(
			'subtitle', [
				'label'       => esc_html__( 'Subtitle text', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'PRICING PLAN'
			]
		);
		$this->end_controls_section(); // End section content

		/*
        * Tab
         * */
		$this->start_controls_section(
			'tab_id', [
				'label' => __( 'Tab Content', 'applic-core' ),
			]
		);
		$this->add_control(
			't_one_text', [
				'label'       => esc_html__( 'Tab One Text', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Monthly'
			]
		);
		$this->add_control(
			't_two_text', [
				'label'       => esc_html__( 'Tab Two Text', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Yearly'
			]
		);
		$this->end_controls_section(); // End section content

		// ------------------------------ Pricing Table list ------------------------------
		$this->start_controls_section(
			'pricing_table', [
				'label' => __( 'Pricing Table', 'applic-core' ),
			]
		);

		$this->start_controls_tabs(
			'price_tabs'
		);
		$this->start_controls_tab(
			'price_monthly_tab',
			[
				'label' => __( 'Tab One', 'applic-core' ),
			]
		);
		$this->add_control(
			'm_tables', [
				'label'       => __( 'Pricing Tables', 'applic-core' ),
				'type'        => Controls_Manager::REPEATER,
				'title_field' => '{{{ title }}}',
				'fields'      => [
					[
						'name'        => 'title',
						'label'       => __( 'Table Name', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => 'BASIC PLAN'
					],
					[
						'name'         => 'promo',
						'label'        => __( 'Popular Item', 'applic-core' ),
						'type'         => Controls_Manager::SWITCHER,
						'label_on'     => __( 'Show', 'applic-core' ),
						'label_off'    => __( 'Hide', 'applic-core' ),
						'return_value' => 'yes',
						'default'      => 'yes',
					],
					[
						'name'        => 'promo_text',
						'label'       => __( 'Popular Item Label', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => 'popular',
						'condition'  => [
							'promo' => 'yes',
						]
					],
					[
						'name'        => 'promo_dis',
						'label'       => __( 'Discount Price', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => '-50%',
						'condition'  => [
							'promo' => 'yes',
						]
					],
					[
						'name'  => 'icon',
						'label' => __( 'Image Icon', 'applic-core' ),
						'type'  => Controls_Manager::MEDIA,
					],
					[
						'name'    => 'currency',
						'label'   => __( 'Currency', 'applic-core' ),
						'type'    => Controls_Manager::TEXT,
						'default' => '$',
					],
					[
						'name'    => 'price',
						'label'   => __( 'Price', 'applic-core' ),
						'type'    => Controls_Manager::TEXT,
						'default' => '0',
					],
					[
						'name'        => 'list_items',
						'label'       => __( 'List items', 'applic-core' ),
						'type'        => Controls_Manager::TEXTAREA,
						'label_block' => true,
						'default'     => '<li><i class="dripicons-checkmark"></i> Push Notifications</li>
										<li><i class="dripicons-checkmark"></i> Offline Synchronization</li>
										<li><i class="dripicons-checkmark"></i> SQL Database</li>
										<li><i class="dripicons-cross"></i> Speech & Text Analytics</li>
										<li><i class="dripicons-cross"></i> 24/7 Support</li>',
					],
					[
						'name'        => 'purchase_btn_label',
						'label'       => __( 'Purchase Button Label', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'default'     => 'Purchase',
						'label_block' => true
					],
					[
						'name'          => 'purchase_btn_url',
						'label'         => __( 'Purchase Button URL', 'applic-core' ),
						'type'          => Controls_Manager::URL,
						'default'       => [
							'url'         => '#',
							'is_external' => '',
						],
						'show_external' => true,
					],
				],
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'price_yearly_tab',
			[
				'label' => __( 'Tab Two', 'applic-core' ),
			]
		);
		$this->add_control(
			'y_tables', [
				'label'       => __( 'Pricing Tables', 'applic-core' ),
				'type'        => Controls_Manager::REPEATER,
				'title_field' => '{{{ title }}}',
				'fields'      => [
					[
						'name'        => 'title',
						'label'       => __( 'Table Name', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => 'BASIC PLAN'
					],
                    [
                        'name'         => 'promo',
                        'label'        => __( 'Popular Item', 'applic-core' ),
                        'type'         => Controls_Manager::SWITCHER,
                        'label_on'     => __( 'Show', 'applic-core' ),
                        'label_off'    => __( 'Hide', 'applic-core' ),
                        'return_value' => 'yes',
                        'default'      => 'yes',
                    ],
                    [
                        'name'        => 'promo_text',
                        'label'       => __( 'Popular Item Label', 'applic-core' ),
                        'type'        => Controls_Manager::TEXT,
                        'label_block' => true,
                        'default'     => 'popular',
                        'condition'  => [
                            'promo' => 'yes',
                        ]
                    ],
                    [
                        'name'        => 'promo_dis',
                        'label'       => __( 'Discount Price', 'applic-core' ),
                        'type'        => Controls_Manager::TEXT,
                        'label_block' => true,
                        'default'     => '-50%',
                        'condition'  => [
                            'promo' => 'yes',
                        ]
                    ],
					[
						'name'  => 'icon',
						'label' => __( 'Image Icon', 'applic-core' ),
						'type'  => Controls_Manager::MEDIA,
					],
					[
						'name'    => 'currency',
						'label'   => __( 'Currency', 'applic-core' ),
						'type'    => Controls_Manager::TEXT,
						'default' => '$',
					],
					[
						'name'    => 'price',
						'label'   => __( 'Price', 'applic-core' ),
						'type'    => Controls_Manager::TEXT,
						'default' => '0',
					],
					[
						'name'        => 'list_items',
						'label'       => __( 'List items', 'applic-core' ),
						'type'        => Controls_Manager::TEXTAREA,
						'label_block' => true,
						'default'     => '<li><i class="dripicons-checkmark"></i> Push Notifications</li>
										<li><i class="dripicons-checkmark"></i> Offline Synchronization</li>
										<li><i class="dripicons-checkmark"></i> SQL Database</li>
										<li><i class="dripicons-cross"></i> Speech & Text Analytics</li>
										<li><i class="dripicons-cross"></i> 24/7 Support</li>',
					],
					[
						'name'        => 'purchase_btn_label',
						'label'       => __( 'Purchase Button Label', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'default'     => 'Purchase',
						'label_block' => true
					],
					[
						'name'          => 'purchase_btn_url',
						'label'         => __( 'Purchase Button URL', 'applic-core' ),
						'type'          => Controls_Manager::URL,
						'default'       => [
							'url'         => '#',
							'is_external' => '',
						],
						'show_external' => true,
					],
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->end_controls_section(); // End Pricing List


		/**
		 * Style Tab
		 * ------------------------------ Pricing Style Tab ------------------------------
		 * Section Style
		 */
		$this->start_controls_section(
			'sec_style', [
				'label' => __( 'Section Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color', [
				'label'     => __( 'Title Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .pricing-area .area-title h2' => 'color: {{VALUE}};',
				],
				'default'   => '#1a264a'
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'typography_title',
				
				'selector' => '{{WRAPPER}} .pricing-area .area-title h2',
			]
		);
		$this->add_control(
			'subtitle_color', [
				'label'     => __( 'Subtitle Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .pricing-area .area-title .subtitle' => 'color: {{VALUE}};',
				],
				'default'   => '#1a264a'
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(), [
				'name'     => 'typography_subtitle',
				
				'selector' => '{{WRAPPER}} .pricing-area .area-title .subtitle',
			]
		);
		$this->end_controls_section();

		/*
         *  Tab Style
         * */
		$this->start_controls_section(
			'tab_style_id', [
				'label' => __( 'Tab Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs(
			'tab_tabs'
		);
		$this->start_controls_tab(
			'tab_normal',
			[
				'label' => __( 'Normal', 'applic-core' ),
			]
		);
		$this->add_control(
			't_text_color', [
				'label'     => __( 'Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-menu > li > a' => 'color: {{VALUE}};',
				]
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_hover',
			[
				'label' => __( 'Hover', 'applic-core' ),
			]
		);
		$this->add_control(
			't_text_h_color', [
				'label'     => __( 'Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-menu > li > a:hover' => 'color: {{VALUE}};',
				]
			]
		);

		$this->end_controls_tab();
		$this->start_controls_tab(
			'tab_active',
			[
				'label' => __( 'Active', 'applic-core' ),
			]
		);
		$this->add_control(
			't_text_a_color', [
				'label'     => __( 'Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .price-menu li.active a' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'tab_bg_color', [
				'label' => __( 'Tab Background Color', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
			]
		);

		$this->add_control(
			'tab_bg_color2', [
				'label' => __( 'Tab Background Color 02', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .price-menu li.active a' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{tab_bg_color.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
				],
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();


		/*
		 * Pricing Tab Content Style
		 * */
		$this->start_controls_section(
			'p_table_style', [
				'label' => __( 'Pricing Table Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs(
			'p_content_tabs'
		);
		$this->start_controls_tab(
			'p_c_n_tab',
			[
				'label' => __( 'Normal', 'applic-core' ),
			]
		);
		$this->add_control(
			't_n_c_n', [
				'label'     => __( 'Table Name Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .price-title' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'price_color', [
				'label'     => __( 'Table Price Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .price-rate' => 'color: {{VALUE}};',
				]
			]
		);

        $this->add_control(
            't_list_c_n', [
                'label'     => __( 'Table List Text Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .price-details' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'p_c_a_tab',
			[
				'label' => __( 'Active', 'applic-core' ),
			]
		);

        $this->add_control(
            't_n_c_a', [
                'label'     => __( 'Table Name Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
                
                'selectors' => [
                    '{{WRAPPER}} .single-price.active .price-title' => 'color: {{VALUE}};',
                ]
            ]
        );
        $this->add_control(
            'price_color_a', [
                'label'     => __( 'Table Price Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .single-price.active .price-rate' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            't_list_c_a', [
                'label'     => __( 'Table List Text Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
              
                'selectors' => [
                    '{{WRAPPER}} .single-price.active .price-details' => 'color: {{VALUE}};',
                ]
            ]
        );

		$this->add_control(
			'a_bg_color', [
				'label' => __( 'Background Color', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
			]
		);

		$this->add_control(
			'a_bg_color2', [
				'label' => __( 'Background Color 02', 'applic-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-price:before' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{a_bg_color.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		/*
         * Pricing Tab Popular Button Style
         * */
		$this->start_controls_section(
			'promo_style', [
				'label' => __( 'Popular Button Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'p_text_color', [
				'label'     => __( 'Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .sale-promo' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'p_bg_color', [
				'label'     => __( 'Background Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .sale-promo' => 'background: {{VALUE}};',
				]
			]
		);
		$this->end_controls_section();

		/*
        * Pricing Table Button Style
        */
		$this->start_controls_section(
			'p_button_id',
			[
				'label' => __( 'Purchase Button Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->start_controls_tabs(
			'p_btn_tabs'
		);
		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => __( 'Normal', 'applic-core' ),
			]
		);
		$this->add_control(
			'p_btn_label_color_n',
			[
				'label'     => __( 'Button Label Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				
				'selectors' => [
					'{{WRAPPER}} .single-price .purchase-button' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'p_btn_bg_color_n',
			[
				'label'     => __( 'Background Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .single-price .purchase-button' => 'background: {{VALUE}};',
				],
			]
		);
		$this->end_controls_tab();

        $this->start_controls_tab(
            'style_active_tab',
            [
                'label' => __( 'Active', 'applic-core' ),
            ]
        );
        $this->add_control(
            'p_btn_label_color_a',
            [
                'label'     => __( 'Button Label Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
              
                'selectors' => [
                    '{{WRAPPER}} .single-price.active .purchase-button' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'p_btn_bg_color_a',
            [
                'label'     => __( 'Background Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
              
                'selectors' => [
                    '{{WRAPPER}} .single-price.active .purchase-button' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => __( 'Hover', 'applic-core' ),
            ]
        );
        $this->add_control(
            'p_btn_label_color_h',
            [
                'label'     => __( 'Button Label Color', 'applic-core' ),
                'type'      => Controls_Manager::COLOR,
              
                'selectors' => [
                    '{{WRAPPER}} .single-price.active .purchase-button:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'p_btn_bg_color_h1', [
                'label' => __( 'Background Color 01', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            'p_btn_bg_color_h2', [
                'label' => __( 'Background Color 02', 'applic-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .purchase-button:hover' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{p_btn_bg_color_h1.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0 !important;',
                ],
            ]
        );
        $this->end_controls_tab();

		$this->end_controls_tabs();
		$this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings();
		$m_tables = isset( $settings['m_tables'] ) ? $settings['m_tables'] : '';
		$y_tables = isset( $settings['y_tables'] ) ? $settings['y_tables'] : '';
		?>
        <!--PRICEING AREA-->
        <section class="pricing-area padding-100-50" id="pricing">
            <div class="container">
                <div class="row flex-v-center">
                    <div class="col-md-6 col-lg-6 col-sm-12 col-xs-12">
                        <div class="area-title sm-center xs-center">
                            <?php if(!empty($settings['subtitle'])): ?>
                                <h4 class="subtitle"><?php echo esc_html( $settings['subtitle'] ); ?></h4>
                            <?php endif; ?>
                            <?php if(!empty($settings['title'])): ?>
                                <h2><?php echo esc_html( $settings['title'] ); ?></h2>
		                    <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6 col-sm-12 col-xs-12">
                        <div class="right price-right-menu sm-mb50 xs-mb50 sm-center xs-center">
                            <ul class="price-menu">
                                <li class="active"><a data-toggle="tab" href="#monthly"><?php echo esc_html($settings['t_one_text']); ?></a></li>
                                <li><a data-toggle="tab" href="#yearly"><?php echo esc_html($settings['t_two_text']); ?></a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <div class="tab-content">
                            <div id="monthly" class="tab-pane fade in active">
                                <div class="row">
									<?php
                                    if ( $m_tables )  {
										foreach ( $m_tables as $m_table ) {
											$purchase_btn        = $m_table['purchase_btn_url'];
											$purchase_btn_target = $purchase_btn['is_external'] ? 'target="_blank"' : '';
											$m_active = 'yes' === $m_table['promo']  ? 'active' : '';
											?>
                                            <div class="col-md-4">
                                                <div class="single-price mb50 <?php echo $m_active; ?>">
                                                    <?php if ( 'yes' === $m_table['promo'] ) : ?>
                                                        <div class="sale-promo"><?php echo esc_html($m_table['promo_text']); ?> <span><?php echo esc_html($m_table['promo_dis']); ?></span></div>
                                                    <?php endif; ?>
                                                    <div class="price-header">
                                                        <div class="price-thumb-hidding">
                                                            <img src="<?php echo esc_url( $m_table['icon']['url'] ); ?>"
                                                                 alt="Image Icon">
                                                            <div class="price-rate"><span
                                                                        class="currency"><?php echo esc_html( $m_table['currency'] ) ?></span><?php echo esc_html( $m_table['price'] ) ?>
                                                            </div>
                                                            <div class="price-title"><?php echo esc_html( $m_table['title'] ) ?></div>
                                                        </div>
                                                    </div>
                                                    <div class="price-details">
                                                        <ul>
															<?php echo $m_table['list_items']; ?>
                                                        </ul>
                                                    </div>
                                                    <div class="price-footer">
                                                        <a href="<?php echo esc_url( $purchase_btn['url'] ); ?>"
                                                           class="purchase-button" <?php echo $purchase_btn_target; ?>><?php echo esc_html( $m_table['purchase_btn_label'] ) ?></a>
                                                    </div>
                                                </div>
                                            </div>
											<?php
										}
									} ?>
                                </div>
                            </div>
                            <div id="yearly" class="tab-pane fade">
                                <div class="row">
									<?php if ( $y_tables ) {
										foreach ( $y_tables as $y_table ) {
											$purchase_btn        = $y_table['purchase_btn_url'];
											$purchase_btn_target = $purchase_btn['is_external'] ? 'target="_blank"' : '';
                                            $y_active = 'yes' === $y_table['promo']  ? 'active' : '';
											?>
                                            <div class="col-md-4">
                                                <div class="single-price mb50 <?php echo $y_active; ?>">
                                                    <?php if ( 'yes' === $y_table['promo'] ) : ?>
                                                        <div class="sale-promo"><?php echo esc_html($y_table['promo_text']); ?> <span><?php echo esc_html($y_table['promo_dis']); ?></span></div>
                                                    <?php endif; ?>
                                                    <div class="price-header">
                                                        <div class="price-thumb-hidding">
                                                            <img src="<?php echo esc_url( $y_table['icon']['url'] ); ?>"
                                                                 alt="Image Icon">
                                                            <div class="price-rate"><span
                                                                        class="currency"><?php echo esc_html( $y_table['currency'] ) ?></span><?php echo esc_html( $y_table['price'] ) ?>
                                                            </div>
                                                            <div class="price-title"><?php echo esc_html( $y_table['title'] ) ?></div>
                                                        </div>
                                                    </div>
                                                    <div class="price-details">
                                                        <ul>
															<?php echo $y_table['list_items']; ?>
                                                        </ul>
                                                    </div>
                                                    <div class="price-footer">
                                                        <a href="<?php echo esc_url( $purchase_btn['url'] ); ?>"
                                                           class="purchase-button" <?php echo $purchase_btn_target; ?>><?php echo esc_html( $y_table['purchase_btn_label'] ) ?></a>
                                                    </div>
                                                </div>
                                            </div>
											<?php
										}
									} ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <!--PRICEING AREA END-->
		<?php
	}

	protected function content_template() {
	}

}