<?php

namespace ApplicCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class Applic_hero extends Widget_Base {

	public function get_name() {
		return 'applic-hero';
	}

	public function get_title() {
		return __( 'Hero Section', 'applic-hero' );
	}

	public function get_icon() {
		return 'eicon-device-desktop';
	}

	public function get_categories() {
		return [ 'applic-elements' ];
	}

	protected function _register_controls() {

		/* -----------------------------------  Hero section content ------------------------------
        -------------------------------------------------------------------------------------------*/
		$this->start_controls_section(
			'hero_style_id',
			[
				'label' => __( 'Hero Section Style', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'style', [
				'label'       => esc_html__( 'Select Style', 'applic-core' ),
				'type'        => Controls_Manager::SELECT,
				'label_block' => true,
				'options'     => [
					'style_01' => esc_html__( 'Default Style', 'applic-core' ),
					'style_02' => esc_html__( 'Email Subscribe With Video Features', 'applic-core' ),
					'style_03' => esc_html__( 'Email Subscribe With Feature Image', 'applic-core' )
				],
				'default'     => 'style_01'
			]
		);
		$this->end_controls_section(); // end hero section style

		/* ----------------------------------  Hero content ------------------------------*/
		$this->start_controls_section(
			'hero_content',
			[
				'label' => __( 'Hero Content', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'h_title',
			[
				'label'       => esc_html__( 'Title Text', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Passing Your Apps Life<span>With Our Applic</span>'
			]
		);

		$this->add_control(
			'sub_title',
			[
				'label'       => esc_html__( 'Subtitle Text', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Best app landing'
			]
		);

		$this->add_control(
			'h_content',
			[
				'label'       => esc_html__( 'Content Text', 'applic-core' ),
				'type'        => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'default'     => 'Lorem ipsum dolor sit amet consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua enim ad minim veniam quis nostrud exercitation.',
				'condition'   => [
					'style' => 'style_01',
				],
			]
		);
		$this->end_controls_section(); // End Hero content

		/* ----------------------------------  Featured image for Style One ------------------------------*/
		$this->start_controls_section(
			'f_img_id', [
				'label'     => __( 'Featured Image', 'applic-core' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'style' => 'style_01',
				],
			]
		);

		$this->add_control(
			'img_layer', [
				'label'       => esc_html__( 'Featured Image Layer', 'applic-core' ),
				'type'        => Controls_Manager::SELECT,
				'label_block' => true,
				'options'     => [
					'layer_1' => esc_html__( 'Layer One', 'applic-core' ),
					'layer_2' => esc_html__( 'Layer Two', 'applic-core' ),
					'layer_3' => esc_html__( 'Layer Three', 'applic-core' )
				],
				'default'     => 'layer_1'
			]
		);

		$this->add_control(
			'f_img_s', [
				'label'   => __( 'Upload The Featured Image', 'applic-core' ),
				'type'    => Controls_Manager::GALLERY,
				'default' => [],
			]
		);

		$this->end_controls_section(); // End Featured image

        /* ----------------------------------  Featured image for Style Five ------------------------------*/
        $this->start_controls_section(
            'f_img_id_t', [
                'label'     => __( 'Featured Image', 'applic-core' ),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'style' => 'style_03',
                ],
            ]
        );

        $this->add_control(
            'f_img_s_t', [
                'label'   => __( 'Upload The Featured Image', 'applic-core' ),
                'type'    => Controls_Manager::MEDIA
            ]
        );

        $this->end_controls_section(); // End Featured image

		/* ----------------------------------  Video option ------------------------------*/
		$this->start_controls_section(
			'video_id', [
				'label'     => __( 'Video Options', 'applic-core' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'style' => 'style_02',
				],
			]
		);

		$this->add_control(
			'video_poster', [
				'label' => esc_html__( 'Video Poster', 'applic-core' ),
				'type'  => Controls_Manager::MEDIA,
			]
		);

		$this->start_controls_tabs( 'tabs_v_button_style' );

		$this->start_controls_tab(
			'v_button_normal',
			[
				'label' => __( 'Normal', 'applic-core' ),
			]
		);

		$this->add_control(
			'v_btn_icon_color', [
				'label'     => __( 'Video Button Icon Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video-button button' => 'color: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'v_btn_bg_color', [
				'label'     => __( 'Video Button Background Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video-button button' => 'background: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'v_button_hover',
			[
				'label' => __( 'Hover', 'applic-core' ),
			]
		);

		$this->add_control(
			'v_btn_icon_color_h', [
				'label'     => __( 'Video Button Icon Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video-button button:hover' => 'color: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'v_btn_bg_color_h', [
				'label'     => __( 'Video Button Background Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .video-button button:hover' => 'background: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'button_box_shadow',
				'selector' => '{{WRAPPER}} .video-button button',
			]
		);

		$this->end_controls_section(); // End video option
		/* ----------------------------------  Buttons ------------------------------*/
		$this->start_controls_section(
			'h_btn_id',
			[
				'label'     => __( 'Buttons', 'applic-core' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'style' => 'style_01',
				],
			]
		);

		$this->add_control(
			'buttons', [
				'label'       => __( 'Add Buttons', 'applic-core' ),
				'type'        => Controls_Manager::REPEATER,
				'title_field' => '{{{ label }}}',
				'fields'      => [
					[
						'name'        => 'label',
						'label'       => __( 'Button Name', 'applic-core' ),
						'type'        => Controls_Manager::TEXT,
						'label_block' => true,
						'default'     => 'DOWNLOAD'
					],
					[
						'name'    => 'url',
						'label'   => __( 'Button URL', 'applic-core' ),
						'type'    => Controls_Manager::URL,
						'default' => [
							'url' => '#'
						]
					],
					[
						'name'        => 'icon',
						'label'       => __( 'Icon', 'applic-core' ),
						'type'        => Controls_Manager::ICON,
						'label_block' => true,
						'default'     => '',
					],
					[
						'name'       => 'icon_indent',
						'label'      => __( 'Icon Hover Spacing', 'applic-core' ),
						'type'       => Controls_Manager::SLIDER,
						'size_units' => [ 'px' ],
						'range'      => [
							'px' => [
								'min'  => 0,
								'max'  => 30,
								'step' => 1,
							],
						],
						'default'    => [
							'unit' => 'px',
							'size' => 10,
						],
						'selectors'  => [
							'{{WRAPPER}} .home-button a:hover i' => 'margin-left: {{SIZE}}{{UNIT}};',
						],
						'condition'  => [
							'icon!' => '',
						],
					]

				],
			]
		);

		$this->end_controls_section(); // End Buttons

		/* ----------------------------------  Subscribe Form ------------------------------*/
		$this->start_controls_section(
			'subscribe_id', [
				'label'     => __( 'Subscribe Option', 'applic-core' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'style' => ['style_02', 'style_03'],
				],
			]
		);

		$this->add_control(
			'show_subscribe',
			[
				'label'        => __( 'Show Subscribe', 'applic-core' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'applic-core' ),
				'label_off'    => __( 'Hide', 'applic-core' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'subs_action', [
				'label'       => __( 'Action URL', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true
			]
		);

		$this->add_control(
			'subs_btn', [
				'label'       => __( 'Button Label', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'Subscribe'
			]
		);

		$this->add_control(
			'subs_pre', [
				'label'       => __( 'Preloader  Text', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'example@example.com'
			]
		);

		$this->start_controls_tabs( 'tabs_subs_button_style' );

		$this->start_controls_tab(
			'subs_button_normal',
			[
				'label' => __( 'Normal', 'applic-core' ),
			]
		);

		$this->add_control(
			'sbus_btn_text_color', [
				'label'     => __( 'Button Label Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .haeder-subscribe-form .subscribe-form button' => 'color: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'subs_btn_bg_color', [
				'label'     => __( 'Button Background Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .haeder-subscribe-form .subscribe-form button' => 'background: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'subs_button_hover',
			[
				'label' => __( 'Hover', 'applic-core' ),
			]
		);

		$this->add_control(
			'subs_btn_text_color_h',
            [
				'label'     => __( 'Button Label Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .haeder-subscribe-form .subscribe-form button:hover' => 'color: {{VALUE}}'
				],
			]
		);

		$this->add_control(
			'subs_btn_bg_color_h',
            [
				'label'     => __( 'Button Background Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .haeder-subscribe-form .subscribe-form button:hover' => 'background: {{VALUE}}',
				],
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section(); // End sponsors

		/* ----------------------------------  Sponsors Logo ------------------------------*/
		$this->start_controls_section(
			's_logo_id',
            [
				'label'     => __( 'Sponsors Option', 'applic-core' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
				'condition' => [
					'style' =>  ['style_02', 'style_03'],
				],
			]
		);

		$this->add_control(
			'show_sponsor',
			[
				'label'        => __( 'Show Sponsor', 'applic-core' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => __( 'Show', 'applic-core' ),
				'label_off'    => __( 'Hide', 'applic-core' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			's_title',
            [
				'label'       => __( 'Sponsors Title', 'applic-core' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'default'     => 'sponsors'
			]
		);

		$this->add_control(
			'logo_img_s',
            [
				'label'   => __( 'Upload The Sponsors Logo', 'applic-core' ),
				'type'    => Controls_Manager::GALLERY,
				'default' => [],
			]
		);

		$this->end_controls_section(); // End sponsors

		/* ----------------------------------  Hero Style Tab ------------------------------
		-------------------------------------------------------------------------------------------*/

		/*-------------------------------- hero background image -------------------------------*/
		$this->start_controls_section(
			'h_style_id', [
				'label' => __( 'Background', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'h_bg', [
				'label'   => esc_html__( 'Background Image', 'applic-core' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => [
					'url' => plugins_url( 'images/blue_bg.png', __FILE__ )
				]
			]
		);

		$this->end_controls_section();
		/*------------------------------ hero content style ------------------------------ */
		// title style
		$this->start_controls_section(
			'h_title_style',
			[
				'label' => __( 'Title', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => __( 'Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .welcome-text h1' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography_title',
				
				'selector' => '{{WRAPPER}} .welcome-text h1',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'text_shadow_h1',
				'selector' => '{{WRAPPER}} .welcome-text h1',
			]
		);
		$this->end_controls_section();
		// subtitle style
		$this->start_controls_section(
			'h_sub_title_style',
			[
				'label' => __( 'Subtitle', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'     => __( 'Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
			
				'selectors' => [
					'{{WRAPPER}} .welcome-text h4' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography_h4',
			
				'selector' => '{{WRAPPER}} .welcome-text h4',
			]
		);

		$this->add_group_control(
			Group_Control_Text_Shadow::get_type(),
			[
				'name'     => 'text_shadow_h4',
				'selector' => '{{WRAPPER}} .welcome-text h4',
			]
		);
		$this->end_controls_section();
		// content
		$this->start_controls_section(
			'h_content_style',
			[
				'label' => __( 'Content', 'applic-core' ),
				'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'style' =>  'style_01',
                ],
			]
		);
		$this->add_control(
			'content_color',
			[
				'label'     => __( 'Text Color', 'applic-core' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .welcome-text > p' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'typography_p',
				
				'selector' => '{{WRAPPER}} .welcome-text > p',
			]
		);

		$this->end_controls_section();


		// button style
		$this->start_controls_section(
			'btn_style_id',
			[
				'label' => __( 'Button', 'elementor' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->start_controls_tabs( 'tabs_button_style' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __( 'Normal', 'elementor' ),
			]
		);

		$this->add_control(
			'button_text_color',
			[
				'label'     => __( 'Text Color', 'elementor' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .home-button a' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'background_color',
			[
				'label'     => __( 'Background Color', 'elementor' ),
				'type'      => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .home-button a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __( 'Hover', 'elementor' ),
			]
		);

		$this->add_control(
			'hover_color',
			[
				'label'     => __( 'Text Color', 'elementor' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .home-button a:hover, {{WRAPPER}} .home-button a:focus' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button_background_hover_color',
			[
				'label'     => __( 'Background Color', 'elementor' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .home-button a:hover, {{WRAPPER}} .home-button a:focus' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();
		$buttons  = isset( $settings['buttons'] ) ? $settings['buttons'] : '';
		$s_logo_s = isset( $settings['logo_img_s'] ) ? $settings['logo_img_s'] : '';
		if ( $settings['style'] == 'style_01' ) {
			?>
            <!--WELCOME TEXT AREA-->
            <div class="welcome-text-area font16 white">
                <div style="background: url(<?php echo esc_url( $settings['h_bg']['url'] ) ?>) no-repeat scroll center center / 100% 100%"
                     class="area-bg"></div>
                <div class="welcome-area  section-padding">
                    <div class="container">
                        <div class="row flex-v-center">
                            <div class="col-md-7 col-lg-7 col-sm-12 col-xs-12">
                                <div class="welcome-text">
									<?php if ( ! empty( $settings['sub_title'] ) ) { ?>
                                        <h4 class="wow fadeInUp"
                                            data-wow-delay="0.3s"><?php echo esc_html( $settings['sub_title'] ); ?></h4>
									<?php } ?>
									<?php if ( ! empty( $settings['h_title'] ) ) { ?>
                                        <h1 class="wow fadeInUp"
                                            data-wow-delay="0.6s"><?php echo $settings['h_title']; ?></h1>
									<?php } ?>
									<?php if ( ! empty( $settings['h_content'] ) ) { ?>
                                        <p class="wow fadeInUp"
                                           data-wow-delay="0.9s"><?php echo esc_html( $settings['h_content'] ); ?></p>
									<?php } ?>
                                    <div class="home-button mt40 xs-mt40 wow fadeInUp" data-wow-delay="1.2s">
										<?php foreach ( $buttons as $button ) {
											$d_btn        = $button['url'];
											$d_btn_target = $d_btn['is_external'] ? 'target="_blank"' : '';
											?>
											<?php if ( ! empty( $button['icon'] ) ) { ?>
                                                <a <?php echo $d_btn_target; ?>
                                                        href="<?php echo esc_url( $button['url']['url'] ); ?>"><?php echo esc_html( $button['label'] ); ?>
                                                    <i
                                                            class="<?php echo esc_attr( $button['icon'] ); ?>"></i></a>
											<?php } else { ?>
                                                <a <?php echo $d_btn_target; ?> class="xs-mb20"
                                                                                href="<?php echo esc_url( $button['url']['url'] ); ?>"><?php echo esc_html( $button['label'] ); ?></a>
												<?php
											}
										}
										?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
					<?php if ( $settings['img_layer'] == 'layer_1' ) { ?>
                        <div class="welcome-layer-1 hidden-sm hidden-xs">
							<?php
							$i = 0;
							$l = 1;
							$d = 0.5;
							foreach ( $settings['f_img_s'] as $f_image ) :
								$fade = $i == 1 ? 'Up' : 'Right';
								?>
                                <div class="home1-layer-<?php echo $l; ?> wow fadeIn<?php echo $fade; ?>"
                                     data-wow-delay="<?php echo $d; ?>s">
                                    <img src="<?php echo esc_url( $f_image['url'] ); ?>" alt="">
                                </div>
								<?php
								++ $i;
								$l ++;
								$d = $d + 0.5;
							endforeach; ?>
                        </div>
					<?php } elseif ( $settings['img_layer'] == 'layer_2' ) { ?>
                        <div class="welcome-layer-2 hidden-sm hidden-xs">
							<?php
							$i = 0;
							$l = 1;
							$d = 0.5;
							foreach ( $settings['f_img_s'] as $f_image ) :
								$fade = $i == 1 ? 'Up' : 'Right';
								?>
                                <div class="home2-layer-<?php echo $l; ?> wow fadeIn<?php echo $fade; ?>"
                                     data-wow-delay="<?php echo $d; ?>s">
                                    <img src="<?php echo esc_url( $f_image['url'] ); ?>" alt="">
                                </div>
								<?php
								++ $i;
								$l ++;
								$d = $d + 0.5;
							endforeach; ?>
                        </div>
					<?php } elseif ( $settings['img_layer'] == 'layer_3' ) { ?>
                        <div class="welcome-layer-3 hidden-sm hidden-xs">
							<?php
							$i = 0;
							$l = 1;
							$d = 0.5;
							foreach ( $settings['f_img_s'] as $f_image ) :
								$fade = $i == 1 ? 'Up' : 'Right';
								?>
                                <div class="home3-layer-<?php echo $l; ?> wow fadeIn<?php echo $fade; ?>"
                                     data-wow-delay="<?php echo $d; ?>s">
                                    <img src="<?php echo esc_url( $f_image['url'] ); ?>" alt="">
                                </div>
								<?php
								++ $i;
								$l ++;
								$d = $d + 0.5;
							endforeach; ?>
                        </div>
					<?php } ?>
                </div>
            </div>
            <!--WELCOME TEXT AREA END-->
			<?php
		} elseif ( $settings['style'] == 'style_02' ) {
			?>
            <!--WELCOME TEXT AREA-->
            <div class="welcome-text-area font16 white">
                <div style="background: url(<?php echo esc_url( $settings['h_bg']['url'] ) ?>) no-repeat scroll center center / 100% 100%"
                     class="area-bg"></div>
                <div class="welcome-area section-padding">
                    <div class="container">
                        <div class="row flex-v-center">
                            <div class="col-md-7 col-lg-7 col-sm-12 col-xs-12">
                                <div class="welcome-text">
									<?php if ( ! empty( $settings['sub_title'] ) ) { ?>
                                        <h4 class="wow fadeInUp"
                                            data-wow-delay="0.3s"><?php echo esc_html( $settings['sub_title'] ); ?></h4>
									<?php } ?>
									<?php if ( ! empty( $settings['h_title'] ) ) { ?>
                                        <h1 class="wow fadeInUp"
                                            data-wow-delay="0.6s"><?php echo $settings['h_title']; ?></h1>
									<?php } ?>
									<?php
									if ( 'yes' === $settings['show_subscribe'] ) { ?>
                                        <div class="haeder-subscribe-form wow fadeInUp" data-wow-delay="0.9s">
                                            <form class="subscribe-form hidden-xs" action="<?php echo esc_url($settings['subs_action']); ?>">
                                                <input type="email" name="email" id="sub_email"
                                                       placeholder="<?php echo esc_attr($settings['subs_pre']); ?>">
                                                <button type="submit"><?php echo esc_html($settings['subs_btn']); ?></button>
                                            </form>
                                        </div>
									<?php }
									?>
                                </div>
                            </div>
                        </div>
                    </div>
					<?php
					if ( 'yes' === $settings['show_sponsor'] ) { ?>
                        <div class="top-sponsors wow fadeInLeft hidden-sm hidden-xs" data-wow-delay="1.3s">
                            <p><?php echo esc_html( $settings['s_title'] ); ?></p>
                            <div class="sponsor-slider">
								<?php
								foreach ( $s_logo_s as $s_logo ) {
									?>
                                    <div class="sngle-sponsor"><img src="<?php echo esc_url( $s_logo['url'] ); ?>"
                                                                    alt=""></div>
									<?php
								}
								?>
                            </div>
                        </div>
                        <script>

                            /*---------------------------
								   SPONSOR SLIDER HOME 4
							   -----------------------------*/
                            jQuery(document).ready(function () {
                                var screenshotCarousel = jQuery('.sponsor-slider');
                                if (screenshotCarousel.length > 0) {
                                    screenshotCarousel.owlCarousel({
                                        merge: true,
                                        smartSpeed: 1000,
                                        loop: true,
                                        nav: false,
                                        dots: false,
                                        center: false,
                                        navText: ['<i class="dripicons-arrow-thin-left"></i>', '<i class="dripicons-arrow-thin-right"></i>'],
                                        autoplay: true,
                                        autoplayTimeout: 3000,
                                        margin: 0,
                                        responsiveClass: true,
                                        responsive: {
                                            0: {
                                                center: true,
                                                items: 1
                                            },
                                            600: {
                                                items: 1
                                            },
                                            1000: {
                                                items: 2
                                            },
                                            1200: {
                                                items: 3
                                            },
                                            1900: {
                                                items: 3
                                            }
                                        }
                                    });
                                }
                            });
                        </script>
					<?php }
					?>
                    <div class="welcome-layer-4 hidden-sm hidden-xs">
                        <div class="home4-layer-1 wow fadeInRight" data-wow-delay="0.5s">
							<?php if ( ! empty( $settings['video_poster'] ) ): ?>
                                <img src="<?php echo $settings['video_poster']['url'] ?>" alt="">
							<?php endif; ?>
                            <div class="video-button item-center">
                                <button class="video-popup" data-video-id="7TUOI23spt0"><i class="fa fa-play"></i>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!--WELCOME TEXT AREA END-->
			<?php
		}elseif ( $settings['style'] == 'style_03' ){
		    ?>
            <!--WELCOME TEXT AREA-->
            <div class="welcome-text-area font16 white">
                <div style="background: url(<?php echo esc_url( $settings['h_bg']['url'] ) ?>) no-repeat scroll center center / 100% 100%"
                     class="area-bg"></div>
                <div class="welcome-area section-padding">
                    <div class="container">
                        <div class="row flex-v-center">
                            <div class="col-md-7 col-lg-7 col-sm-12 col-xs-12">
                                <div class="welcome-text">
                                    <?php if ( ! empty( $settings['sub_title'] ) ) { ?>
                                        <h4 class="wow fadeInUp"
                                            data-wow-delay="0.3s"><?php echo esc_html( $settings['sub_title'] ); ?></h4>
                                    <?php } ?>
                                    <?php if ( ! empty( $settings['h_title'] ) ) { ?>
                                        <h1 class="wow fadeInUp"
                                            data-wow-delay="0.6s"><?php echo $settings['h_title']; ?></h1>
                                    <?php } ?>
                                    <?php
                                    if ( 'yes' === $settings['show_subscribe'] ) { ?>
                                        <div class="haeder-subscribe-form wow fadeInUp" data-wow-delay="0.9s">
                                            <form class="subscribe-form hidden-xs" action="<?php echo esc_url($settings['subs_action']); ?>">
                                                <input type="email" name="email" id="sub_email"
                                                       placeholder="<?php echo esc_attr($settings['subs_pre']); ?>">
                                                <button type="submit"><?php echo esc_html($settings['subs_btn']); ?></button>
                                            </form>
                                        </div>
                                    <?php }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                    if ( 'yes' === $settings['show_sponsor'] ) { ?>
                        <div class="top-sponsors wow fadeInLeft hidden-sm hidden-xs" data-wow-delay="1.3s">
                            <p><?php echo esc_html( $settings['s_title'] ); ?></p>
                            <div class="sponsor-slider">
                                <?php
                                foreach ( $s_logo_s as $s_logo ) {
                                    ?>
                                    <div class="sngle-sponsor"><img src="<?php echo esc_url( $s_logo['url'] ); ?>"
                                                                    alt=""></div>
                                    <?php
                                }
                                ?>
                            </div>
                        </div>
                        <script>

                            /*---------------------------
								   SPONSOR SLIDER HOME 4
							   -----------------------------*/
                            jQuery(document).ready(function () {
                                var screenshotCarousel = jQuery('.sponsor-slider');
                                if (screenshotCarousel.length > 0) {
                                    screenshotCarousel.owlCarousel({
                                        merge: true,
                                        smartSpeed: 1000,
                                        loop: true,
                                        nav: false,
                                        dots: false,
                                        center: false,
                                        navText: ['<i class="dripicons-arrow-thin-left"></i>', '<i class="dripicons-arrow-thin-right"></i>'],
                                        autoplay: true,
                                        autoplayTimeout: 3000,
                                        margin: 0,
                                        responsiveClass: true,
                                        responsive: {
                                            0: {
                                                center: true,
                                                items: 1
                                            },
                                            600: {
                                                items: 1
                                            },
                                            1000: {
                                                items: 2
                                            },
                                            1200: {
                                                items: 3
                                            },
                                            1900: {
                                                items: 3
                                            }
                                        }
                                    });
                                }
                            });
                        </script>
                    <?php }
                    ?>
                    <div class="welcome-layer-5 hidden-sm hidden-xs">
                        <div class="home5-layer-1 wow fadeInRight" data-wow-delay="0.5s">
                            <?php if ( ! empty( $settings['f_img_s_t'] ) ): ?>
                                <img src="<?php echo $settings['f_img_s_t']['url'] ?>" alt="">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <!--WELCOME TEXT AREA END-->
            <?php
        }
	}
}
