<?php

namespace ApplicCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;


// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Text Typing Effect
 *
 * Elementor widget for text typing effect.
 *
 * @since 1.7.0
 */
class Applic_goal_area extends Widget_Base
{

    public function get_name()
    {
        return 'applic-goal-area';
    }

    public function get_title()
    {
        return __('Goal Area', 'applic-core');
    }

    public function get_icon()
    {
        return 'eicon-time-line';
    }

    public function get_categories()
    {
        return ['applic-elements'];
    }

    protected function _register_controls()
    {

        /* ------------------------------  Goal Area content tab ------------------------------
        -------------------------------------------------------------------------------------*/
        /**
         * Goal Area Section Content
         **/
        $this->start_controls_section(
            'goal_content_id',
            [
                'label' => __('Goal Section Content', 'applic-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'g_title',
            [
                'label' => __('Title', 'applic-core'),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Perfect Solutions For Smart Business', 'applic-core'),
            ]
        );
        $this->add_control(
            'g_subtitle',
            [
                'label' => __('Subtitle', 'applic-core'),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => __('Lorem ipsum dolor sit amet, consectetur adipisicing elit sed do eiu smod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequ atuis aute irure dolor inrep.', 'applic-core'),
            ]
        );
        $this->add_control(
            'g_list_s',
            [
                'label' => __('Goal List Show/Hide', 'applic-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'applic-core'),
                'label_off' => __('Hide', 'applic-core'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'g_lists', [
                'label' => __('Add Goal List Content', 'applic-core'),
                'type' => Controls_Manager::REPEATER,
                'label_block' => true,
                'title_field' => '{{{ title }}}',
                'fields' => [
                    [
                        'name' => 'title',
                        'label' => __('List Content', 'applic-core'),
                        'type' => Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => 'Good Design Quality'
                    ]
                ],
                'condition' => [
                    'g_list_s' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'g_btns', [
                'label' => __('Add Button', 'applic-core'),
                'type' => Controls_Manager::REPEATER,
                'title_field' => '{{{ label }}}',
                'fields' => [
                    [
                        'name' => 'label',
                        'label' => __('Lebel', 'applic-core'),
                        'type' => Controls_Manager::TEXT,
                        'label_block' => true,
                        'default' => 'Contact Us'
                    ],
                    [
                        'name' => 'btn_link',
                        'label' => __('Button URL', 'applic-core'),
                        'type' => Controls_Manager::URL,
                        'placeholder' => __('https://your-link.com', 'applic-core'),
                        'show_external' => true,
                        'default' => [
                            'url' => '',
                            'is_external' => true,
                            'nofollow' => true,
                        ]
                    ],
                    [
                        'name' => 'active',
                        'label' => __('Active Button Show/Hide', 'applic-core'),
                        'type' => Controls_Manager::SWITCHER,
                        'label_on' => __('Show', 'applic-core'),
                        'label_off' => __('Hide', 'applic-core'),
                        'return_value' => 'yes',
                        'default' => 'yes',
                    ],
                ]
            ]
        );
        $this->end_controls_section(); // end Section content

        /**
         * Feature Image Markup
         **/
        $this->start_controls_section(
            'g_f_img_id',
            [
                'label' => __('Goal Feature Image', 'applic-core'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'style', [
                'label' => esc_html__('Markup Style', 'applic-core'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'options' => [
                    'style_01' => esc_html__('Scroll Animation Image', 'applic-core'),
                    'style_02' => esc_html__('Fixed Image', 'applic-core'),
                    'style_03' => esc_html__('Carousel Image', 'applic-core')
                ],
                'default' => 'style_01'
            ]
        );
        $this->add_control(
            'g_f_gallery',
            [
                'label' => __('Feature Image', 'applic-core'),
                'type' => Controls_Manager::GALLERY,
                'default' => [],
                'condition' => [
                    'style' => ['style_01', 'style_03'],
                ]
            ]
        );

        $this->add_control(
            'g_f_image',
            [
                'label' => __('Feature Image', 'applic-core'),
                'type' => Controls_Manager::MEDIA,
                'condition' => [
                    'style' => 'style_02',
                ]
            ]
        );
        $this->end_controls_section(); // End Feature Iamge Markup


        /*-------------------------------- Goal Area Style Tab --------------------------------*/
        /*
         * goal section background color
         * */
        $this->start_controls_section(
            'goal_bg_id',
            [
                'label' => __('Background', 'applic-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'goal_bg_color',
            [
                'label' => __('Background Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .goal-area' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /*
        * Goal Area Section Title and Subtitle color
        */
        $this->start_controls_section(
            'goal_sec_id',
            [
                'label' => __('Section Title & Subtitle Style', 'applic-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'g_title_style',
            [
                'label' => __('Title Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .goal-area .area-content h3' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography_s_title',
               
                'selector' => '{{WRAPPER}} .goal-area .area-content h3',
            ]
        );
        $this->add_control(
            'g_subtitle_style',
            [
                'label' => __('Subtitle Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
              
                'selectors' => [
                    '{{WRAPPER}} .goal-area .area-content p' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'typography_s_subtitle',
               
                'selector' => '{{WRAPPER}} .goal-area .area-content p',
            ]
        );
        $this->end_controls_section();

        /*
        * Goal Area List Style
        */
        $this->start_controls_section(
            'goal_list_style',
            [
                'label' => __('Goal List Color', 'applic-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'g_list_s' => 'yes',
                ]
            ]
        );
        $this->add_control(
            'g_list_style',
            [
                'label' => __('Goal List Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .goal-area .features-list li' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /*
        * Goal Area Button Style
        */
        $this->start_controls_section(
            'goal_button_id',
            [
                'label' => __('Goal Button Style', 'applic-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->start_controls_tabs(
            'g_btn_tabs'
        );
        $this->start_controls_tab(
            'style_normal_tab',
            [
                'label' => __('Normal', 'applic-core'),
            ]
        );
        $this->add_control(
            'g_btn_label_color',
            [
                'label' => __('Button Label Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .goal-area .read-more' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'g_btn_bg_color',
            [
                'label' => __('Background Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
              
                'selectors' => [
                    '{{WRAPPER}} .goal-area .read-more' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_hover_tab',
            [
                'label' => __('Hover', 'applic-core'),
            ]
        );
        $this->add_control(
            'g_btn_label_color_hover',
            [
                'label' => __('Button Label Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .goal-area a.read-more:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'btn_bg_color', [
                'label' => __('Button Background Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            'btn_bg_color2', [
                'label' => __('Button Background Color 02', 'applic-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .goal-area .read-more::before' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{btn_bg_color.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_active_tab',
            [
                'label' => __('Active', 'applic-core'),
            ]
        );
        $this->add_control(
            'g_btn_a_color',
            [
                'label' => __('Button Label Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .goal-area .read-more.active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'btn_bg_color_a', [
                'label' => __('Button Background Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
            ]
        );

        $this->add_control(
            'btn_bg_color2_a', [
                'label' => __('Button Background Color 02', 'applic-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .goal-area .active:hover::before' => 'background: rgba(0, 0, 0, 0) linear-gradient(135deg, {{btn_bg_color_a.VALUE}} 0%, {{VALUE}} 99%) repeat scroll 0 0;',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();
        $this->end_controls_section();

        /*
        * Goal Owl Dot style
        */
        $this->start_controls_section(
            'owl_dot_id',
            [
                'label' => __('Owl Navigation Color', 'applic-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'style' => ['style_03'],
                ]
            ]
        );
        $this->start_controls_tabs(
            'owl_nav_tabs'
        );
        $this->start_controls_tab(
            'owl_nav_normal',
            [
                'label' => __('Normal', 'applic-core'),
            ]
        );
        $this->add_control(
            'owl_nav_color',
            [
                'label' => __('Owl Dots Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .owl-carousel .owl-dots > div' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'owl_nav_hover',
            [
                'label' => __('Hover', 'applic-core'),
            ]
        );
        $this->add_control(
            'owl_nav_color_hover',
            [
                'label' => __('Owl Dots Color', 'applic-core'),
                'type' => Controls_Manager::COLOR,
               
                'selectors' => [
                    '{{WRAPPER}} .owl-carousel .owl-dots > div.active' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

    }

    protected function render()
    {
        $settings = $this->get_settings();
        $g_lists = isset($settings['g_lists']) ? $settings['g_lists'] : '';
        $target = !empty($settings['btn_link']['is_external']) ? ' target="_blank"' : '';
        $nofollow = !empty($settings['btn_link']['nofollow']) ? ' rel="nofollow"' : '';
        ?>
        <!--GOAL AREA-->
        <section class="goal-area section-padding">
            <div class="container">
                <div class="row flex-v-center">
                    <div class="col-md-6 col-lg-6 col-sm-12 col-xs-12">
                        <div class="area-content sm-center xs-center wow fadeInLeft" data-wow-delay="0.3s">
                            <?php if (!empty($settings['g_title'])): ?>
                                <h3><?php echo esc_html($settings['g_title']); ?></h3>
                            <?php endif; ?>
                            <?php if (!empty($settings['g_subtitle'])): ?>
                                <p><?php echo esc_html($settings['g_subtitle']); ?></p>
                            <?php endif; ?>
                            <?php if ('yes' === $settings['g_list_s']) { ?>
                                <ul class="features-list">
                                    <?php foreach ($g_lists as $g_list): ?>
                                        <li>
                                            <i class="dripicons-checkmark"></i> <?php echo esc_html($g_list['title']); ?>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php } ?>
                            <?php foreach ($settings['g_btns'] as $g_btn):
                                $active = 'yes' === $g_btn['active'] ? 'active' : '';
                                echo '<a class="read-more ' . $active . '" href="' . $g_btn['btn_link']['url'] . '"' . $target . $nofollow . '>' . $g_btn['label'] . '</a>';
                                ?>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php if ($settings['style'] == 'style_01') { ?>
                        <div class="col-md-5 col-lg-5 col-md-offset-1 col-lg-offset-1 col-sm-12 col-xs-12">
                            <div class="area-image-content hidden-sm hidden-xs wow fadeIn" data-wow-delay="0.6s">
                                <div class="goal-layers">
                                    <?php
                                    $i = 1;
                                    foreach ($settings['g_f_gallery'] as $g_f_imag):
                                        if ($i == 1) { ?>
                                            <div class="goal-layer-<?php echo $i; ?>"><img
                                                        src="<?php echo esc_url($g_f_imag['url']); ?>"
                                                        alt="layer image"></div>
                                            <?php
                                        } else {
                                            $d_p = $i == 2 ? '180' : '70';
                                            ?>
                                            <div class="goal-layer-<?php echo $i; ?>"
                                                 data-parallax='{"y": <?php echo $d_p; ?>}'><img
                                                        src="<?php echo esc_url($g_f_imag['url']); ?>"
                                                        alt="layer image">
                                            </div>
                                            <?php
                                        }
                                        $i++;
                                    endforeach; ?>
                                </div>
                            </div>
                        </div>
                    <?php } elseif ($settings['style'] == 'style_02') { ?>
                        <div class="col-md-6 col-lg-6 col-sm-12 col-xs-12">
                            <div class="area-image-content hidden-sm hidden-xs wow fadeInRight" data-wow-delay="0.6s">
                                <img src="<?php echo esc_url($settings['g_f_image']['url']); ?>" alt="feature image">
                            </div>
                        </div>
                    <?php } elseif ($settings['style'] == 'style_03') { ?>
                        <div class="col-md-6 col-lg-6 col-sm-12 col-xs-12">
                            <div class="area-image-content hidden-sm hidden-xs wow fadeInRight" data-wow-delay="0.6s">
                                <div class="features-screenshot-slider">
                                    <?php
                                    foreach ($settings['g_f_gallery'] as $g_f_imag):
                                        ?>
                                        <div class="single-screen">
                                            <img src="<?php echo esc_url($g_f_imag['url']); ?>" alt="Feature Image">
                                        </div>
                                    <?php
                                    endforeach; ?>
                                </div>
                            </div>
                        </div>
                        <script>
                            jQuery(document).ready(function () {
                                var screenshotCarousel = jQuery('.features-screenshot-slider');
                                if (screenshotCarousel.length > 0) {
                                    screenshotCarousel.owlCarousel({
                                        merge: true,
                                        smartSpeed: 1000,
                                        loop: true,
                                        nav: false,
                                        dots: true,
                                        center: true,
                                        navText: ['<i class="dripicons-arrow-thin-left"></i>', '<i class="dripicons-arrow-thin-right"></i>'],
                                        autoplay: true,
                                        autoplayTimeout: 3000,
                                        margin: 0,
                                        responsiveClass: true,
                                        responsive: {
                                            0: {
                                                center: true,
                                                items: 1
                                            },
                                            600: {
                                                items: 2
                                            },
                                            1000: {
                                                items: 3,
                                            },
                                            1200: {
                                                items: 3
                                            },
                                            1900: {
                                                items: 3
                                            }
                                        }
                                    });
                                }
                            });
                        </script>
                    <?php } ?>
                </div>
            </div>
        </section>
        <!--GOAL AREA END-->
        <?php
    }
}
